/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.el.ELProcessor;
import javax.enterprise.inject.spi.BeanManager;

public class TomEEELInvocationHandler
implements InvocationHandler {
    private final Annotation annotation;
    private final ELProcessor processor;

    public TomEEELInvocationHandler(Annotation annotation, ELProcessor processor) {
        this.annotation = annotation;
        this.processor = processor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().endsWith("Expression") && method.getReturnType().equals(String.class)) {
            return method.invoke((Object)this.annotation, args);
        }
        try {
            Method expressionMethod = this.annotation.getClass().getDeclaredMethod(method.getName() + "Expression", method.getParameterTypes());
            String expression = (String)expressionMethod.invoke(proxy, args);
            if (!expression.isEmpty()) {
                return this.eval(expression, method.getReturnType());
            }
            return method.invoke((Object)this.annotation, args);
        }
        catch (NoSuchMethodException e) {
            return method.invoke((Object)this.annotation, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object eval(String expression, Class<?> expectedType) {
        String sanitizedExpression = expression.replaceAll("^[#$]\\{(.+)}$", "$1");
        return this.processor.getValue(sanitizedExpression, expectedType);
    }

    public static <T extends Annotation> T of(Class<T> annotationClass, T annotation, BeanManager beanManager) {
        ELProcessor elProcessor = new ELProcessor();
        elProcessor.getELManager().addELResolver(beanManager.getELResolver());
        return (T)((Annotation)Proxy.newProxyInstance(annotation.getClass().getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new TomEEELInvocationHandler(annotation, elProcessor)));
    }

    public static <T extends Annotation> T of(Class<T> annotationClass, T annotation, ELProcessor elProcessor) {
        return (T)((Annotation)Proxy.newProxyInstance(annotation.getClass().getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new TomEEELInvocationHandler(annotation, elProcessor)));
    }
}

