/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.api.listener.JobListener;
import org.apache.batchee.container.impl.jobinstance.RuntimeJobExecution;
import org.apache.batchee.container.proxy.InjectionReferences;
import org.apache.batchee.container.proxy.ProxyFactory;
import org.apache.batchee.container.services.ServicesManager;
import org.apache.batchee.jaxb.JSLJob;
import org.apache.batchee.jaxb.Listener;
import org.apache.batchee.jaxb.Listeners;
import org.apache.batchee.jaxb.Property;
import org.apache.batchee.jaxb.Step;
import org.apache.batchee.spi.BatchArtifactFactory;

public class ListenerFactory {
    private final BatchArtifactFactory factory;
    private final List<ListenerInfo> jobLevelListenerInfo;
    private final Map<String, List<ListenerInfo>> stepLevelListenerInfo = new ConcurrentHashMap<String, List<ListenerInfo>>();

    public ListenerFactory(BatchArtifactFactory factory, JSLJob jobModel, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        this.jobLevelListenerInfo = new ArrayList<ListenerInfo>();
        this.factory = factory;
        Listeners jobLevelListeners = jobModel.getListeners();
        this.jobLevelListenerInfo.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.job.listeners.before", injectionRefs, execution));
        if (jobLevelListeners != null) {
            for (Listener listener : jobLevelListeners.getListenerList()) {
                this.jobLevelListenerInfo.add(ListenerFactory.createListener(factory, listener, injectionRefs, execution));
            }
        }
        this.jobLevelListenerInfo.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.job.listeners.after", injectionRefs, execution));
    }

    private static Collection<ListenerInfo> globalListeners(BatchArtifactFactory factory, String key, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        String globalListeners = ServicesManager.value(key, null);
        if (globalListeners != null) {
            String[] refs = globalListeners.split(",");
            ArrayList<ListenerInfo> list = new ArrayList<ListenerInfo>(refs.length);
            for (String ref : refs) {
                Listener listener = new Listener();
                listener.setRef(ref);
                list.add(ListenerFactory.createListener(factory, listener, injectionRefs, execution));
            }
            return list;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ListenerInfo> getStepListenerInfo(BatchArtifactFactory factory, Step step, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfoList = this.stepLevelListenerInfo.get(step.getId());
        if (stepListenerInfoList == null) {
            ListenerFactory listenerFactory = this;
            synchronized (listenerFactory) {
                stepListenerInfoList = this.stepLevelListenerInfo.get(step.getId());
                if (stepListenerInfoList == null) {
                    stepListenerInfoList = new ArrayList<ListenerInfo>();
                    this.stepLevelListenerInfo.put(step.getId(), stepListenerInfoList);
                    stepListenerInfoList.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.step.listeners.before", injectionRefs, execution));
                    Listeners stepLevelListeners = step.getListeners();
                    if (stepLevelListeners != null) {
                        for (Listener listener : stepLevelListeners.getListenerList()) {
                            stepListenerInfoList.add(ListenerFactory.createListener(factory, listener, injectionRefs, execution));
                        }
                    }
                    stepListenerInfoList.addAll(ListenerFactory.globalListeners(factory, "org.apache.batchee.step.listeners.after", injectionRefs, execution));
                }
            }
        }
        return stepListenerInfoList;
    }

    private static ListenerInfo createListener(BatchArtifactFactory factory, Listener listener, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        String id = listener.getRef();
        List<Property> propList = listener.getProperties() == null ? null : listener.getProperties().getPropertyList();
        injectionRefs.setProps(propList);
        Object listenerArtifact = ProxyFactory.loadArtifact(factory, id, injectionRefs, execution);
        if (listenerArtifact == null) {
            throw new IllegalArgumentException("Load of artifact id: " + id + " returned <null>.");
        }
        return new ListenerInfo(listenerArtifact);
    }

    public List<JobListener> getJobListeners(InjectionReferences injectionRefs) {
        ArrayList<JobListener> retVal = new ArrayList<JobListener>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!JobListener.class.isAssignableFrom(li.getArtifact().getClass())) continue;
            retVal.add(ProxyFactory.createProxy((JobListener)li.getArtifact(), injectionRefs, new String[0]));
        }
        return retVal;
    }

    public <T> List<T> getListeners(Class<T> listenerClazz, Step step, InjectionReferences injectionRefs, RuntimeJobExecution execution) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(this.factory, step, injectionRefs, execution);
        ArrayList<Object> retVal = new ArrayList<Object>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!listenerClazz.isAssignableFrom(li.getArtifact().getClass())) continue;
            Object proxy = ProxyFactory.createProxy(li.getArtifact(), injectionRefs, new String[0]);
            retVal.add(proxy);
        }
        return retVal;
    }

    private static class ListenerInfo {
        private Object listenerArtifact = null;

        private ListenerInfo(Object listenerArtifact) {
            this.listenerArtifact = listenerArtifact;
        }

        Object getArtifact() {
            return this.listenerArtifact;
        }
    }
}

