/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.SecurityContext;
import javax.security.enterprise.authentication.mechanism.http.AuthenticationParameters;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.jaspic.CallbackHandlerImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomcatSecurityService;
import org.apache.tomee.security.message.TomEEMessageInfo;

public class TomEESecurityContext
implements SecurityContext {
    private TomcatSecurityService securityService;

    @PostConstruct
    private void init() {
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        if (securityService instanceof TomcatSecurityService) {
            this.securityService = (TomcatSecurityService)securityService;
        }
    }

    public Principal getCallerPrincipal() {
        return this.securityService.getCallerPrincipal();
    }

    public <T extends Principal> Set<T> getPrincipalsByType(Class<T> pType) {
        return Collections.emptySet();
    }

    public boolean isCallerInRole(String role) {
        return this.securityService.isCallerInRole(role);
    }

    public boolean hasAccessToWebResource(String resource, String ... methods) {
        return false;
    }

    public AuthenticationStatus authenticate(HttpServletRequest request, HttpServletResponse response, AuthenticationParameters parameters) {
        try {
            TomEEMessageInfo messageInfo = new TomEEMessageInfo(request, response, true, parameters);
            ServerAuthContext serverAuthContext = this.getServerAuthContext(request);
            AuthStatus authStatus = serverAuthContext.validateRequest((MessageInfo)messageInfo, new Subject(), null);
            return this.mapToAuthenticationStatus(authStatus);
        }
        catch (AuthException e) {
            return AuthenticationStatus.SEND_FAILURE;
        }
    }

    private AuthenticationStatus mapToAuthenticationStatus(AuthStatus authStatus) {
        if (AuthStatus.SUCCESS.equals(authStatus)) {
            return AuthenticationStatus.SUCCESS;
        }
        if (AuthStatus.SEND_FAILURE.equals(authStatus)) {
            return AuthenticationStatus.SEND_FAILURE;
        }
        if (AuthStatus.SEND_CONTINUE.equals(authStatus)) {
            return AuthenticationStatus.SEND_CONTINUE;
        }
        throw new IllegalArgumentException();
    }

    private ServerAuthContext getServerAuthContext(HttpServletRequest request) throws AuthException {
        String appContext = request.getServletContext().getVirtualServerName() + " " + request.getContextPath();
        AuthConfigProvider authConfigProvider = AuthConfigFactory.getFactory().getConfigProvider("HttpServlet", appContext, null);
        ServerAuthConfig serverAuthConfig = authConfigProvider.getServerAuthConfig("HttpServlet", appContext, (CallbackHandler)new CallbackHandlerImpl());
        return serverAuthConfig.getAuthContext(null, null, null);
    }

    public static void registerContainerAboutLogin(Principal principal, Set<String> groups) {
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        if (securityService instanceof TomcatSecurityService) {
            TomcatSecurityService tomcatSecurityService = (TomcatSecurityService)securityService;
            Request request = (Request)OpenEJBSecurityListener.requests.get();
            GenericPrincipal genericPrincipal = new GenericPrincipal(principal.getName(), null, (List)(groups == null ? Collections.emptyList() : new ArrayList<String>(groups)), principal);
            tomcatSecurityService.enterWebApp(request.getWrapper().getRealm(), (Principal)genericPrincipal, request.getWrapper().getRunAs());
        }
    }
}

