/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.openapi.impl.processor.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedMethodElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedTypeElement;

public class MethodElement
implements AnnotatedMethodElement {
    private static final Method[] NO_METHOD = new Method[0];
    private final Method[] delegates;
    private Annotation[] annotations;

    public MethodElement(Method method) {
        LinkedList<Method> methods = new LinkedList<Method>();
        methods.add(method);
        Stream.of(method.getDeclaringClass().getInterfaces()).map(it -> {
            try {
                return it.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }).filter(Objects::nonNull).forEach(methods::add);
        this.delegates = methods.toArray(NO_METHOD);
    }

    @Override
    public String getName() {
        return this.delegates[0].getName();
    }

    @Override
    public Type getReturnType() {
        return this.delegates[0].getGenericReturnType();
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.delegates[0].getDeclaringClass();
    }

    @Override
    public AnnotatedTypeElement[] getParameters() {
        final Parameter[] parameters = this.delegates[0].getParameters();
        return (AnnotatedTypeElement[])IntStream.range(0, parameters.length).mapToObj(p -> new AnnotatedTypeElement(){
            private Annotation[] annotations;

            @Override
            public Type getType() {
                return parameters[p].getParameterizedType();
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return (T)((Annotation)Stream.of(MethodElement.this.delegates).map(m -> m.getParameters()[p]).filter(it -> it.isAnnotationPresent(annotationClass)).map(it -> it.getAnnotation(annotationClass)).findFirst().orElse(null));
            }

            @Override
            public Annotation[] getAnnotations() {
                Annotation[] annotationArray;
                if (this.annotations == null) {
                    this.annotations = MethodElement.mergeAnnotations(MethodElement.this.delegates);
                    annotationArray = this.annotations;
                } else {
                    annotationArray = this.annotations;
                }
                return annotationArray;
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return this.getAnnotations();
            }
        }).toArray(AnnotatedTypeElement[]::new);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)((Annotation)Stream.of(this.delegates).filter(d -> d.isAnnotationPresent(annotationClass)).map(d -> d.getAnnotation(annotationClass)).findFirst().orElse(null));
    }

    @Override
    public Annotation[] getAnnotations() {
        Annotation[] annotationArray;
        if (this.annotations == null) {
            this.annotations = MethodElement.mergeAnnotations(this.delegates);
            annotationArray = this.annotations;
        } else {
            annotationArray = this.annotations;
        }
        return annotationArray;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    private static Annotation[] mergeAnnotations(AnnotatedElement ... element) {
        return Stream.of(element).flatMap(i -> Stream.of(i.getAnnotations())).collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (a, b) -> a)).values().toArray(new Annotation[0]);
    }
}

