/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.IOException;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.OpenEjbVersion;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomcatSecurityService;

public class OpenEJBValve
extends ValveBase {
    protected TomcatSecurityService securityService = this.getSecurityService();
    protected static final String info = OpenEJBValve.class.getName() + "/" + OpenEjbVersion.get().getVersion();

    public OpenEJBValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        OpenEJBSecurityListener listener = new OpenEJBSecurityListener(this.securityService, request);
        if (!request.isAsync() || request.getAsyncContextInternal() == null) {
            listener.enter();
            try {
                this.getNext().invoke(request, response);
            }
            finally {
                listener.exit();
            }
        } else {
            request.getAsyncContextInternal().addListener((AsyncListener)new OpenEJBSecurityListener(this.securityService, request));
            this.getNext().invoke(request, response);
        }
    }

    private TomcatSecurityService getSecurityService() {
        SecurityService securityService = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
        if (securityService instanceof TomcatSecurityService) {
            return (TomcatSecurityService)securityService;
        }
        return null;
    }
}

