/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.impl.health.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.geronimo.microprofile.common.registry.HealthChecksRegistry;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;

public class GeronimoHealthExtension
implements Extension,
HealthChecksRegistry {
    private final Collection<Bean<?>> beans = new ArrayList();
    private final Collection<CreationalContext<?>> contexts = new ArrayList();
    private List<HealthCheck> checks;

    void findChecks(@Observes ProcessBean<?> bean) {
        if (bean.getAnnotated().isAnnotationPresent(Health.class) && bean.getBean().getTypes().contains(HealthCheck.class)) {
            this.beans.add(bean.getBean());
        }
    }

    void start(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        this.checks = this.beans.stream().map(it -> this.lookup((Bean<?>)it, beanManager)).collect(Collectors.toList());
    }

    void stop(@Observes BeforeShutdown beforeShutdown) {
        IllegalStateException ise = new IllegalStateException("Something went wrong releasing health checks");
        this.contexts.forEach(c -> {
            try {
                c.release();
            }
            catch (RuntimeException re) {
                ise.addSuppressed(re);
            }
        });
        Throwable[] suppressed = ise.getSuppressed();
        if (suppressed.length == 1) {
            throw (RuntimeException)RuntimeException.class.cast(suppressed[0]);
        }
        if (suppressed.length > 1) {
            throw ise;
        }
    }

    public List<HealthCheck> getChecks() {
        return this.checks;
    }

    private HealthCheck lookup(Bean<?> bean, BeanManager manager) {
        Class type = bean.getBeanClass() == null ? HealthCheck.class : bean.getBeanClass();
        Set beans = manager.getBeans((Type)type, bean.getQualifiers().toArray(new Annotation[bean.getQualifiers().size()]));
        Bean resolvedBean = manager.resolve(beans);
        CreationalContext creationalContext = manager.createCreationalContext(null);
        if (!manager.isNormalScope(resolvedBean.getScope())) {
            this.contexts.add(creationalContext);
        }
        return (HealthCheck)HealthCheck.class.cast(manager.getReference(resolvedBean, HealthCheck.class, creationalContext));
    }
}

