/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.application.viewstate.StateCacheFactoryImpl;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.spi.StateCacheProvider;
import org.apache.myfaces.spi.StateCacheProviderFactory;

public class DefaultStateCacheProviderFactory
extends StateCacheProviderFactory {
    public static final String STATE_CACHE_PROVIDER = StateCacheProvider.class.getName();
    public static final String STATE_CACHE_PROVIDER_LIST = StateCacheProvider.class.getName() + ".LIST";
    public static final String STATE_CACHE_PROVIDER_INSTANCE = StateCacheProvider.class.getName() + ".INSTANCE";

    private Logger getLogger() {
        return Logger.getLogger(DefaultStateCacheProviderFactory.class.getName());
    }

    @Override
    public StateCacheProvider getStateCacheProvider(ExternalContext externalContext) {
        StateCacheProvider stateCacheProvider = (StateCacheProvider)externalContext.getApplicationMap().get(STATE_CACHE_PROVIDER_INSTANCE);
        if (stateCacheProvider == null) {
            stateCacheProvider = this.createStateCacheProvider(externalContext);
            externalContext.getApplicationMap().put(STATE_CACHE_PROVIDER_INSTANCE, stateCacheProvider);
        }
        return stateCacheProvider;
    }

    @Override
    public StateCacheProvider createStateCacheProvider(ExternalContext externalContext) {
        StateCacheProvider returnValue = null;
        final ExternalContext extContext = externalContext;
        try {
            returnValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<StateCacheProvider>(){

                @Override
                public StateCacheProvider run() throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
                    return DefaultStateCacheProviderFactory.this.resolveStateCacheProviderFromService(extContext);
                }
            }) : this.resolveStateCacheProviderFromService(extContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException((Throwable)e);
        }
        return returnValue;
    }

    private StateCacheProvider resolveStateCacheProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(STATE_CACHE_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(STATE_CACHE_PROVIDER);
            externalContext.getApplicationMap().put(STATE_CACHE_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(StateCacheProvider.class, classList, new StateCacheFactoryImpl());
    }
}

