/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.NoneJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.NoneJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public final class JwsUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(JwsUtils.class);

    private JwsUtils() {
    }

    public static String sign(PrivateKey key, SignatureAlgorithm algo, String content) {
        return JwsUtils.sign(key, algo, content, null);
    }

    public static String sign(PrivateKey key, SignatureAlgorithm algo, String content, String ct) {
        return JwsUtils.sign(JwsUtils.getPrivateKeySignatureProvider(key, algo), content, ct);
    }

    public static String sign(String encodedKey, SignatureAlgorithm algo, String content) {
        return JwsUtils.sign(JoseUtils.decode(encodedKey), algo, content);
    }

    public static String sign(byte[] key, SignatureAlgorithm algo, String content) {
        return JwsUtils.sign(key, algo, content, null);
    }

    public static String sign(byte[] key, SignatureAlgorithm algo, String content, String ct) {
        return JwsUtils.sign(JwsUtils.getHmacSignatureProvider(key, algo), content, ct);
    }

    public static String verify(PublicKey key, SignatureAlgorithm algo, String content) {
        JwsCompactConsumer jws = JwsUtils.verify(JwsUtils.getPublicKeySignatureVerifier(key, algo), content);
        return jws.getDecodedJwsPayload();
    }

    public static String verify(String encodedKey, SignatureAlgorithm algo, String content) {
        return JwsUtils.verify(JoseUtils.decode(encodedKey), algo, content);
    }

    public static String verify(byte[] key, SignatureAlgorithm algo, String content) {
        JwsCompactConsumer jws = JwsUtils.verify(JwsUtils.getHmacSignatureVerifier(key, algo), content);
        return jws.getDecodedJwsPayload();
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk) {
        return JwsUtils.getSignatureProvider(jwk, null);
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk, SignatureAlgorithm defaultAlgorithm) {
        SignatureAlgorithm sigAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : SignatureAlgorithm.getAlgorithm(jwk.getAlgorithm());
        JwsSignatureProvider theSigProvider = null;
        KeyType keyType = jwk.getKeyType();
        if (keyType != null) {
            switch (keyType) {
                case RSA: {
                    theSigProvider = JwsUtils.getPrivateKeySignatureProvider(JwkUtils.toRSAPrivateKey(jwk), sigAlgo);
                    break;
                }
                case OCTET: {
                    byte[] key = JoseUtils.decode((String)jwk.getProperty("k"));
                    theSigProvider = JwsUtils.getHmacSignatureProvider(key, sigAlgo);
                    break;
                }
                case EC: {
                    theSigProvider = JwsUtils.getPrivateKeySignatureProvider(JwkUtils.toECPrivateKey(jwk), sigAlgo);
                    break;
                }
            }
        }
        return theSigProvider;
    }

    public static JwsSignatureProvider getPrivateKeySignatureProvider(PrivateKey key, SignatureAlgorithm algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if ("EC".equals(key.getAlgorithm())) {
            return new EcDsaJwsSignatureProvider((ECPrivateKey)key, algo);
        }
        if ("RSA".equals(key.getAlgorithm())) {
            return new PrivateKeyJwsSignatureProvider(key, algo);
        }
        return null;
    }

    public static JwsSignatureProvider getHmacSignatureProvider(String encodedKey, SignatureAlgorithm algo) {
        return JwsUtils.getHmacSignatureProvider(JoseUtils.decode(encodedKey), algo);
    }

    public static JwsSignatureProvider getHmacSignatureProvider(byte[] key, SignatureAlgorithm algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (AlgorithmUtils.isHmacSign(algo.getJwaName())) {
            return new HmacJwsSignatureProvider(key, algo);
        }
        return null;
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk) {
        return JwsUtils.getSignatureVerifier(jwk, null);
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk, SignatureAlgorithm defaultAlgorithm) {
        SignatureAlgorithm sigAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : SignatureAlgorithm.getAlgorithm(jwk.getAlgorithm());
        JwsSignatureVerifier theVerifier = null;
        KeyType keyType = jwk.getKeyType();
        if (keyType != null) {
            switch (keyType) {
                case RSA: {
                    theVerifier = JwsUtils.getPublicKeySignatureVerifier(JwkUtils.toRSAPublicKey(jwk, true), sigAlgo);
                    break;
                }
                case OCTET: {
                    byte[] key = JoseUtils.decode((String)jwk.getProperty("k"));
                    theVerifier = JwsUtils.getHmacSignatureVerifier(key, sigAlgo);
                    break;
                }
                case EC: {
                    theVerifier = JwsUtils.getPublicKeySignatureVerifier(JwkUtils.toECPublicKey(jwk), sigAlgo);
                    break;
                }
            }
        }
        return theVerifier;
    }

    public static JwsSignatureVerifier getPublicKeySignatureVerifier(X509Certificate cert, SignatureAlgorithm algo) {
        if (cert != null) {
            if (algo == null) {
                algo = JwsUtils.getDefaultPublicKeyAlgorithm(cert.getPublicKey());
            }
            if (algo == null) {
                LOG.warning("No signature algorithm was defined");
                throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
            }
            if ("RSA".equals(cert.getPublicKey().getAlgorithm())) {
                return new PublicKeyJwsSignatureVerifier(cert, algo);
            }
            if ("EC".equals(cert.getPublicKey().getAlgorithm())) {
                return new EcDsaJwsSignatureVerifier(cert, algo);
            }
        }
        return null;
    }

    public static JwsSignatureVerifier getPublicKeySignatureVerifier(PublicKey key, SignatureAlgorithm algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if ("RSA".equals(key.getAlgorithm())) {
            return new PublicKeyJwsSignatureVerifier(key, algo);
        }
        if ("EC".equals(key.getAlgorithm())) {
            return new EcDsaJwsSignatureVerifier(key, algo);
        }
        return null;
    }

    public static JwsSignatureVerifier getHmacSignatureVerifier(String encodedKey, SignatureAlgorithm algo) {
        return JwsUtils.getHmacSignatureVerifier(JoseUtils.decode(encodedKey), algo);
    }

    public static JwsSignatureVerifier getHmacSignatureVerifier(byte[] key, SignatureAlgorithm algo) {
        if (algo == null) {
            LOG.warning("No signature algorithm was defined");
            throw new JwsException(JwsException.Error.ALGORITHM_NOT_SET);
        }
        if (AlgorithmUtils.isHmacSign(algo.getJwaName())) {
            return new HmacJwsSignatureVerifier(key, algo);
        }
        return null;
    }

    public static Map<SignatureAlgorithm, List<JwsJsonSignatureEntry>> getJwsJsonSignatureMap(List<JwsJsonSignatureEntry> signatures) {
        HashMap<SignatureAlgorithm, List<JwsJsonSignatureEntry>> map = new HashMap<SignatureAlgorithm, List<JwsJsonSignatureEntry>>();
        for (JwsJsonSignatureEntry entry : signatures) {
            SignatureAlgorithm sigAlgorithm = entry.getUnionHeader().getSignatureAlgorithm();
            ArrayList<JwsJsonSignatureEntry> entries = (ArrayList<JwsJsonSignatureEntry>)map.get((Object)sigAlgorithm);
            if (entries == null) {
                entries = new ArrayList<JwsJsonSignatureEntry>();
            }
            entries.add(entry);
            map.put(sigAlgorithm, entries);
        }
        return map;
    }

    public static JwsSignatureProvider loadSignatureProvider(boolean required) {
        return JwsUtils.loadSignatureProvider(null, required);
    }

    public static JwsSignatureProvider loadSignatureProvider(JwsHeaders headers, boolean required) {
        Properties props = JwsUtils.loadSignatureOutProperties(required);
        if (props == null) {
            return null;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(props, headers);
        if (headers != null) {
            headers.setSignatureAlgorithm(theSigProvider.getAlgorithm());
        }
        return theSigProvider;
    }

    public static Properties loadSignatureOutProperties(boolean required) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        return KeyManagementUtils.loadStoreProperties(m, required, "rs.security.signature.out.properties", "rs.security.signature.properties");
    }

    public static Properties loadSignatureInProperties(boolean required) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        return KeyManagementUtils.loadStoreProperties(m, required, "rs.security.signature.in.properties", "rs.security.signature.properties");
    }

    public static Properties loadSignatureProperties(String propertiesName, boolean required) {
        Message m = PhaseInterceptorChain.getCurrentMessage();
        return KeyManagementUtils.loadStoreProperties(m, required, propertiesName, null);
    }

    public static Properties loadSignatureProperties(String propertiesLoc, Bus bus) {
        try {
            return JoseUtils.loadProperties(propertiesLoc, bus);
        }
        catch (Exception ex) {
            throw new JwsException(JwsException.Error.NO_INIT_PROPERTIES, (Throwable)ex);
        }
    }

    public static JwsSignatureVerifier loadSignatureVerifier(boolean required) {
        return JwsUtils.loadSignatureVerifier(null, required);
    }

    public static JwsSignatureVerifier loadSignatureVerifier(String propertiesLoc, Bus bus) {
        Properties props = JwsUtils.loadSignatureProperties(propertiesLoc, bus);
        return JwsUtils.loadSignatureVerifier(props, null);
    }

    public static JwsSignatureVerifier loadSignatureVerifier(JwsHeaders headers, boolean required) {
        Properties props = JwsUtils.loadSignatureInProperties(required);
        return JwsUtils.loadSignatureVerifier(props, headers);
    }

    public static boolean validateCriticalHeaders(JwsHeaders headers) {
        return JoseUtils.validateCriticalHeaders(headers);
    }

    public static JwsSignatureProvider loadSignatureProvider(Properties props, JwsHeaders headers) {
        return JwsUtils.loadSignatureProvider(PhaseInterceptorChain.getCurrentMessage(), props, headers);
    }

    public static JwsSignatureProvider loadSignatureProvider(String propertiesLoc, Bus bus) {
        Properties props = JwsUtils.loadSignatureProperties(propertiesLoc, bus);
        return JwsUtils.loadSignatureProvider(props, null);
    }

    public static JwsSignatureProvider loadSignatureProvider(Message m, Properties props, JwsHeaders headers) {
        JwsSignatureProvider theSigProvider = null;
        boolean includeCert = JoseUtils.checkBooleanProperty(headers, props, m, "rs.security.signature.include.cert");
        boolean includeCertSha1 = JoseUtils.checkBooleanProperty(headers, props, m, "rs.security.signature.include.cert.sha1");
        boolean includeCertSha256 = JoseUtils.checkBooleanProperty(headers, props, m, "rs.security.signature.include.cert.sha256");
        boolean includeKeyId = JoseUtils.checkBooleanProperty(headers, props, m, "rs.security.signature.include.key.id");
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, KeyOperation.SIGN);
            if (jwk != null) {
                SignatureAlgorithm signatureAlgo = JwsUtils.getSignatureAlgorithm(m, props, SignatureAlgorithm.getAlgorithm(jwk.getAlgorithm()), JwsUtils.getDefaultKeyAlgorithm(jwk));
                theSigProvider = JwsUtils.getSignatureProvider(jwk, signatureAlgo);
                boolean includePublicKey = JoseUtils.checkBooleanProperty(headers, props, m, "rs.security.signature.include.public.key");
                if (includeCert) {
                    JwkUtils.includeCertChain(jwk, headers, signatureAlgo.getJwaName());
                }
                if (includeCertSha1) {
                    KeyManagementUtils.setSha1DigestHeader(headers, m, props);
                } else if (includeCertSha256) {
                    KeyManagementUtils.setSha256DigestHeader(headers, m, props);
                }
                if (includePublicKey) {
                    JwkUtils.includePublicKey(jwk, headers, signatureAlgo.getJwaName());
                }
                if (includeKeyId && jwk.getKeyId() != null) {
                    headers.setKeyId(jwk.getKeyId());
                }
            }
        } else {
            SignatureAlgorithm signatureAlgo = JwsUtils.getSignatureAlgorithm(m, props, null, null);
            if (signatureAlgo == SignatureAlgorithm.NONE) {
                theSigProvider = new NoneJwsSignatureProvider();
            } else {
                PrivateKey pk = KeyManagementUtils.loadPrivateKey(m, props, KeyOperation.SIGN);
                if (signatureAlgo == null) {
                    signatureAlgo = JwsUtils.getDefaultPrivateKeyAlgorithm(pk);
                }
                theSigProvider = JwsUtils.getPrivateKeySignatureProvider(pk, signatureAlgo);
                if (includeCert) {
                    headers.setX509Chain(KeyManagementUtils.loadAndEncodeX509CertificateOrChain(m, props));
                }
                if (includeCertSha1) {
                    KeyManagementUtils.setSha1DigestHeader(headers, m, props);
                } else if (includeCertSha256) {
                    KeyManagementUtils.setSha256DigestHeader(headers, m, props);
                }
                if (includeKeyId && props.containsKey("rs.security.keystore.alias")) {
                    headers.setKeyId(props.getProperty("rs.security.keystore.alias"));
                }
            }
        }
        if (theSigProvider == null) {
            LOG.warning("Provider is not available");
            throw new JwsException(JwsException.Error.NO_PROVIDER);
        }
        return theSigProvider;
    }

    public static JwsSignatureVerifier loadSignatureVerifier(Properties props, JwsHeaders inHeaders) {
        return JwsUtils.loadSignatureVerifier(PhaseInterceptorChain.getCurrentMessage(), props, inHeaders);
    }

    public static JwsSignatureVerifier loadSignatureVerifier(Message m, Properties props, JwsHeaders inHeaders) {
        JwsSignatureVerifier theVerifier = null;
        String inHeaderKid = null;
        if (inHeaders != null) {
            X509Certificate foundCert;
            inHeaderKid = inHeaders.getKeyId();
            if (inHeaders.getHeader("jwk") != null) {
                JsonWebKey publicJwk = inHeaders.getJsonWebKey();
                if (inHeaderKid != null && !inHeaderKid.equals(publicJwk.getKeyId()) || !MessageUtils.getContextualBoolean(m, "rs.security.accept.public.key", false)) {
                    throw new JwsException(JwsException.Error.INVALID_KEY);
                }
                return JwsUtils.getSignatureVerifier(publicJwk, inHeaders.getSignatureAlgorithm());
            }
            if (inHeaders.getHeader("x5c") != null) {
                List<X509Certificate> chain = KeyManagementUtils.toX509CertificateChain(inHeaders.getX509Chain());
                KeyManagementUtils.validateCertificateChain(props, chain);
                return JwsUtils.getPublicKeySignatureVerifier(chain.get(0), inHeaders.getSignatureAlgorithm());
            }
            if (inHeaders.getHeader("x5t") != null ? (foundCert = KeyManagementUtils.getCertificateFromThumbprint(inHeaders.getX509Thumbprint(), "SHA-1", m, props)) != null : inHeaders.getHeader("x5t#S256") != null && (foundCert = KeyManagementUtils.getCertificateFromThumbprint(inHeaders.getX509ThumbprintSHA256(), "SHA-256", m, props)) != null) {
                return JwsUtils.getPublicKeySignatureVerifier(foundCert, inHeaders.getSignatureAlgorithm());
            }
        }
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, KeyOperation.VERIFY, inHeaderKid);
            if (jwk != null) {
                SignatureAlgorithm signatureAlgo = JwsUtils.getSignatureAlgorithm(m, props, SignatureAlgorithm.getAlgorithm(jwk.getAlgorithm()), JwsUtils.getDefaultKeyAlgorithm(jwk));
                theVerifier = JwsUtils.getSignatureVerifier(jwk, signatureAlgo);
            }
        } else {
            SignatureAlgorithm signatureAlgo = JwsUtils.getSignatureAlgorithm(m, props, null, null);
            if (signatureAlgo == SignatureAlgorithm.NONE && (null == inHeaders || SignatureAlgorithm.NONE.getJwaName().equals(inHeaders.getAlgorithm()))) {
                theVerifier = new NoneJwsSignatureVerifier();
            } else {
                X509Certificate[] certs = KeyManagementUtils.loadX509CertificateOrChain(m, props);
                if (certs != null && certs.length > 0) {
                    theVerifier = JwsUtils.getPublicKeySignatureVerifier(certs[0], signatureAlgo);
                }
            }
        }
        if (theVerifier == null) {
            LOG.warning("Verifier is not available");
            throw new JwsException(JwsException.Error.NO_VERIFIER);
        }
        return theVerifier;
    }

    public static Properties loadJwsProperties(Message m, String propLoc) {
        try {
            return JoseUtils.loadProperties(propLoc, m.getExchange().getBus());
        }
        catch (Exception ex) {
            LOG.warning("JWS init properties are not available");
            throw new JwsException(JwsException.Error.NO_INIT_PROPERTIES);
        }
    }

    public static SignatureAlgorithm getSignatureAlgorithm(Message m, Properties props, SignatureAlgorithm algo, SignatureAlgorithm defaultAlgo) {
        if (algo == null) {
            algo = JwsUtils.getSignatureAlgorithm(m, props, defaultAlgo);
        }
        return algo;
    }

    public static SignatureAlgorithm getSignatureAlgorithm(Properties props, SignatureAlgorithm defaultAlgo) {
        return JwsUtils.getSignatureAlgorithm(PhaseInterceptorChain.getCurrentMessage(), props, defaultAlgo);
    }

    public static SignatureAlgorithm getSignatureAlgorithm(Message m, Properties props, SignatureAlgorithm defaultAlgo) {
        String algo = KeyManagementUtils.getKeyAlgorithm(m, props, "rs.security.signature.algorithm", defaultAlgo == null ? null : defaultAlgo.getJwaName());
        return SignatureAlgorithm.getAlgorithm(algo);
    }

    private static SignatureAlgorithm getDefaultKeyAlgorithm(JsonWebKey jwk) {
        KeyType keyType = jwk.getKeyType();
        switch (keyType != null ? keyType : KeyType.RSA) {
            case OCTET: {
                return SignatureAlgorithm.HS256;
            }
            case EC: {
                return SignatureAlgorithm.ES256;
            }
        }
        return SignatureAlgorithm.RS256;
    }

    private static SignatureAlgorithm getDefaultPrivateKeyAlgorithm(PrivateKey key) {
        if ("RSA".equals(key.getAlgorithm())) {
            return SignatureAlgorithm.RS256;
        }
        if ("EC".equals(key.getAlgorithm())) {
            return SignatureAlgorithm.ES256;
        }
        return null;
    }

    private static SignatureAlgorithm getDefaultPublicKeyAlgorithm(PublicKey key) {
        if ("RSA".equals(key.getAlgorithm())) {
            return SignatureAlgorithm.RS256;
        }
        if ("EC".equals(key.getAlgorithm())) {
            return SignatureAlgorithm.ES256;
        }
        return null;
    }

    public static JwsCompactConsumer verify(JwsSignatureVerifier v, String content) {
        JwsCompactConsumer jws = new JwsCompactConsumer(content);
        if (!jws.verifySignatureWith(v)) {
            throw new JwsException(JwsException.Error.INVALID_SIGNATURE);
        }
        return jws;
    }

    public static String sign(JwsSignatureProvider jwsSig, String content, String ct) {
        JwsHeaders headers = new JwsHeaders();
        if (ct != null) {
            headers.setContentType(ct);
        }
        JwsCompactProducer jws = new JwsCompactProducer(headers, content);
        jws.signWith(jwsSig);
        return jws.getSignedEncodedJws();
    }

    public static boolean isPayloadUnencoded(JwsHeaders jwsHeaders) {
        return jwsHeaders.getPayloadEncodingStatus() == Boolean.FALSE;
    }

    public static void checkSignatureKeySize(Key key) {
        if (key instanceof RSAKey && ((RSAKey)((Object)key)).getModulus().bitLength() < 2048) {
            LOG.fine("A key of size: " + ((RSAKey)((Object)key)).getModulus().bitLength() + " was used with an RSA signature algorithm. 2048 is the minimum size that is accepted");
            throw new JwsException(JwsException.Error.INVALID_KEY);
        }
    }

    @Deprecated
    public static JsonWebKeys loadPublicVerificationKeys(Message m, Properties props) {
        return JwsUtils.loadPublicVerificationKeys(m, props, true);
    }

    public static JsonWebKeys loadPublicVerificationKeys(Message m, Properties props, boolean stripPrivateParameters) {
        String storeType = props.getProperty("rs.security.keystore.type");
        if ("jwk".equals(storeType)) {
            List<JsonWebKey> jsonWebKeys = JwkUtils.loadJsonWebKeys(m, props, KeyOperation.SIGN, null);
            if (jsonWebKeys == null || jsonWebKeys.isEmpty()) {
                throw new JoseException("Error loading keys");
            }
            return new JsonWebKeys(stripPrivateParameters ? JwkUtils.stripPrivateParameters(jsonWebKeys) : jsonWebKeys);
        }
        X509Certificate[] certs = null;
        if (PropertyUtils.isTrue(props.get("rs.security.signature.include.cert"))) {
            certs = KeyManagementUtils.loadX509CertificateOrChain(m, props);
        }
        PublicKey key = certs != null && certs.length > 0 ? certs[0].getPublicKey() : KeyManagementUtils.loadPublicKey(m, props);
        JsonWebKey jwk = JwkUtils.fromPublicKey(key, props, "rs.security.signature.algorithm");
        jwk.setPublicKeyUse(PublicKeyUse.SIGN);
        if (certs != null) {
            jwk.setX509Chain(KeyManagementUtils.encodeX509CertificateChain(certs));
        }
        return new JsonWebKeys(jwk);
    }
}

