/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsonp;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class JsonpJaxrsWriterInterceptor
implements WriterInterceptor {
    private String mediaType = "application/x-javascript";
    private String paddingEnd = "(";

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        String callback = this.getCallbackValue(JAXRSUtils.getCurrentMessage());
        if (!StringUtils.isEmpty(callback)) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)JAXRSUtils.toMediaType(this.getMediaType()));
            context.getOutputStream().write((callback + this.getPaddingEnd()).getBytes(StandardCharsets.UTF_8));
        }
        context.proceed();
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public void setPaddingEnd(String paddingEnd) {
        this.paddingEnd = paddingEnd;
    }

    public String getPaddingEnd() {
        return this.paddingEnd;
    }

    protected String getCallbackValue(Message message) {
        Exchange exchange = message.getExchange();
        return (String)exchange.get("JSONP.CALLBACK");
    }
}

