/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.cdi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.geronimo.config.cdi.AnyLiteral;
import org.apache.geronimo.config.cdi.ConfigurationHandler;
import org.apache.geronimo.config.cdi.DefaultLiteral;
import org.eclipse.microprofile.config.Config;

public class ProxyBean<T>
implements Bean<T>,
PassivationCapable {
    private static final Set<Annotation> QUALIFIERS = new HashSet<Annotation>(Arrays.asList(DefaultLiteral.INSTANCE, AnyLiteral.INSTANCE));
    private final Class<T> beanClass;
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;
    private final String id;
    private Config config;

    ProxyBean(Class<T> api) {
        this.beanClass = api;
        this.qualifiers = QUALIFIERS;
        this.types = new HashSet<Class>(Arrays.asList(api, Serializable.class));
        this.id = ProxyBean.class.getName() + "[" + api.getName() + "]";
    }

    void init(Config config) {
        this.config = config;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public boolean isNullable() {
        return false;
    }

    public T create(CreationalContext<T> context) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.beanClass}, (InvocationHandler)new ConfigurationHandler(this.config, this.beanClass));
    }

    public void destroy(T instance, CreationalContext<T> context) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return this.id;
    }
}

