/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.configsource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.geronimo.config.configsource.BaseConfigSource;

public class PropertyFileConfigSource
extends BaseConfigSource {
    private static final Logger LOG = Logger.getLogger(PropertyFileConfigSource.class.getName());
    private Map<String, String> properties;
    private String fileName;

    public PropertyFileConfigSource(URL propertyFileUrl) {
        this.fileName = propertyFileUrl.toExternalForm();
        this.properties = this.loadProperties(propertyFileUrl);
        this.initOrdinal(100);
    }

    public String getValue(String key) {
        return this.properties.get(key);
    }

    public String getName() {
        return this.fileName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadProperties(URL url) {
        Properties props = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = url.openStream();
            if (inputStream != null) {
                props.load(inputStream);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to read URL " + url, e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return props;
    }
}

