/*
 * Decompiled with CFR 0.152.
 */
package org.apache.safeguard.impl.fallback;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.PreDestroy;
import javax.annotation.Priority;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.safeguard.impl.annotation.AnnotationFinder;
import org.apache.safeguard.impl.cache.Key;
import org.apache.safeguard.impl.cache.UnwrappedCache;
import org.apache.safeguard.impl.cdi.SafeguardExtension;
import org.apache.safeguard.impl.config.ConfigurationMapper;
import org.apache.safeguard.impl.metrics.FaultToleranceMetrics;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

@Interceptor
@Priority(value=4002)
public class FallbackInterceptor
implements Serializable {
    @Inject
    private Cache cache;

    @AroundInvoke
    public Object withFallback(final InvocationContext context) {
        Key key;
        Map<Key, FallbackHandler<?>> handlers = this.cache.getHandlers();
        FallbackHandler<?> handler = handlers.get(key = new Key(context, this.cache.getUnwrappedCache().getUnwrappedCache()));
        if (handler == null) {
            handler = this.cache.create(context);
            handlers.putIfAbsent(key, handler);
        }
        try {
            return context.proceed();
        }
        catch (Throwable e) {
            return handler.handle((ExecutionContext)new EnrichedExecutionContext(){

                @Override
                public Object getTarget() {
                    return context.getTarget();
                }

                public Method getMethod() {
                    return context.getMethod();
                }

                public Object[] getParameters() {
                    return context.getParameters();
                }

                public Throwable getFailure() {
                    return e;
                }
            });
        }
    }

    private static interface EnrichedExecutionContext
    extends ExecutionContext {
        public Object getTarget();
    }

    @ApplicationScoped
    public static class Cache {
        private final Map<Key, FallbackHandler<?>> handlers = new ConcurrentHashMap();
        @Inject
        private AnnotationFinder finder;
        @Inject
        private SafeguardExtension extension;
        @Inject
        private BeanManager beanManager;
        @Inject
        private FaultToleranceMetrics metrics;
        @Inject
        private ConfigurationMapper mapper;
        @Inject
        private UnwrappedCache unwrappedCache;
        private final Collection<CreationalContext<?>> contexts = new ArrayList();

        public UnwrappedCache getUnwrappedCache() {
            return this.unwrappedCache;
        }

        @PreDestroy
        private void release() {
            this.contexts.forEach(CreationalContext::release);
        }

        public Map<Key, FallbackHandler<?>> getHandlers() {
            return this.handlers;
        }

        public FallbackHandler<?> create(InvocationContext context) {
            FallbackHandler handler;
            if (!this.mapper.isEnabled(context.getMethod(), Fallback.class)) {
                return context13 -> {
                    Throwable failure = context13.getFailure();
                    if (RuntimeException.class.isInstance(failure)) {
                        throw (RuntimeException)RuntimeException.class.cast(failure);
                    }
                    if (Error.class.isInstance(failure)) {
                        throw (Error)Error.class.cast(failure);
                    }
                    throw new IllegalStateException(failure);
                };
            }
            Fallback fallback = this.mapper.map(this.finder.findAnnotation(Fallback.class, context), context.getMethod(), Fallback.class);
            Class value = fallback.value();
            String method = fallback.fallbackMethod();
            if (!method.isEmpty() && value != Fallback.DEFAULT.class) {
                throw new FaultToleranceDefinitionException("You can't set a method and handler as fallback on " + context.getMethod());
            }
            if (value != Fallback.DEFAULT.class) {
                FallbackHandler fallbackHandler;
                Stream.of(value.getGenericInterfaces()).filter(ParameterizedType.class::isInstance).map(ParameterizedType.class::cast).filter(it -> FallbackHandler.class == it.getRawType()).findFirst().filter(it -> it.getActualTypeArguments().length == 1).filter(it -> {
                    Class<?> expected = this.extension.toClass(context.getMethod().getReturnType());
                    Class<?> actual = this.extension.toClass(it.getActualTypeArguments()[0]);
                    return expected.isAssignableFrom(actual);
                }).orElseThrow(() -> new FaultToleranceDefinitionException("handler does not match method: " + context.getMethod()));
                Set beans = this.beanManager.getBeans((Type)value, new Annotation[0]);
                Bean handlerBean = this.beanManager.resolve(beans);
                CreationalContext creationalContext = this.beanManager.createCreationalContext(null);
                if (!this.beanManager.isNormalScope(handlerBean.getScope())) {
                    this.contexts.add(creationalContext);
                }
                handler = fallbackHandler = (FallbackHandler)FallbackHandler.class.cast(this.beanManager.getReference(handlerBean, FallbackHandler.class, creationalContext));
            } else {
                try {
                    Method fallbackMethod = Optional.ofNullable(context.getTarget()).map(Object::getClass).orElseGet(() -> (Class)Class.class.cast(context.getMethod().getDeclaringClass())).getMethod(method, context.getMethod().getParameterTypes());
                    if (!this.extension.toClass(context.getMethod().getReturnType()).isAssignableFrom(this.extension.toClass(fallbackMethod.getReturnType())) || !Arrays.equals(context.getMethod().getParameterTypes(), fallbackMethod.getParameterTypes())) {
                        throw new FaultToleranceDefinitionException("handler method does not match method: " + context.getMethod());
                    }
                    if (!fallbackMethod.isAccessible()) {
                        fallbackMethod.setAccessible(true);
                    }
                    handler = context1 -> {
                        try {
                            return fallbackMethod.invoke(((EnrichedExecutionContext)EnrichedExecutionContext.class.cast(context1)).getTarget(), context1.getParameters());
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalStateException(e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable targetException = e.getTargetException();
                            if (RuntimeException.class.isInstance(targetException)) {
                                throw (RuntimeException)RuntimeException.class.cast(targetException);
                            }
                            if (Error.class.isInstance(targetException)) {
                                throw (Error)Error.class.cast(targetException);
                            }
                            throw new IllegalStateException(targetException);
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    throw new FaultToleranceDefinitionException("No method " + method + " in " + context.getTarget());
                }
            }
            String metricsName = "ft." + context.getMethod().getDeclaringClass().getCanonicalName() + "." + context.getMethod().getName() + ".fallback.calls.total";
            FaultToleranceMetrics.Counter counter = this.metrics.counter(metricsName, "Number of times the fallback handler or method was called");
            return context12 -> {
                counter.inc();
                return handler.handle(context12);
            };
        }
    }
}

