/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ContainerType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.EndpointFactory;
import org.apache.openejb.core.mdb.InboundRecovery;
import org.apache.openejb.core.mdb.Instance;
import org.apache.openejb.core.mdb.MdbInstanceManager;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Pool;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class MdbPoolContainer
implements RpcContainer,
BaseMdbContainer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private static final Object[] NO_ARGS = new Object[0];
    private final Object containerID;
    private final ResourceAdapter resourceAdapter;
    private final Class messageListenerInterface;
    private final Class activationSpecClass;
    private final boolean failOnUnknownActivationSpec;
    private final MdbInstanceManager instanceManager;
    private final ConcurrentMap<Object, BeanContext> deployments = new ConcurrentHashMap<Object, BeanContext>();
    private final XAResourceWrapper xaResourceWrapper;
    private final InboundRecovery inboundRecovery;
    private final Properties properties = new Properties();

    public MdbPoolContainer(Object containerID, SecurityService securityService, ResourceAdapter resourceAdapter, Class messageListenerInterface, Class activationSpecClass, boolean failOnUnknownActivationSpec, Duration accessTimeout, Duration closeTimeout, Pool.Builder poolBuilder, int callbackThreads, boolean useOneSchedulerThreadByBean, int evictionThreads) {
        this.containerID = containerID;
        this.resourceAdapter = resourceAdapter;
        this.messageListenerInterface = messageListenerInterface;
        this.activationSpecClass = activationSpecClass;
        this.failOnUnknownActivationSpec = failOnUnknownActivationSpec;
        this.xaResourceWrapper = SystemInstance.get().getComponent(XAResourceWrapper.class);
        this.inboundRecovery = SystemInstance.get().getComponent(InboundRecovery.class);
        this.instanceManager = new MdbInstanceManager(securityService, resourceAdapter, this.inboundRecovery, containerID, accessTimeout, closeTimeout, poolBuilder, callbackThreads, useOneSchedulerThreadByBean ? null : Executors.newScheduledThreadPool(Math.max(evictionThreads, 1), new DaemonThreadFactory(containerID)));
    }

    @Override
    public BeanContext[] getBeanContexts() {
        return this.deployments.values().toArray(new BeanContext[this.deployments.size()]);
    }

    @Override
    public BeanContext getBeanContext(Object deploymentID) {
        return (BeanContext)this.deployments.get(deploymentID);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.MESSAGE_DRIVEN;
    }

    @Override
    public Object getContainerID() {
        return this.containerID;
    }

    @Override
    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public Class getMessageListenerInterface() {
        return this.messageListenerInterface;
    }

    public Class getActivationSpecClass() {
        return this.activationSpecClass;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void deploy(BeanContext beanContext) throws OpenEJBException {
        Object deploymentId = beanContext.getDeploymentID();
        if (!beanContext.getMdbInterface().equals(this.messageListenerInterface)) {
            throw new OpenEJBException("Deployment '" + deploymentId + "' has message listener interface " + beanContext.getMdbInterface().getName() + " but this MDB container only supports " + this.messageListenerInterface);
        }
        ActivationSpec activationSpec = this.createActivationSpec(beanContext);
        EndpointFactory endpointFactory = new EndpointFactory(activationSpec, this, beanContext, null, this.instanceManager, this.xaResourceWrapper, true);
        beanContext.setContainer(this);
        this.deployments.put(deploymentId, beanContext);
        try {
            this.instanceManager.deploy(beanContext, activationSpec, endpointFactory);
        }
        catch (OpenEJBException e) {
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deployments.remove(deploymentId);
            throw new OpenEJBException(e);
        }
    }

    private ActivationSpec createActivationSpec(BeanContext beanContext) throws OpenEJBException {
        try {
            ObjectRecipe objectRecipe = new ObjectRecipe(this.activationSpecClass);
            objectRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            objectRecipe.disallow(Option.FIELD_INJECTION);
            Map<String, String> activationProperties = beanContext.getActivationProperties();
            for (Map.Entry<String, String> entry : activationProperties.entrySet()) {
                objectRecipe.setMethodProperty(entry.getKey(), (Object)entry.getValue());
            }
            objectRecipe.setMethodProperty("beanClass", (Object)beanContext.getBeanClass());
            ActivationSpec activationSpec = (ActivationSpec)objectRecipe.create(this.activationSpecClass.getClassLoader());
            TreeSet unusedProperties = new TreeSet(objectRecipe.getUnsetProperties().keySet());
            unusedProperties.remove("destination");
            unusedProperties.remove("destinationType");
            unusedProperties.remove("destinationLookup");
            unusedProperties.remove("connectionFactoryLookup");
            unusedProperties.remove("beanClass");
            unusedProperties.remove("MdbActiveOnStartup");
            unusedProperties.remove("MdbJMXControl");
            unusedProperties.remove("DeliveryActive");
            if (!unusedProperties.isEmpty()) {
                String text = "No setter found for the activation spec properties: " + unusedProperties;
                if (this.failOnUnknownActivationSpec) {
                    throw new IllegalArgumentException(text);
                }
                logger.warning(text);
            }
            try {
                activationSpec.validate();
            }
            catch (UnsupportedOperationException uoe) {
                logger.info("ActivationSpec does not support validate. Implementation of validate is optional");
            }
            try {
                Validator validator = (Validator)beanContext.getJndiContext().lookup("comp/Validator");
                Set generalSet = validator.validate((Object)activationSpec, new Class[0]);
                if (!generalSet.isEmpty()) {
                    throw new ConstraintViolationException("Constraint violation for ActivationSpec " + this.activationSpecClass.getName(), generalSet);
                }
            }
            catch (NamingException e) {
                logger.debug("No Validator bound to JNDI context");
            }
            activationSpec.setResourceAdapter(this.resourceAdapter);
            return activationSpec;
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create activation spec", e);
        }
    }

    @Override
    public void start(BeanContext info) throws OpenEJBException {
        EjbTimerService timerService = info.getEjbTimerService();
        if (timerService != null) {
            timerService.start();
        }
    }

    @Override
    public void stop(BeanContext info) throws OpenEJBException {
        info.stop();
    }

    @Override
    public void undeploy(BeanContext beanContext) throws OpenEJBException {
        if (!(beanContext instanceof BeanContext)) {
            return;
        }
        try {
            this.instanceManager.undeploy(beanContext);
        }
        finally {
            beanContext.setContainer(null);
            beanContext.setContainerData(null);
            this.deployments.remove(beanContext.getDeploymentID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object deploymentId, InterfaceType type, Class callInterface, Method method, Object[] args, Object primKey) throws OpenEJBException {
        BeanContext beanContext = this.getBeanContext(deploymentId);
        ThreadContext callContext = new ThreadContext(beanContext, primKey);
        Instance instance = this.instanceManager.getInstance(callContext);
        try {
            this.beforeDelivery(beanContext, instance, method, null);
            Object value = this.invoke((Object)instance, method, type, args);
            this.afterDelivery(instance);
            Object object = value;
            return object;
        }
        finally {
            if (instance != null) {
                if (callContext.isDiscardInstance()) {
                    this.instanceManager.discardInstance(callContext, instance);
                } else {
                    this.instanceManager.poolInstance(callContext, instance);
                }
            }
        }
    }

    @Override
    public void beforeDelivery(BeanContext deployInfo, Object instance, Method method, XAResource xaResource) throws SystemException {
        ThreadContext callContext = new ThreadContext(deployInfo, null);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        MdbCallContext mdbCallContext = new MdbCallContext();
        callContext.set(MdbCallContext.class, mdbCallContext);
        mdbCallContext.deliveryMethod = method;
        mdbCallContext.oldCallContext = oldContext;
        try {
            mdbCallContext.txPolicy = EjbTransactionUtil.createTransactionPolicy(deployInfo.getTransactionType(method), callContext);
            if (xaResource != null && mdbCallContext.txPolicy.isNewTransaction()) {
                mdbCallContext.txPolicy.enlistResource(xaResource);
            }
        }
        catch (ApplicationException e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Should never get an Application exception", e);
        }
        catch (SystemException e) {
            ThreadContext.exit(oldContext);
            throw e;
        }
        catch (Exception e) {
            ThreadContext.exit(oldContext);
            throw new SystemException("Unable to enlist xa resource in the transaction", e);
        }
    }

    @Override
    public Object invoke(Object instance, Method method, InterfaceType type, Object ... args) throws SystemException, ApplicationException {
        Object object;
        block11: {
            OpenEJBException openEjbException;
            block12: {
                if (args == null) {
                    args = NO_ARGS;
                }
                ThreadContext callContext = ThreadContext.getThreadContext();
                BeanContext deployInfo = callContext.getBeanContext();
                MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
                if (mdbCallContext == null) {
                    throw new IllegalStateException("beforeDelivery was not called");
                }
                if (!mdbCallContext.deliveryMethod.getName().equals(method.getName()) || !Arrays.deepEquals(mdbCallContext.deliveryMethod.getParameterTypes(), method.getParameterTypes())) {
                    throw new IllegalStateException("Delivery method specified in beforeDelivery is not the delivery method called");
                }
                Object returnValue = null;
                openEjbException = null;
                Operation oldOperation = callContext.getCurrentOperation();
                callContext.setCurrentOperation(type == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS);
                try {
                    if (logger.isDebugEnabled()) {
                        logger.info("invoking method " + method.getName() + " on " + deployInfo.getDeploymentID());
                    }
                    Method targetMethod = deployInfo.getMatchingBeanMethod(method);
                    callContext.set(Method.class, targetMethod);
                    object = returnValue = this._invoke(instance, targetMethod, args, deployInfo, type, mdbCallContext, callContext);
                    callContext.setCurrentOperation(oldOperation);
                    if (!logger.isDebugEnabled()) break block11;
                    if (openEjbException != null) break block12;
                    logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                }
                catch (ApplicationException | SystemException e) {
                    try {
                        openEjbException = e;
                        throw e;
                    }
                    catch (Throwable throwable) {
                        callContext.setCurrentOperation(oldOperation);
                        if (logger.isDebugEnabled()) {
                            if (openEjbException == null) {
                                logger.debug("finished invoking method " + method.getName() + ". Return value:" + returnValue);
                            } else {
                                Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
                                logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
                            }
                        }
                        throw throwable;
                    }
                }
                break block11;
            }
            Throwable exception = openEjbException.getRootCause() != null ? openEjbException.getRootCause() : openEjbException;
            logger.debug("finished invoking method " + method.getName() + " with exception " + exception);
        }
        return object;
    }

    private Object _invoke(Object instance, Method runMethod, Object[] args, BeanContext beanContext, InterfaceType interfaceType, MdbCallContext mdbCallContext, ThreadContext callContext) throws SystemException, ApplicationException {
        try {
            List<InterceptorData> interceptors = beanContext.getMethodInterceptors(runMethod);
            InterceptorStack interceptorStack = new InterceptorStack(((Instance)instance).bean, runMethod, interfaceType == InterfaceType.TIMEOUT ? Operation.TIMEOUT : Operation.BUSINESS, interceptors, ((Instance)instance).interceptors);
            Object returnValue = interceptorStack.invoke(args);
            return returnValue;
        }
        catch (Throwable e) {
            ExceptionType type;
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            if ((type = beanContext.getExceptionType(e)) == ExceptionType.SYSTEM) {
                EjbTransactionUtil.handleSystemException(mdbCallContext.txPolicy, e, ThreadContext.getThreadContext());
                callContext.setDiscardInstance(true);
            } else {
                EjbTransactionUtil.handleApplicationException(mdbCallContext.txPolicy, e, false);
            }
            throw new AssertionError((Object)"Should not get here");
        }
    }

    @Override
    public void afterDelivery(Object instance) throws SystemException {
        ThreadContext callContext = ThreadContext.getThreadContext();
        MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
        try {
            EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
        }
        catch (ApplicationException e) {
            callContext.setDiscardInstance(true);
            throw new SystemException("Should never get an Application exception", e);
        }
        finally {
            if (instance != null) {
                if (callContext.isDiscardInstance()) {
                    this.instanceManager.discardInstance(callContext, instance);
                } else {
                    try {
                        this.instanceManager.poolInstance(callContext, instance);
                    }
                    catch (OpenEJBException e) {
                        throw new SystemException("Should never get an OpenEJBException exception", e);
                    }
                }
            }
            ThreadContext.exit(mdbCallContext.oldCallContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release(BeanContext deployInfo, Object instance) {
        block17: {
            ThreadContext callContext = ThreadContext.getThreadContext();
            boolean contextExitRequired = false;
            if (callContext == null) {
                callContext = new ThreadContext(deployInfo, null);
                ThreadContext.enter(callContext);
                contextExitRequired = true;
            }
            try {
                MdbCallContext mdbCallContext = callContext.get(MdbCallContext.class);
                if (mdbCallContext == null) break block17;
                try {
                    EjbTransactionUtil.afterInvoke(mdbCallContext.txPolicy, callContext);
                }
                catch (Exception e) {
                    logger.error("error while releasing message endpoint", e);
                }
                finally {
                    if (instance != null) {
                        try {
                            this.instanceManager.poolInstance(callContext, instance);
                        }
                        catch (OpenEJBException e) {
                            logger.error("error while releasing message endpoint", e);
                        }
                    }
                }
            }
            finally {
                if (contextExitRequired) {
                    ThreadContext.exit(callContext);
                }
            }
        }
    }

    private static class MdbCallContext {
        private Method deliveryMethod;
        private TransactionPolicy txPolicy;
        private ThreadContext oldCallContext;

        private MdbCallContext() {
        }
    }

    static class MdbActivationContext {
        private final ClassLoader classLoader;
        private final BeanContext beanContext;
        private final ResourceAdapter resourceAdapter;
        private final EndpointFactory endpointFactory;
        private final ActivationSpec activationSpec;
        private AtomicBoolean started = new AtomicBoolean(false);

        public MdbActivationContext(ClassLoader classLoader, BeanContext beanContext, ResourceAdapter resourceAdapter, EndpointFactory endpointFactory, ActivationSpec activationSpec) {
            this.classLoader = classLoader;
            this.beanContext = beanContext;
            this.resourceAdapter = resourceAdapter;
            this.endpointFactory = endpointFactory;
            this.activationSpec = activationSpec;
        }

        public EndpointFactory getEndpointFactory() {
            return this.endpointFactory;
        }

        public ResourceAdapter getResourceAdapter() {
            return this.resourceAdapter;
        }

        public ActivationSpec getActivationSpec() {
            return this.activationSpec;
        }

        public boolean isStarted() {
            return this.started.get();
        }

        public void start() throws ResourceException {
            if (!this.started.compareAndSet(false, true)) {
                return;
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.resourceAdapter.endpointActivation((MessageEndpointFactory)this.endpointFactory, this.activationSpec);
                logger.info("Activated endpoint for " + this.beanContext.getDeploymentID());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }

        public void stop() {
            if (!this.started.compareAndSet(true, false)) {
                return;
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.classLoader);
                this.resourceAdapter.endpointDeactivation((MessageEndpointFactory)this.endpointFactory, this.activationSpec);
                logger.info("Deactivated endpoint for " + this.beanContext.getDeploymentID());
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
        }
    }
}

