/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanCacheKey;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;

public class WebAppInjectionResolver
extends InjectionResolver {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, WebAppInjectionResolver.class);
    private final WebBeansContext context;
    private final boolean cacheResolutionFailure = Boolean.parseBoolean(SystemInstance.get().getProperty("openejb.cache.cdi-type-resolution-failure", "false"));
    private boolean startup;
    private final Set<BeanCacheKey> resolutionFailures = ConcurrentHashMap.newKeySet();

    public WebAppInjectionResolver(WebBeansContext ctx) {
        super(ctx);
        this.context = ctx;
        this.startup = true;
    }

    public Set<Bean<?>> implResolveByType(boolean delegate, Type injectionPointType, Class<?> injectionPointClass, Annotation ... qualifiers) {
        Set set;
        if (!this.startup && this.cacheResolutionFailure) {
            BeanCacheKey cacheKey;
            ScannerService scannerService = this.context.getScannerService();
            String bdaBeansXMLFilePath = null;
            if (scannerService.isBDABeansXmlScanningEnabled()) {
                bdaBeansXMLFilePath = this.getBDABeansXMLPath(injectionPointClass);
            }
            if (this.resolutionFailures.contains(cacheKey = new BeanCacheKey(delegate, injectionPointType, bdaBeansXMLFilePath, this::findQualifierModel, qualifiers))) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolution of " + cacheKey + " has previously failed, returning empty set from cache");
                }
                set = Collections.emptySet();
            } else {
                set = super.implResolveByType(delegate, injectionPointType, injectionPointClass, qualifiers);
                if (set.isEmpty()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Caching resolution failure of " + cacheKey);
                    }
                    this.resolutionFailures.add(cacheKey);
                }
            }
        } else {
            set = super.implResolveByType(delegate, injectionPointType, injectionPointClass, qualifiers);
        }
        if (this.context instanceof WebappWebBeansContext) {
            WebappWebBeansContext wwbc = (WebappWebBeansContext)this.context;
            if (set.isEmpty() && wwbc.getParent() != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Resolution of " + injectionPointType.getTypeName() + " from context failed, trying to resolve from parent context");
                }
                return wwbc.getParent().getBeanManagerImpl().getInjectionResolver().implResolveByType(delegate, injectionPointType, injectionPointClass, qualifiers);
            }
        }
        return set;
    }

    private String getBDABeansXMLPath(Class<?> injectionPointBeanClass) {
        if (injectionPointBeanClass == null) {
            return null;
        }
        ScannerService scannerService = this.context.getScannerService();
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        return beansXMLScanner.getBeansXml(injectionPointBeanClass);
    }

    private AnnotatedType<? extends Annotation> findQualifierModel(Class<?> qualifier) {
        return (AnnotatedType)this.context.getBeanManagerImpl().getAdditionalAnnotatedTypeQualifiers().get(qualifier);
    }

    public void setStartup(boolean startup) {
        this.startup = startup;
        super.setStartup(startup);
    }

    public void clearCaches() {
        super.clearCaches();
        this.resolutionFailures.clear();
    }

    public int getCacheSize() {
        return this.resolutionFailures.size();
    }
}

