/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.TokenIntrospection;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OAuthJSONProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    public long getSize(Object obj, Class<?> clt, Type t, Annotation[] anns, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return cls == ClientAccessToken.class || cls == OAuthError.class || cls == TokenIntrospection.class;
    }

    public void writeTo(Object obj, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (obj instanceof ClientAccessToken) {
            this.writeAccessToken((ClientAccessToken)obj, os);
        } else if (obj instanceof TokenIntrospection) {
            this.writeTokenIntrospection((TokenIntrospection)obj, os);
        } else {
            this.writeOAuthError((OAuthError)obj, os);
        }
    }

    private void writeTokenIntrospection(TokenIntrospection obj, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.appendJsonPair(sb, "active", obj.isActive(), false);
        if (obj.isActive()) {
            if (obj.getClientId() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "client_id", obj.getClientId());
            }
            if (obj.getUsername() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "username", obj.getUsername());
            }
            if (obj.getTokenType() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "token_type", obj.getTokenType());
            }
            if (obj.getScope() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "scope", obj.getScope());
            }
            if (!StringUtils.isEmpty(obj.getAud())) {
                sb.append(',');
                if (obj.getAud().size() == 1) {
                    this.appendJsonPair(sb, "aud", obj.getAud().get(0));
                } else {
                    StringBuilder arr = new StringBuilder();
                    arr.append('[');
                    List<String> list = obj.getAud();
                    for (int i = 0; i < list.size(); ++i) {
                        if (i > 0) {
                            arr.append(',');
                        }
                        arr.append('\"').append(list.get(i)).append('\"');
                    }
                    arr.append(']');
                    this.appendJsonPair(sb, "aud", arr.toString(), false);
                }
            }
            if (obj.getIss() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "iss", obj.getIss());
            }
            sb.append(',');
            this.appendJsonPair(sb, "iat", obj.getIat(), false);
            if (obj.getExp() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "exp", obj.getExp(), false);
            }
            if (obj.getNbf() != null) {
                sb.append(',');
                this.appendJsonPair(sb, "nbf", obj.getNbf(), false);
            }
            if (!obj.getExtensions().isEmpty()) {
                for (Map.Entry entry : obj.getExtensions().entrySet()) {
                    sb.append(',');
                    if ("x5t#S256".equals(entry.getKey())) {
                        StringBuilder cnfObj = new StringBuilder();
                        cnfObj.append('{');
                        this.appendJsonPair(cnfObj, (String)entry.getKey(), entry.getValue());
                        cnfObj.append('}');
                        this.appendJsonPair(sb, "cnf", cnfObj.toString(), false);
                        continue;
                    }
                    this.appendJsonPair(sb, (String)entry.getKey(), entry.getValue());
                }
            }
        }
        sb.append('}');
        String result = sb.toString();
        os.write(result.getBytes(StandardCharsets.UTF_8));
        os.flush();
    }

    private void writeOAuthError(OAuthError obj, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.appendJsonPair(sb, "error", obj.getError());
        if (obj.getErrorDescription() != null) {
            sb.append(',');
            this.appendJsonPair(sb, "error_description", obj.getErrorDescription());
        }
        if (obj.getErrorUri() != null) {
            sb.append(',');
            this.appendJsonPair(sb, "error_uri", obj.getErrorUri());
        }
        sb.append('}');
        String result = sb.toString();
        os.write(result.getBytes(StandardCharsets.UTF_8));
        os.flush();
    }

    private void writeAccessToken(ClientAccessToken obj, OutputStream os) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.appendJsonPair(sb, "access_token", obj.getTokenKey());
        sb.append(',');
        this.appendJsonPair(sb, "token_type", obj.getTokenType());
        if (obj.getExpiresIn() != -1L) {
            sb.append(',');
            this.appendJsonPair(sb, "expires_in", obj.getExpiresIn(), false);
        }
        if (obj.getApprovedScope() != null) {
            sb.append(',');
            this.appendJsonPair(sb, "scope", obj.getApprovedScope());
        }
        if (obj.getRefreshToken() != null) {
            sb.append(',');
            this.appendJsonPair(sb, "refresh_token", obj.getRefreshToken());
        }
        Map<String, String> parameters = obj.getParameters();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            sb.append(',');
            this.appendJsonPair(sb, entry.getKey(), entry.getValue());
        }
        sb.append('}');
        String result = sb.toString();
        os.write(result.getBytes(StandardCharsets.UTF_8));
        os.flush();
    }

    private void appendJsonPair(StringBuilder sb, String key, Object value) {
        this.appendJsonPair(sb, key, value, true);
    }

    private void appendJsonPair(StringBuilder sb, String key, Object value, boolean valueQuote) {
        sb.append('\"').append(key).append('\"');
        sb.append(':');
        if (valueQuote) {
            sb.append('\"');
        }
        sb.append(value);
        if (valueQuote) {
            sb.append('\"');
        }
    }

    public boolean isReadable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return Map.class.isAssignableFrom(cls) || ClientAccessToken.class.isAssignableFrom(cls) || TokenIntrospection.class.isAssignableFrom(cls);
    }

    public Object readFrom(Class<Object> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        if (TokenIntrospection.class.isAssignableFrom(cls)) {
            return this.fromMapToTokenIntrospection(is);
        }
        Map<String, String> params = this.readJSONResponse(is);
        if (Map.class.isAssignableFrom(cls)) {
            return params;
        }
        ClientAccessToken token = OAuthClientUtils.fromMapToClientToken(params);
        if (token == null) {
            throw new WebApplicationException(500);
        }
        return token;
    }

    private Object fromMapToTokenIntrospection(InputStream is) throws IOException {
        String thumbprint;
        Map cnf;
        Long nbf;
        Long exp;
        Long iat;
        String iss;
        Object aud;
        String tokenType;
        String scope;
        String username;
        TokenIntrospection resp = new TokenIntrospection();
        Map<String, Object> params = new JsonMapObjectReaderWriter().fromJson(is);
        resp.setActive((Boolean)params.get("active"));
        String clientId = (String)params.get("client_id");
        if (clientId != null) {
            resp.setClientId(clientId);
        }
        if ((username = (String)params.get("username")) != null) {
            resp.setUsername(username);
        }
        if ((scope = (String)params.get("scope")) != null) {
            resp.setScope(scope);
        }
        if ((tokenType = (String)params.get("token_type")) != null) {
            resp.setTokenType(tokenType);
        }
        if ((aud = params.get("aud")) != null) {
            if (aud.getClass() == String.class) {
                resp.setAud(Collections.singletonList((String)aud));
            } else {
                List auds = (List)aud;
                resp.setAud(auds);
            }
        }
        if ((iss = (String)params.get("iss")) != null) {
            resp.setIss(iss);
        }
        if ((iat = (Long)params.get("iat")) != null) {
            resp.setIat(iat);
        }
        if ((exp = (Long)params.get("exp")) != null) {
            resp.setExp(exp);
        }
        if ((nbf = (Long)params.get("nbf")) != null) {
            resp.setNbf(nbf);
        }
        if ((cnf = CastUtils.cast((Map)params.get("cnf"))) != null && (thumbprint = (String)cnf.get("x5t#S256")) != null) {
            resp.getExtensions().put("x5t#S256", thumbprint);
        }
        return resp;
    }

    public Map<String, String> readJSONResponse(InputStream is) throws IOException {
        String str = IOUtils.readStringFromStream(is).trim();
        if (str.length() == 0) {
            return Collections.emptyMap();
        }
        Map<String, Object> response = new JsonMapObjectReaderWriter().fromJson(str);
        HashMap<String, String> forcedStringResponse = new HashMap<String, String>(response.size());
        for (Map.Entry<String, Object> entry : response.entrySet()) {
            forcedStringResponse.put(entry.getKey(), entry.getValue().toString());
        }
        return forcedStringResponse;
    }
}

