/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.catalina.core.StandardContext;

public class NamingUtil {
    public static final String NAME = "name";
    public static final String DEPLOYMENT_ID = "deploymentid";
    public static final String EXTERNAL = "external";
    public static final String LOCAL = "local";
    public static final String LOCALBEAN = "localbean";
    public static final String REMOTE = "remote";
    public static final String JNDI_NAME = "jndiname";
    public static final String JNDI_PROVIDER_ID = "jndiproviderid";
    public static final String UNIT = "unit";
    public static final String EXTENDED = "extended";
    public static final String PROPERTIES = "properties";
    public static final String RESOURCE_ID = "resourceid";
    public static final String COMPONENT_TYPE = "componenttype";
    public static final String WS_ID = "wsid";
    public static final String WS_CLASS = "wsclass";
    public static final String WS_QNAME = "wsqname";
    public static final String WS_PORT_QNAME = "wsportqname";
    public static final String WSDL_URL = "wsdlurl";
    private static final AtomicInteger ID = new AtomicInteger(31);
    private static final Map<String, Object> REGISTRY = new ConcurrentHashMap<String, Object>();
    private static StandardContext currentContext;
    private static Map<StandardContext, Collection<String>> ID_BY_CONTEXT;

    public static String getProperty(Reference ref, String name) {
        RefAddr addr = ref.get(name);
        if (addr == null) {
            return null;
        }
        Object value = addr.getContent();
        return (String)value;
    }

    public static boolean isPropertyTrue(Reference ref, String name) {
        RefAddr addr = ref.get(name);
        if (addr == null) {
            return false;
        }
        Object value = addr.getContent();
        return Boolean.parseBoolean(String.valueOf(value));
    }

    public static void setStaticValue(Resource resource, Object value) {
        NamingUtil.setStaticValue(resource, null, value);
    }

    public static void setStaticValue(Resource resource, String name, Object value) {
        String token = String.valueOf(ID.incrementAndGet());
        REGISTRY.put(token, value);
        resource.setProperty("static-token" + (name != null ? "-" + name : ""), token);
        if (currentContext != null) {
            Collection<String> ids = ID_BY_CONTEXT.get(currentContext);
            if (ids == null) {
                ids = new ArrayList<String>();
                ID_BY_CONTEXT.put(currentContext, ids);
            }
            ids.add(token);
        }
    }

    public static <T> T getStaticValue(Reference ref) {
        return NamingUtil.getStaticValue(ref, null);
    }

    public static <T> T getStaticValue(Reference ref, String name) {
        name = name != null ? "-" + name : "";
        String token = NamingUtil.getProperty(ref, "static-token" + name);
        if (token == null) {
            return null;
        }
        Object object = REGISTRY.get(token);
        return (T)object;
    }

    public static Class<?> loadClass(String className) {
        if (className == null) {
            return null;
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    Class<?> clazz = classLoader.loadClass(className);
                    return clazz;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void setCurrentContext(StandardContext currentContext) {
        NamingUtil.currentContext = currentContext;
    }

    public static void cleanUpContextResource(StandardContext context) {
        Collection<String> keys = ID_BY_CONTEXT.remove(context);
        if (keys != null) {
            for (String k : keys) {
                REGISTRY.remove(k);
            }
        }
    }

    static {
        ID_BY_CONTEXT = new HashMap<StandardContext, Collection<String>>();
    }

    public static interface Resource {
        public void setProperty(String var1, Object var2);
    }
}

