/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs.johnzon;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.Provider;
import org.apache.johnzon.jaxrs.ConfigurableJohnzonProvider;
import org.apache.johnzon.mapper.Adapter;
import org.apache.johnzon.mapper.Converter;
import org.apache.johnzon.mapper.MapperBuilder;
import org.apache.johnzon.mapper.converter.DateConverter;
import org.apache.johnzon.mapper.internal.ConverterAdapter;
import org.apache.openejb.util.reflection.Reflections;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TomEEConfigurableJohnzon<T>
extends ConfigurableJohnzonProvider<T> {
    private MapperBuilder localBuilder;

    public void setConverters(Collection<Converter<?>> converters) {
        for (Converter<?> converter : converters) {
            Type type = this.findType(converter, Converter.class);
            this.builder().addAdapter(((ParameterizedType)ParameterizedType.class.cast(type)).getActualTypeArguments()[0], String.class, (Adapter)new ConverterAdapter(converter, type));
        }
    }

    public void setConverter(Converter<?> converter) {
        this.setConverters(Collections.singletonList(converter));
    }

    public void setAdapter(Adapter<?, ?> converter) {
        this.setAdapters(Collections.singletonList(converter));
    }

    public void setAdapters(Collection<Adapter<?, ?>> adapters) {
        for (Adapter<?, ?> adapter : adapters) {
            Type type = this.findType(adapter, Adapter.class);
            ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(type);
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            this.builder().addAdapter(actualTypeArguments[0], actualTypeArguments[1], adapter);
        }
    }

    public void setDatePattern(String datePattern) {
        this.builder().addAdapter(Date.class, String.class, (Adapter)new ConverterAdapter((Converter)new DateConverter(datePattern), Date.class));
    }

    private Type findType(Object ref, Class<?> api) {
        for (Type type : ref.getClass().getGenericInterfaces()) {
            if (!ParameterizedType.class.isInstance(type) || ((ParameterizedType)ParameterizedType.class.cast(type)).getRawType() != api) continue;
            return type;
        }
        throw new IllegalArgumentException("Didn't find " + ref + " in interfaces: " + Arrays.asList(ref.getClass().getGenericInterfaces()));
    }

    private MapperBuilder builder() {
        return this.localBuilder == null ? (this.localBuilder = (MapperBuilder)MapperBuilder.class.cast(Reflections.get((Object)((Object)this), (String)"builder"))) : this.localBuilder;
    }
}

