/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.openejb.client.ArrayEnumeration;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.httpd.HttpSession;
import org.apache.openejb.server.httpd.LightweightWebAppBuilderListenerExtractor;
import org.apache.openejb.server.httpd.session.SessionManager;

public class HttpSessionImpl
implements HttpSession {
    private Collection<HttpSessionListener> listeners;
    private String sessionId = UUID.randomUUID().toString();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private final long created;
    private volatile long timeout;
    private volatile long lastAccessed = this.created = System.currentTimeMillis();
    private volatile boolean valid = true;

    public HttpSessionImpl(String contextPath, long timeout) {
        this.timeout = timeout;
        if (contextPath == null) {
            return;
        }
        this.listeners = LightweightWebAppBuilderListenerExtractor.findByTypeForContext(contextPath, HttpSessionListener.class);
    }

    public void callListeners() {
        if (!this.listeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((javax.servlet.http.HttpSession)this);
            for (HttpSessionListener o : this.listeners) {
                ((HttpSessionListener)HttpSessionListener.class.cast(o)).sessionCreated(event);
            }
        }
    }

    public HttpSessionImpl() {
        this(null, 30000L);
    }

    public void newSessionId() {
        this.sessionId = UUID.randomUUID().toString();
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
        this.touch();
    }

    private void touch() {
        this.lastAccessed = System.currentTimeMillis();
    }

    public void removeValue(String s) {
        for (String key : this.attributes.keySet()) {
            if (!this.attributes.get(key).equals(s)) continue;
            this.attributes.remove(key);
        }
        this.touch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (!this.valid) {
            return;
        }
        HttpSessionImpl httpSessionImpl = this;
        synchronized (httpSessionImpl) {
            SessionManager sessionManager;
            if (!this.valid) {
                return;
            }
            if (!this.listeners.isEmpty()) {
                HttpSessionEvent event = new HttpSessionEvent((javax.servlet.http.HttpSession)this);
                for (HttpSessionListener o : this.listeners) {
                    try {
                        ((HttpSessionListener)HttpSessionListener.class.cast(o)).sessionDestroyed(event);
                    }
                    catch (Throwable throwable) {}
                }
            }
            if ((sessionManager = (SessionManager)SystemInstance.get().getComponent(SessionManager.class)) != null) {
                sessionManager.removeSession(this.sessionId);
            }
            this.valid = false;
        }
    }

    public boolean isNew() {
        return false;
    }

    @Override
    public Object getAttribute(String name) {
        this.touch();
        return this.attributes.get(name);
    }

    public Object getValue(String s) {
        this.touch();
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        this.touch();
        return new ArrayEnumeration(new ArrayList<String>(this.attributes.keySet()));
    }

    public String[] getValueNames() {
        this.touch();
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
        this.touch();
    }

    public void putValue(String s, Object o) {
        this.setAttribute(s, o);
    }

    public long getCreationTime() {
        return this.created;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    public ServletContext getServletContext() {
        this.touch();
        return (ServletContext)SystemInstance.get().getComponent(ServletContext.class);
    }

    public void setMaxInactiveInterval(int i) {
        this.touch();
        this.timeout = i;
    }

    public int getMaxInactiveInterval() {
        return (int)this.timeout;
    }

    public HttpSessionContext getSessionContext() {
        this.touch();
        final SessionManager component = (SessionManager)SystemInstance.get().getComponent(SessionManager.class);
        return new HttpSessionContext(){

            public javax.servlet.http.HttpSession getSession(String sessionId) {
                SessionManager.SessionWrapper event = component.findSession(sessionId);
                return event == null ? null : event.getSession();
            }

            public Enumeration<String> getIds() {
                return Collections.enumeration(component.findSessionIds());
            }
        };
    }
}

