/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.servlet.ServletContext;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import org.apache.geronimo.microprofile.openapi.cdi.GeronimoOpenAPIExtension;
import org.apache.geronimo.microprofile.openapi.config.GeronimoOpenAPIConfig;
import org.apache.geronimo.microprofile.openapi.impl.filter.FilterImpl;
import org.apache.geronimo.microprofile.openapi.impl.loader.DefaultLoader;
import org.apache.geronimo.microprofile.openapi.impl.loader.yaml.Yaml;
import org.apache.geronimo.microprofile.openapi.impl.model.PathsImpl;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedMethodElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotatedTypeElement;
import org.apache.geronimo.microprofile.openapi.impl.processor.AnnotationProcessor;
import org.apache.geronimo.microprofile.openapi.impl.processor.spi.NamingStrategy;
import org.apache.geronimo.microprofile.openapi.jaxrs.JacksonOpenAPIYamlBodyWriter;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

public class TomEEOpenAPIExtension
extends GeronimoOpenAPIExtension
implements Extension {
    private final Collection<Bean<?>> endpoints = new ArrayList();
    private final Map<Application, OpenAPI> openapis = new HashMap<Application, OpenAPI>();
    private GeronimoOpenAPIConfig config;
    private AnnotationProcessor processor;
    private boolean skipScan;
    private Collection<String> classes;
    private Collection<String> packages;
    private Collection<String> excludePackages;
    private Collection<String> excludeClasses;
    private boolean jacksonIsPresent;

    void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.config = GeronimoOpenAPIConfig.create();
        this.processor = new AnnotationProcessor(this.config, this.loadNamingStrategy(this.config), null);
        this.skipScan = Boolean.parseBoolean(this.config.read("mp.openapi.scan.disable", "false"));
        this.classes = this.getConfigCollection("mp.openapi.scan.classes");
        this.packages = this.getConfigCollection("mp.openapi.scan.packages");
        this.excludePackages = this.getConfigCollection("mp.openapi.scan.exclude.packages");
        this.excludeClasses = this.getConfigCollection("mp.openapi.scan.exclude.classes");
        try {
            Yaml.getObjectMapper();
            this.jacksonIsPresent = true;
        }
        catch (Error | RuntimeException throwable) {
            // empty catch block
        }
    }

    public MediaType getDefaultMediaType() {
        return this.jacksonIsPresent ? new MediaType("text", "vnd.yaml") : MediaType.APPLICATION_JSON_TYPE;
    }

    private NamingStrategy loadNamingStrategy(GeronimoOpenAPIConfig config) {
        return Optional.ofNullable(config.read("model.operation.naming.strategy", null)).map(String::trim).filter(it -> !it.isEmpty()).map(it -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)it).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalArgumentException(ite.getTargetException());
            }
        }).map(NamingStrategy.class::cast).orElseGet(NamingStrategy.Default::new);
    }

    void vetoJacksonIfNotHere(@Observes ProcessAnnotatedType<JacksonOpenAPIYamlBodyWriter> event) {
        if (!this.jacksonIsPresent) {
            event.veto();
        }
    }

    <T> void findEndpointsAndApplication(@Observes ProcessBean<T> event) {
        block2: {
            block3: {
                String typeName = event.getAnnotated().getBaseType().getTypeName();
                if (this.classes != null || this.skipScan || !event.getAnnotated().isAnnotationPresent(Path.class) || event.getAnnotated().isAnnotationPresent(RegisterRestClient.class) || typeName.startsWith("org.apache.geronimo.microprofile.openapi.")) break block2;
                if (this.packages == null) break block3;
                if (!this.packages.stream().anyMatch(typeName::startsWith)) break block2;
            }
            this.endpoints.add(event.getBean());
        }
    }

    public OpenAPI getOrCreateOpenAPI(Application application) {
        if (this.classes != null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return this.openapis.computeIfAbsent(application, app -> this.createOpenApi(application.getClass(), this.classes.stream().map(c -> {
                try {
                    return loader.loadClass((String)c);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            })));
        }
        if (!(this.packages != null || application.getSingletons().isEmpty() && application.getClasses().isEmpty())) {
            return this.openapis.computeIfAbsent(application, app -> this.createOpenApi(application.getClass(), Stream.concat(this.endpoints.stream().map(Bean::getBeanClass), Stream.concat(app.getClasses().stream(), app.getSingletons().stream().map(Object::getClass)))));
        }
        return this.openapis.computeIfAbsent(application, app -> this.createOpenApi(application.getClass(), this.endpoints.stream().map(Bean::getBeanClass)));
    }

    private Collection<String> getConfigCollection(String key) {
        return Optional.ofNullable(this.config.read(key, null)).map(vals -> Stream.of(vals.split(",")).map(String::trim).filter(v -> !v.isEmpty()).collect(Collectors.toSet())).orElse(null);
    }

    private OpenAPI createOpenApi(Class<?> application, Stream<Class<?>> beans) {
        CDI current = CDI.current();
        OpenAPI api = Optional.ofNullable(this.config.read("mp.openapi.model.reader", null)).map(value -> this.newInstance((CDI<Object>)current, (String)value)).map(it -> ((OASModelReader)OASModelReader.class.cast(it)).buildModel()).orElseGet(() -> ((DefaultLoader)current.select(DefaultLoader.class, new Annotation[0]).get()).loadDefaultApi());
        BeanManager beanManager = current.getBeanManager();
        this.processor.processApplication(api, (AnnotatedElement)new ElementImpl((Annotated)beanManager.createAnnotatedType(application)));
        if (this.skipScan) {
            return api.paths((Paths)new PathsImpl());
        }
        Instance servletContextInstance = current.select(ServletContext.class, new Annotation[0]);
        boolean appendContextPath = Boolean.valueOf(this.config.read("application.append-context-path", "true"));
        String contextPath = "";
        if (appendContextPath && !servletContextInstance.isAmbiguous() && !servletContextInstance.isUnsatisfied()) {
            contextPath = ((ServletContext)servletContextInstance.get()).getContextPath();
        }
        String base = contextPath + this.processor.getApplicationBinding(application);
        this.processor.beforeProcessing();
        beans.filter(c -> this.excludeClasses == null || !this.excludeClasses.contains(c.getName())).filter(c -> this.excludePackages == null || this.excludePackages.stream().noneMatch(it -> c.getName().startsWith((String)it))).map(arg_0 -> ((BeanManager)beanManager).createAnnotatedType(arg_0)).forEach(at -> this.processor.processClass(base, api, (AnnotatedElement)new ElementImpl((Annotated)at), at.getMethods().stream().map(x$0 -> new MethodElementImpl((AnnotatedMethod)x$0))));
        return Optional.ofNullable(this.config.read("mp.openapi.filter", null)).map(it -> this.newInstance((CDI<Object>)current, (String)it)).map(i -> new FilterImpl((OASFilter)OASFilter.class.cast(i)).filter(api)).orElse(api);
    }

    private Object newInstance(CDI<Object> current, String value) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(value.trim());
            try {
                Instance instance = current.select(clazz, new Annotation[0]);
                if (!instance.isAmbiguous() && !instance.isUnsatisfied()) {
                    return instance.get();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't load " + value, e);
        }
    }

    private static class ElementImpl
    implements AnnotatedElement {
        private final Annotated delegate;

        private ElementImpl(Annotated annotated) {
            this.delegate = annotated;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.delegate.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.delegate.getAnnotations().toArray(new Annotation[0]);
        }

        @Override
        public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
            return this.delegate.getAnnotations(annotationClass).toArray((Annotation[])Array.newInstance(annotationClass, 0));
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }
    }

    private static class MethodElementImpl
    extends ElementImpl
    implements AnnotatedMethodElement {
        private final AnnotatedMethod<?> delegate;

        private MethodElementImpl(AnnotatedMethod<?> delegate) {
            super((Annotated)delegate);
            this.delegate = delegate;
        }

        public String getName() {
            return this.delegate.getJavaMember().getName();
        }

        public Type getReturnType() {
            return this.delegate.getJavaMember().getGenericReturnType();
        }

        public Class<?> getDeclaringClass() {
            return this.delegate.getDeclaringType().getJavaClass();
        }

        public AnnotatedTypeElement[] getParameters() {
            return (AnnotatedTypeElement[])this.delegate.getParameters().stream().map(p -> new TypeElementImpl(p.getBaseType(), (Annotated)p)).toArray(TypeElementImpl[]::new);
        }
    }

    private static class TypeElementImpl
    extends ElementImpl
    implements AnnotatedTypeElement {
        private final Type type;

        private TypeElementImpl(Type type, Annotated delegate) {
            super(delegate);
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }
    }
}

