/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.client;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.impl.JaxRsHeaderTextMap;

@ApplicationScoped
public class OpenTracingClientRequestFilter
implements ClientRequestFilter {
    @Inject
    private Tracer tracer;
    @Inject
    private GeronimoOpenTracingConfig config;
    private boolean skip;
    private boolean skipDefaultTags;
    private boolean skipPeerTags;

    @PostConstruct
    private void init() {
        this.skip = Boolean.parseBoolean(this.config.read("client.filter.request.skip", "false"));
        this.skipDefaultTags = Boolean.parseBoolean(this.config.read("client.filter.request.skipDefaultTags", "false"));
        this.skipPeerTags = Boolean.parseBoolean(this.config.read("client.filter.request.skipPeerTags", "false"));
    }

    public void filter(ClientRequestContext context) {
        if (context.getProperty(OpenTracingClientRequestFilter.class.getName()) != null || this.skip) {
            return;
        }
        Tracer.SpanBuilder builder = this.tracer.buildSpan(context.getMethod());
        builder.withTag(Tags.SPAN_KIND.getKey(), "client");
        builder.withTag("component", "jaxrs");
        Optional.ofNullable(SpanContext.class.cast(context.getProperty("child_of"))).ifPresent(parent -> builder.ignoreActiveSpan().asChildOf(parent));
        Scope scope = builder.startActive(true);
        Span span = scope.span();
        if (!this.skipDefaultTags) {
            Tags.HTTP_METHOD.set(span, context.getMethod());
            Tags.HTTP_URL.set(span, context.getUri().toASCIIString());
        }
        if (!this.skipPeerTags) {
            String host = context.getUri().getHost();
            Tags.PEER_HOSTNAME.set(span, host);
            Tags.PEER_PORT.set(span, Integer.valueOf(context.getUri().getPort()));
        }
        Optional.ofNullable(context.getProperty("org.apache.geronimo.microprofile.opentracing.spanConsumer")).ifPresent(consumer -> ((Consumer)Consumer.class.cast(consumer)).accept(span));
        this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, new JaxRsHeaderTextMap(context.getHeaders()));
        context.setProperty(OpenTracingClientRequestFilter.class.getName(), (Object)scope);
    }
}

