/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.enterprise.inject.spi.Extension;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.activemq.jms2.cdi.JMS2CDIExtension;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.service.DefaultLoaderService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;

public class OptimizedLoaderService
implements LoaderService {
    private static final Logger log = Logger.getInstance(LogCategory.OPENEJB.createChild("cdi"), OptimizedLoaderService.class);
    public static final ThreadLocal<Collection<String>> ADDITIONAL_EXTENSIONS = new ThreadLocal();
    private final LoaderService loaderService;
    private final Properties config;

    public OptimizedLoaderService(Properties appConfig) {
        this(OptimizedLoaderService.is("openejb.cdi.ignore-not-loadable-extensions", appConfig, SystemInstance.get().getProperties(), "false") ? new FilterableServiceLoader() : new DefaultLoaderService(), appConfig);
    }

    public OptimizedLoaderService(LoaderService loaderService, Properties appConfig) {
        this.loaderService = loaderService;
        this.config = appConfig;
    }

    public <T> List<T> load(Class<T> serviceType) {
        return this.load(serviceType, Thread.currentThread().getContextClassLoader());
    }

    public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        if (OpenWebBeansPlugin.class.equals(serviceType)) {
            return this.loadWebBeansPlugins(classLoader);
        }
        if (Extension.class.equals(serviceType)) {
            return this.loadExtensions(classLoader);
        }
        return this.loaderService.load(serviceType, classLoader);
    }

    protected List<? extends Extension> loadExtensions(ClassLoader classLoader) {
        List list = this.loaderService.load(Extension.class, classLoader);
        Collection<String> additional = ADDITIONAL_EXTENSIONS.get();
        if (additional != null) {
            for (String name : additional) {
                try {
                    list.add((Extension)Extension.class.cast(classLoader.loadClass(name).newInstance()));
                }
                catch (Exception exception) {}
            }
        }
        if (this.hasJms()) {
            list.add(new JMS2CDIExtension());
        }
        ArrayList<Extension> extensionCopy = new ArrayList<Extension>(list);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!it.hasNext() || !this.isFiltered(extensionCopy, (Extension)it.next())) continue;
            it.remove();
        }
        if ("true".equals(this.config.getProperty("openejb.cdi.extensions.sorted", SystemInstance.get().getProperty("openejb.cdi.extensions.sorted")))) {
            list.sort(new Comparator<Extension>(){

                @Override
                public int compare(Extension o1, Extension o2) {
                    int val2;
                    int val1 = this.getVal(o1);
                    if (val1 == (val2 = this.getVal(o1))) {
                        return o1.getClass().getName().compareTo(o2.getClass().getName());
                    }
                    return val1 - val2;
                }

                private int getVal(Extension o1) {
                    String key = "openejb.cdi.extensions." + o1.getClass().getName() + ".ordinal";
                    String config = OptimizedLoaderService.this.config.getProperty(key, SystemInstance.get().getProperty(key));
                    return config == null ? 0 : Integer.parseInt(config.trim());
                }
            });
        }
        return list;
    }

    private boolean hasJms() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.apache.activemq.ra.ActiveMQManagedConnectionFactory");
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }

    private boolean isFiltered(Collection<Extension> extensions, Extension next) {
        SystemInstance systemInstance;
        ClassLoader containerLoader = ParentClassLoaderFinder.Helper.get();
        Class<?> extClass = next.getClass();
        String name = extClass.getName();
        String activeKey = name + ".active";
        if (!OptimizedLoaderService.is(activeKey, this.config, (systemInstance = SystemInstance.get()).getProperties(), "true")) {
            return true;
        }
        switch (name) {
            case "org.apache.geronimo.microprofile.openapi.cdi.GeronimoOpenAPIExtension": {
                return true;
            }
            case "org.apache.bval.cdi.BValExtension": {
                for (Extension e : extensions) {
                    String en = e.getClass().getName();
                    if (!en.startsWith("org.hibernate.validator.") || !en.endsWith("ValidationExtension")) continue;
                    log.info("Skipping BVal CDI integration cause hibernate was found in the application");
                    return true;
                }
                break;
            }
            case "org.apache.batchee.container.cdi.BatchCDIInjectionExtension": {
                return "true".equals(systemInstance.getProperty("tomee.batchee.cdi.use-extension", "false"));
            }
            case "org.apache.commons.jcs.jcache.cdi.MakeJCacheCDIInterceptorFriendly": {
                String spi = "META-INF/services/javax.cache.spi.CachingProvider";
                try {
                    Enumeration<URL> appResources = Thread.currentThread().getContextClassLoader().getResources("META-INF/services/javax.cache.spi.CachingProvider");
                    if (appResources == null || !appResources.hasMoreElements()) break;
                    ArrayList<URL> containerResources = Collections.list(containerLoader.getResources("META-INF/services/javax.cache.spi.CachingProvider"));
                    do {
                        if (containerResources.contains(appResources.nextElement())) continue;
                        log.info("Skipping JCS CDI integration cause another provide was found in the application");
                        return true;
                    } while (appResources.hasMoreElements());
                }
                catch (Exception exception) {}
                break;
            }
        }
        return false;
    }

    private List<? extends OpenWebBeansPlugin> loadWebBeansPlugins(ClassLoader loader) {
        ArrayList<CdiPlugin> list = new ArrayList<CdiPlugin>(2);
        list.add(new CdiPlugin());
        try {
            Class<?> clazz = loader.loadClass("org.apache.geronimo.openejb.cdi.GeronimoWebBeansPlugin");
            try {
                list.add((CdiPlugin)((OpenWebBeansPlugin)OpenWebBeansPlugin.class.cast(clazz.newInstance())));
            }
            catch (Exception e) {
                log.error("Unable to load OpenWebBeansPlugin: GeronimoWebBeansPlugin");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }

    private static boolean is(String activeKey, Properties config, Properties fallback, String or) {
        return Boolean.parseBoolean(config.getProperty(activeKey, fallback.getProperty(activeKey, or)));
    }

    private static class FilterableServiceLoader
    implements LoaderService {
        private static final String SERVICE_CONFIG = "META-INF/services/" + Extension.class.getName();
        private static final String FILE_ENCODING = "UTF-8";
        private List<Class<?>> foundServiceClasses = new ArrayList();
        private ClassLoader loader;

        private FilterableServiceLoader() {
        }

        private List<Extension> loadServiceImplementations() {
            List<Class<?>> result = this.resolveServiceImplementations();
            if (result == null) {
                return Collections.emptyList();
            }
            ArrayList<Extension> foundServices = new ArrayList<Extension>();
            for (Class<?> serviceClass : result) {
                try {
                    foundServices.add((Extension)Extension.class.cast(serviceClass.newInstance()));
                }
                catch (IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
                    log.error("Ignoring a CDI Extension, cause it can't be instantiated (" + serviceClass + "): " + e.getMessage());
                }
            }
            return foundServices;
        }

        private List<Class<?>> resolveServiceImplementations() {
            for (URL configFile : this.getConfigFileList()) {
                this.loadConfiguredServices(configFile);
            }
            return this.foundServiceClasses;
        }

        private List<URL> getConfigFileList() {
            ArrayList<URL> serviceFiles = new ArrayList<URL>();
            try {
                Enumeration<URL> serviceFileEnumerator = this.loader.getResources(SERVICE_CONFIG);
                while (serviceFileEnumerator.hasMoreElements()) {
                    serviceFiles.add(serviceFileEnumerator.nextElement());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load Extension configured in " + SERVICE_CONFIG, e);
            }
            return serviceFiles;
        }

        private void loadConfiguredServices(URL serviceFile) {
            try (InputStream inputStream = serviceFile.openStream();){
                String serviceClassName;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, FILE_ENCODING));
                while ((serviceClassName = bufferedReader.readLine()) != null) {
                    if ("".equals(serviceClassName = this.extractConfiguredServiceClassName(serviceClassName))) continue;
                    this.loadService(serviceClassName);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to process service-config: " + serviceFile, e);
            }
        }

        private String extractConfiguredServiceClassName(String currentConfigLine) {
            int startOfComment = currentConfigLine.indexOf(35);
            if (startOfComment > -1) {
                currentConfigLine = currentConfigLine.substring(0, startOfComment);
            }
            return currentConfigLine.trim();
        }

        private void loadService(String serviceClassName) {
            try {
                Class<?> serviceClass = this.loader.loadClass(serviceClassName);
                if (!this.foundServiceClasses.contains(serviceClass)) {
                    this.foundServiceClasses.add(serviceClass);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                log.error("Ignoring " + serviceClassName + " cause it can't be loaded.");
            }
        }

        public <T> List<T> load(Class<T> serviceType) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
            this.loader = classLoader;
            try {
                List<Extension> list = this.loadServiceImplementations();
                return list;
            }
            finally {
                this.loader = null;
                this.foundServiceClasses.clear();
            }
        }
    }
}

