/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.util.Iterator;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;

final class URLPatternSpec {
    private final String pattern;
    private final URLPattern first;
    private final LinkedList qualifiers = new LinkedList();

    public URLPatternSpec(String name) {
        if (name == null) {
            throw new IllegalArgumentException("URLPatternSpec cannot be null");
        }
        if (name.length() == 0) {
            name = "/";
        }
        this.pattern = name;
        String[] tokens = this.pattern.split(":", -1);
        this.first = new URLPattern(tokens[0]);
        for (int i = 1; i < tokens.length; ++i) {
            URLPattern candidate = new URLPattern(tokens[i]);
            if (candidate.matches(this.first)) {
                throw new IllegalArgumentException("Qualifier patterns in the URLPatternSpec cannot match the first URLPattern");
            }
            if (this.first.type == 1) {
                if (candidate.type == 0 && !this.first.matches(candidate)) {
                    throw new IllegalArgumentException("Exact qualifier patterns in the URLPatternSpec must be matched by the first URLPattern");
                }
                if (!(candidate.type != 1 || this.first.matches(candidate) && this.first.pattern.length() < candidate.pattern.length())) {
                    throw new IllegalArgumentException("path-prefix qualifier patterns in the URLPatternSpec must be matched by, but different from, the first URLPattern");
                }
                if (candidate.type == 2) {
                    throw new IllegalArgumentException("extension qualifier patterns in the URLPatternSpec are not allowed when the first URLPattern is path-prefix");
                }
            } else if (this.first.type == 2) {
                if (candidate.type == 0) {
                    if (!this.first.matches(candidate)) {
                        throw new IllegalArgumentException("Exact qualifier patterns in the URLPatternSpec must be matched when first URLPattern is an extension pattern");
                    }
                } else if (candidate.type != 1) {
                    throw new IllegalArgumentException("Only exact and path-prefix qualifiers in the URLPatternSpec are allowed when first URLPattern is an extension pattern");
                }
            } else if (this.first.type == 4) {
                if (candidate.type == 4) {
                    throw new IllegalArgumentException("Qualifier patterns must not be default when first URLPattern is a default pattern");
                }
            } else if (this.first.type == 0) {
                throw new IllegalArgumentException("Qualifier patterns must not be present when first URLPattern is an exact pattern");
            }
            this.qualifiers.add(candidate);
        }
    }

    public boolean equals(URLPatternSpec o) {
        return this.implies(o) && o.implies(this);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public String getPatternSpec() {
        return this.pattern;
    }

    public String toString() {
        return this.pattern;
    }

    public boolean implies(URLPatternSpec p) {
        if (!this.first.matches(p.first)) {
            return false;
        }
        Iterator iter1 = this.qualifiers.iterator();
        while (iter1.hasNext()) {
            if (!((URLPattern)iter1.next()).matches(p.first)) continue;
            return false;
        }
        if (p.first.matches(this.first)) {
            Iterator iter2 = p.qualifiers.iterator();
            while (iter2.hasNext()) {
                Iterator iter3 = this.qualifiers.iterator();
                URLPattern test = (URLPattern)iter2.next();
                boolean found = false;
                while (iter3.hasNext()) {
                    if (!test.matches((URLPattern)iter3.next())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    static String encodeColons(HttpServletRequest request) {
        String result = request.getServletPath() + (request.getPathInfo() == null ? "" : request.getPathInfo());
        if (result.indexOf(":") > -1) {
            result = result.replaceAll(":", "%3A");
        }
        return result;
    }

    private class URLPattern {
        public static final int EXACT = 0;
        public static final int PATH_PREFIX = 1;
        public static final int EXTENSION = 2;
        public static final int DEFAULT = 4;
        public int type;
        public String pattern;

        public URLPattern(String pat) {
            if (pat == null) {
                throw new IllegalArgumentException("URLPattern cannot be null");
            }
            if (pat.length() == 0) {
                throw new IllegalArgumentException("URLPattern cannot be empty");
            }
            this.type = pat.equals("/") || pat.equals("/*") ? 4 : (pat.charAt(0) == '/' && pat.endsWith("/*") ? 1 : (pat.charAt(0) == '*' ? 2 : 0));
            this.pattern = pat;
        }

        public boolean matches(URLPattern p) {
            String test = p.pattern;
            if (this.pattern.equals(test)) {
                return true;
            }
            switch (this.type) {
                case 1: {
                    int length = this.pattern.length() - 2;
                    if (length > test.length()) {
                        return false;
                    }
                    for (int i = 0; i < length; ++i) {
                        if (this.pattern.charAt(i) == test.charAt(i)) continue;
                        return false;
                    }
                    if (test.length() == length) {
                        return true;
                    }
                    return test.charAt(length) == '/';
                }
                case 2: {
                    return test.endsWith(this.pattern.substring(1));
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }
    }
}

