/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.reflect.Constructor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.spi.ClassGeneratorClassLoader;
import org.apache.cxf.common.util.ASMHelper;
import org.apache.cxf.common.util.OpcodesProxy;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.FactoryClassCreator;

public class FactoryClassGenerator
extends ClassGeneratorClassLoader
implements FactoryClassCreator {
    private final ASMHelper helper;

    FactoryClassGenerator(Bus bus) {
        super(bus);
        this.helper = bus.getExtension(ASMHelper.class);
    }

    @Override
    public Class<?> createFactory(Class<?> cls) {
        String newClassName = cls.getName() + "Factory";
        Class<?> factoryClass = this.findClass(newClassName, cls);
        if (factoryClass != null) {
            return factoryClass;
        }
        Constructor<?> contructor = ReflectionUtil.getDeclaredConstructors(cls)[0];
        OpcodesProxy opcodes = this.helper.getOpCodes();
        ASMHelper.ClassWriter cw = this.helper.createClassWriter();
        cw.visit(opcodes.V1_6, opcodes.ACC_PUBLIC + opcodes.ACC_SUPER, StringUtils.periodToSlashes(newClassName), null, "java/lang/Object", null);
        cw.visitSource(cls.getSimpleName() + "Factory.java", null);
        ASMHelper.MethodVisitor mv = cw.visitMethod(opcodes.ACC_PUBLIC, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(opcodes.ALOAD, 0);
        mv.visitMethodInsn(opcodes.INVOKESPECIAL, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(opcodes.RETURN);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(opcodes.ACC_PUBLIC, "create" + cls.getSimpleName(), "()L" + StringUtils.periodToSlashes(cls.getName()) + ";", null, null);
        mv.visitCode();
        String name = cls.getName().replace(".", "/");
        mv.visitTypeInsn(opcodes.NEW, name);
        mv.visitInsn(opcodes.DUP);
        StringBuilder paraString = new StringBuilder(32).append("(");
        for (Class<?> paraClass : contructor.getParameterTypes()) {
            mv.visitInsn(opcodes.ACONST_NULL);
            paraString.append("Ljava/lang/Object;");
        }
        paraString.append(")V");
        mv.visitMethodInsn(opcodes.INVOKESPECIAL, name, "<init>", paraString.toString(), false);
        mv.visitInsn(opcodes.ARETURN);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return this.loadClass(newClassName, cls, cw.toByteArray());
    }
}

