/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionSQL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.Crypto;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.LobData;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class FunctionCustom
extends FunctionSQL {
    private static final int FUNC_ACOS = 71;
    private static final int FUNC_ACTION_ID = 72;
    private static final int FUNC_ADD_MONTHS = 73;
    private static final int FUNC_ASCII = 74;
    private static final int FUNC_ASCIISTR = 75;
    private static final int FUNC_ASIN = 76;
    private static final int FUNC_ATAN = 77;
    private static final int FUNC_ATAN2 = 78;
    private static final int FUNC_BITAND = 79;
    private static final int FUNC_BITANDNOT = 80;
    private static final int FUNC_BITNOT = 81;
    private static final int FUNC_BITOR = 82;
    private static final int FUNC_BITXOR = 83;
    private static final int FUNC_CHAR = 84;
    private static final int FUNC_CONCAT = 85;
    private static final int FUNC_COS = 86;
    private static final int FUNC_COSH = 87;
    private static final int FUNC_COT = 88;
    private static final int FUNC_CRYPT_KEY = 89;
    private static final int FUNC_DATABASE = 90;
    private static final int FUNC_DATABASE_ISOLATION_LEVEL = 91;
    private static final int FUNC_DATABASE_NAME = 92;
    private static final int FUNC_DATABASE_TIMEZONE = 93;
    private static final int FUNC_DATABASE_VERSION = 94;
    private static final int FUNC_DATE_ADD = 95;
    private static final int FUNC_DATE_SUB = 96;
    private static final int FUNC_DATEADD = 97;
    private static final int FUNC_DATEDIFF = 98;
    private static final int FUNC_DAYS = 99;
    private static final int FUNC_DBTIMEZONE = 100;
    private static final int FUNC_DEGREES = 101;
    private static final int FUNC_DIAGNOSTICS = 102;
    private static final int FUNC_DIFFERENCE = 103;
    private static final int FUNC_FROM_BASE64 = 104;
    private static final int FUNC_FROM_TZ = 105;
    private static final int FUNC_HEX = 106;
    private static final int FUNC_HEXTORAW = 107;
    private static final int FUNC_IDENTITY = 108;
    private static final int FUNC_INSTR = 109;
    private static final int FUNC_ISAUTOCOMMIT = 110;
    private static final int FUNC_ISOLATION_LEVEL = 111;
    private static final int FUNC_ISREADONLYDATABASE = 112;
    private static final int FUNC_ISREADONLYDATABASEFILES = 113;
    private static final int FUNC_ISREADONLYSESSION = 114;
    private static final int FUNC_LAST_DAY = 115;
    private static final int FUNC_LEFT = 116;
    private static final int FUNC_LOAD_FILE = 117;
    private static final int FUNC_LOB_ID = 118;
    private static final int FUNC_LOCATE = 119;
    private static final int FUNC_LOG10 = 120;
    private static final int FUNC_LPAD = 121;
    private static final int FUNC_LTRIM = 122;
    private static final int FUNC_MONTHS_BETWEEN = 123;
    private static final int FUNC_NEW_TIME = 124;
    private static final int FUNC_NEXT_DAY = 125;
    private static final int FUNC_NUMTODSINTERVAL = 126;
    private static final int FUNC_NUMTOYMINTERVAL = 127;
    private static final int FUNC_PI = 128;
    private static final int FUNC_POSITION_ARRAY = 129;
    private static final int FUNC_RADIANS = 130;
    private static final int FUNC_RAND = 131;
    private static final int FUNC_RAWTOHEX = 132;
    private static final int FUNC_REGEXP_COUNT = 133;
    private static final int FUNC_REGEXP_INSTR = 134;
    private static final int FUNC_REGEXP_LIKE = 135;
    private static final int FUNC_REGEXP_MATCHES = 136;
    private static final int FUNC_REGEXP_REPLACE = 137;
    private static final int FUNC_REGEXP_SUBSTR = 138;
    private static final int FUNC_REGEXP_SUBSTRING = 139;
    private static final int FUNC_REGEXP_SUBSTRING_ARRAY = 140;
    private static final int FUNC_REPEAT = 141;
    private static final int FUNC_REPLACE = 142;
    private static final int FUNC_REVERSE = 143;
    private static final int FUNC_RIGHT = 144;
    private static final int FUNC_ROUND = 145;
    private static final int FUNC_ROUNDMAGIC = 146;
    private static final int FUNC_RPAD = 147;
    private static final int FUNC_RTRIM = 148;
    private static final int FUNC_SECONDS_MIDNIGHT = 149;
    private static final int FUNC_SEQUENCE_ARRAY = 150;
    private static final int FUNC_SESSION_ID = 151;
    private static final int FUNC_SESSION_ISOLATION_LEVEL = 152;
    private static final int FUNC_SESSION_TIMEZONE = 153;
    private static final int FUNC_SESSIONTIMEZONE = 154;
    private static final int FUNC_SIGN = 155;
    private static final int FUNC_SIN = 156;
    private static final int FUNC_SINH = 157;
    private static final int FUNC_SOUNDEX = 158;
    private static final int FUNC_SORT_ARRAY = 159;
    private static final int FUNC_SPACE = 160;
    private static final int FUNC_SUBSTR = 161;
    private static final int FUNC_SYS_EXTRACT_UTC = 162;
    private static final int FUNC_SYS_GUID = 163;
    private static final int FUNC_SYSDATE = 164;
    private static final int FUNC_SYSTIMESTAMP = 165;
    private static final int FUNC_TAN = 166;
    private static final int FUNC_TANH = 167;
    private static final int FUNC_TIMESTAMP = 168;
    private static final int FUNC_TIMESTAMP_WITH_ZONE = 169;
    private static final int FUNC_TIMESTAMPADD = 170;
    private static final int FUNC_TIMESTAMPDIFF = 171;
    private static final int FUNC_TIMEZONE = 172;
    private static final int FUNC_TO_BASE64 = 173;
    private static final int FUNC_TO_CHAR = 174;
    private static final int FUNC_TO_DATE = 175;
    private static final int FUNC_TO_DSINTERVAL = 176;
    private static final int FUNC_TO_YMINTERVAL = 177;
    private static final int FUNC_TO_NUMBER = 178;
    private static final int FUNC_TO_TIMESTAMP = 179;
    private static final int FUNC_TO_TIMESTAMP_TZ = 180;
    private static final int FUNC_TRANSACTION_CONTROL = 181;
    private static final int FUNC_TRANSACTION_ID = 182;
    private static final int FUNC_TRANSACTION_SIZE = 183;
    private static final int FUNC_TRANSACTION_UTC = 184;
    private static final int FUNC_TRANSLATE = 185;
    private static final int FUNC_TRUNC = 186;
    private static final int FUNC_TRUNCATE = 187;
    private static final int FUNC_UNHEX = 188;
    private static final int FUNC_UNISTR = 189;
    private static final int FUNC_UUID = 190;
    private static final int FUNC_UNIX_TIMESTAMP = 191;
    private static final int FUNC_UNIX_MILLIS = 192;
    private static final int FUNC_DATEPART = 193;
    private static final int FUNC_DATENAME = 194;
    private static final int FUNC_NANVL = 195;
    private static final int FUNC_SQLCODE = 196;
    private static final int FUNC_SQLERRM = 197;
    static final IntKeyIntValueHashMap customRegularFuncMap = new IntKeyIntValueHashMap();
    static final IntKeyIntValueHashMap customValueFuncMap;
    private int extractSpec;
    private Pattern pattern;
    private IntKeyIntValueHashMap charLookup;

    public static FunctionSQL newCustomFunction(Session session, String string, int n) {
        int n2 = customRegularFuncMap.get(n, -1);
        if (n2 == -1) {
            n2 = customValueFuncMap.get(n, -1);
        }
        if (n2 == -1) {
            return null;
        }
        switch (n) {
            case 468: 
            case 713: 
            case 763: 
            case 768: 
            case 784: 
            case 844: {
                return new FunctionSQL(n2);
            }
            case 724: 
            case 725: 
            case 781: 
            case 837: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = optionalNoParamList;
                return functionSQL;
            }
            case 818: {
                FunctionSQL functionSQL = new FunctionSQL(n2);
                functionSQL.parseList = tripleParamList;
                functionSQL.name = "SUBSTR";
                return functionSQL;
            }
            case 861: 
            case 862: 
            case 863: 
            case 864: {
                if (session.database.sqlSyntaxMss) break;
                return null;
            }
            case 743: 
            case 822: 
            case 866: {
                if (session.database.sqlSyntaxOra) break;
                return null;
            }
        }
        FunctionCustom functionCustom = new FunctionCustom(n2);
        if (n2 == 31) {
            switch (n) {
                case 771: {
                    functionCustom.extractSpec = 161;
                    break;
                }
                case 803: {
                    functionCustom.extractSpec = 302;
                    break;
                }
            }
        }
        if (n2 == 5) {
            switch (n) {
                case 738: {
                    functionCustom.extractSpec = 734;
                    break;
                }
                case 774: {
                    functionCustom.extractSpec = 773;
                    break;
                }
                case 739: {
                    functionCustom.extractSpec = 735;
                    break;
                }
                case 740: {
                    functionCustom.extractSpec = 736;
                    break;
                }
                case 741: {
                    functionCustom.extractSpec = 737;
                    break;
                }
                case 850: {
                    functionCustom.extractSpec = 851;
                    break;
                }
                default: {
                    functionCustom.extractSpec = n;
                }
            }
        }
        if (functionCustom.name == null) {
            functionCustom.name = string;
        }
        return functionCustom;
    }

    public static boolean isRegularFunction(int n) {
        return customRegularFuncMap.get(n, -1) != -1;
    }

    public static boolean isValueFunction(int n) {
        return customValueFuncMap.get(n, -1) != -1;
    }

    private FunctionCustom(int n) {
        this.funcType = n;
        this.isDeterministic = !nonDeterministicFuncSet.contains(n);
        switch (n) {
            case 196: 
            case 197: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 100: 
            case 154: 
            case 164: 
            case 165: {
                this.parseList = optionalNoParamList;
                break;
            }
            case 72: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 128: 
            case 151: 
            case 152: 
            case 153: 
            case 163: 
            case 172: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                this.parseList = emptyParamList;
                break;
            }
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 81: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 99: 
            case 101: 
            case 104: 
            case 106: 
            case 107: 
            case 115: 
            case 118: 
            case 120: 
            case 130: 
            case 132: 
            case 143: 
            case 146: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 162: 
            case 166: 
            case 167: 
            case 169: 
            case 173: 
            case 176: 
            case 177: 
            case 178: 
            case 188: 
            case 189: {
                this.parseList = singleParamList;
                break;
            }
            case 73: 
            case 78: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 89: 
            case 103: 
            case 105: 
            case 116: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 144: 
            case 195: {
                this.parseList = doubleParamList;
                break;
            }
            case 174: 
            case 175: 
            case 179: 
            case 180: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 117: 
            case 145: 
            case 168: 
            case 186: 
            case 187: {
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 98: {
                this.parseList = new short[]{937, 1005, 924, 939, 924, 939, 922};
                this.parseListAlt = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 97: {
                this.parseList = new short[]{937, 1005, 924, 939, 924, 939, 922};
                this.parseListAlt = tripleParamList;
                break;
            }
            case 193: 
            case 194: {
                this.parseList = new short[]{937, 1005, 924, 939, 922};
                break;
            }
            case 95: 
            case 96: {
                this.parseList = doubleParamList;
                break;
            }
            case 150: 
            case 185: {
                this.parseList = tripleParamList;
                break;
            }
            case 1: 
            case 121: 
            case 142: 
            case 147: {
                this.parseList = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 137: {
                this.parseList = new short[]{937, 939, 924, 939, 1002, 2, 924, 939, 1002, 2, 924, 939, 1002, 2, 924, 939, 1002, 2, 924, 939, 922};
                break;
            }
            case 190: 
            case 191: 
            case 192: {
                this.parseList = optionalSingleParamList;
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = singleParamList;
                break;
            }
            case 31: {
                this.name = "TRIM";
                this.parseList = optionalDoubleParamList;
                break;
            }
            case 32: {
                this.name = "OVERLAY";
                this.parseList = quadParamList;
                break;
            }
            case 108: {
                this.name = "IDENTITY";
                this.parseList = emptyParamList;
                break;
            }
            case 102: {
                this.parseList = new short[]{937, 537, 922};
                break;
            }
            case 129: {
                this.parseList = new short[]{937, 939, 140, 939, 1002, 2, 124, 939, 922};
                break;
            }
            case 159: {
                this.parseList = new short[]{937, 939, 1002, 4, 1001, 2, 360, 411, 1002, 5, 489, 1001, 2, 427, 467, 922};
                break;
            }
            case 170: {
                this.name = "TIMESTAMPADD";
                this.parseList = new short[]{937, 1001, 22, 981, 983, 982, 984, 985, 986, 987, 988, 989, 990, 991, 873, 871, 872, 264, 179, 137, 78, 850, 183, 787, 341, 924, 939, 924, 939, 922};
                break;
            }
            case 171: {
                this.name = "TIMESTAMPDIFF";
                this.parseList = new short[]{937, 1001, 22, 981, 983, 982, 984, 985, 986, 987, 988, 989, 990, 991, 873, 871, 872, 264, 179, 137, 78, 850, 183, 787, 341, 924, 939, 924, 939, 922};
                break;
            }
            case 131: {
                this.parseList = optionalSingleParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public void setArguments(Expression[] expressionArray) {
        switch (this.funcType) {
            case 1: {
                Expression[] expressionArray2 = new Expression[4];
                if ("LOCATE".equals(this.name)) {
                    expressionArray2[0] = expressionArray[0];
                    expressionArray2[1] = expressionArray[1];
                    expressionArray2[3] = expressionArray[2];
                    expressionArray = expressionArray2;
                    break;
                }
                if (!"INSTR".equals(this.name)) break;
                expressionArray2[0] = expressionArray[1];
                expressionArray2[1] = expressionArray[0];
                expressionArray2[3] = expressionArray[2];
                expressionArray = expressionArray2;
                break;
            }
            case 32: {
                Expression expression = expressionArray[1];
                Expression expression2 = expressionArray[2];
                expressionArray[1] = expressionArray[3];
                expressionArray[2] = expression;
                expressionArray[3] = expression2;
                break;
            }
            case 5: {
                Expression[] expressionArray3 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[0]};
                expressionArray = expressionArray3;
                break;
            }
            case 31: {
                Expression[] expressionArray4 = new Expression[]{new ExpressionValue(ValuePool.getInt(this.extractSpec), Type.SQL_INTEGER), expressionArray[1] == null ? new ExpressionValue(" ", Type.SQL_CHAR) : expressionArray[1], expressionArray[0]};
                expressionArray = expressionArray4;
            }
        }
        super.setArguments(expressionArray);
    }

    @Override
    public Expression getFunctionExpression() {
        switch (this.funcType) {
            case 85: {
                return new ExpressionArithmetic(36, this.nodes[0], this.nodes[1]);
            }
        }
        return super.getFunctionExpression();
    }

    @Override
    Object getValue(Session session, Object[] objectArray) {
        switch (this.funcType) {
            case 196: {
                return 0;
            }
            case 197: {
                return "Error";
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                return super.getValue(session, objectArray);
            }
            case 90: {
                return session.getDatabase().getPath();
            }
            case 92: {
                return session.getDatabase().getNameString();
            }
            case 110: {
                return session.isAutoCommit() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 114: {
                return session.isReadOnlyDefault() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 112: {
                return session.getDatabase().databaseReadOnly ? Boolean.TRUE : Boolean.FALSE;
            }
            case 113: {
                return session.getDatabase().isFilesReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 111: {
                return Session.getIsolationString(session.isolationLevel);
            }
            case 152: {
                return Session.getIsolationString(session.isolationLevelDefault);
            }
            case 91: {
                return Session.getIsolationString(session.database.defaultIsolationLevel);
            }
            case 181: {
                switch (session.database.txManager.getTransactionControl()) {
                    case 2: {
                        return "MVCC";
                    }
                    case 1: {
                        return "MVLOCKS";
                    }
                }
                return "LOCKS";
            }
            case 172: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 153: {
                return new IntervalSecondData(session.getZoneSeconds(), 0);
            }
            case 100: {
                TimestampData timestampData = DateTimeType.newSystemTimestampWithZone();
                IntervalSecondData intervalSecondData = new IntervalSecondData(timestampData.getZone(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 93: {
                int n = HsqlDateTime.getZoneSeconds();
                return new IntervalSecondData(n, 0);
            }
            case 94: {
                return "2.7.0";
            }
            case 151: {
                return session.getId();
            }
            case 72: {
                return session.actionSCN;
            }
            case 182: {
                return session.transactionSCN;
            }
            case 183: {
                return (long)session.getTransactionSize();
            }
            case 184: {
                return session.getTransactionUTC();
            }
            case 118: {
                LobData lobData = (LobData)objectArray[0];
                if (lobData == null) {
                    return null;
                }
                return lobData.getId();
            }
            case 108: {
                Number number = session.getLastIdentity();
                if (number instanceof Long) {
                    return number;
                }
                return ValuePool.getLong(number.longValue());
            }
            case 102: {
                return session.sessionContext.diagnosticsVariables[this.exprSubType];
            }
            case 150: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                HsqlArrayList<Object> hsqlArrayList = new HsqlArrayList<Object>();
                Object object = objectArray[0];
                Type type = this.nodes[0].getDataType();
                boolean bl = type.compare(session, objectArray[1], objectArray[0]) >= 0;
                while (true) {
                    int n = type.compare(session, object, objectArray[1]);
                    if (bl ? n > 0 : n < 0) break;
                    hsqlArrayList.add(object);
                    Object object2 = type.add(session, object, objectArray[2], this.nodes[2].getDataType());
                    n = type.compare(session, object, object2);
                    if (bl ? n >= 0 : n <= 0) break;
                    object = object2;
                }
                Object[] objectArray2 = hsqlArrayList.toArray();
                return objectArray2;
            }
            case 170: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                int n = ((Number)this.nodes[0].valueData).intValue();
                long l = ((Number)objectArray[1]).longValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                switch (n) {
                    case 873: 
                    case 981: {
                        long l2 = l / 1000000000L;
                        int n2 = (int)(l % 1000000000L);
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l2, n2, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 871: 
                    case 983: {
                        long l3 = l / 1000000L;
                        int n3 = (int)(l % 1000000L) * 1000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l3, n3, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 872: 
                    case 982: {
                        long l4 = l / 1000L;
                        int n4 = (int)(l % 1000L) * 1000000;
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = new IntervalSecondData(l4, n4, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 264: 
                    case 984: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalSeconds(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 179: 
                    case 985: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalMinute(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 137: 
                    case 986: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalHour(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 78: 
                    case 736: 
                    case 737: 
                    case 987: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 850: 
                    case 988: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = IntervalSecondData.newIntervalDay(l * 7L, intervalType);
                        return this.dataType.add(session, timestampData, intervalSecondData, intervalType);
                    }
                    case 183: 
                    case 989: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 787: 
                    case 990: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 3L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                    case 341: 
                    case 991: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        IntervalMonthData intervalMonthData = IntervalMonthData.newIntervalMonth(l * 12L, intervalType);
                        return this.dataType.add(session, timestampData, intervalMonthData, intervalType);
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 171: {
                if (objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                int n = ((Number)this.nodes[0].valueData).intValue();
                TimestampData timestampData = (TimestampData)objectArray[2];
                TimestampData timestampData2 = (TimestampData)objectArray[1];
                switch (n) {
                    case 873: 
                    case 981: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_FRACTION_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000000000L * intervalSecondData.getSeconds() + (long)intervalSecondData.getNanos();
                    }
                    case 871: 
                    case 983: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000);
                    }
                    case 872: 
                    case 982: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        IntervalSecondData intervalSecondData = (IntervalSecondData)intervalType.subtract(session, timestampData, timestampData2, null);
                        return 1000L * intervalSecondData.getSeconds() + (long)(intervalSecondData.getNanos() / 1000000);
                    }
                    case 264: 
                    case 984: {
                        IntervalType intervalType = Type.SQL_INTERVAL_SECOND_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 179: 
                    case 985: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MINUTE_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 137: 
                    case 986: {
                        IntervalType intervalType = Type.SQL_INTERVAL_HOUR_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 78: 
                    case 987: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 850: 
                    case 988: {
                        IntervalType intervalType = Type.SQL_INTERVAL_DAY_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 6L) / 7L : (l + 6L) / 7L;
                        return l;
                    }
                    case 183: 
                    case 989: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                    case 787: 
                    case 990: {
                        IntervalType intervalType = Type.SQL_INTERVAL_MONTH_MAX_PRECISION;
                        long l = intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                        l = l < 0L ? (l - 2L) / 3L : (l + 2L) / 3L;
                        return l;
                    }
                    case 341: 
                    case 991: {
                        IntervalType intervalType = Type.SQL_INTERVAL_YEAR_MAX_PRECISION;
                        return intervalType.convertToLongEndUnits(intervalType.subtract(session, timestampData, timestampData2, null));
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 194: {
                Object object = this.getExtractValue(session, objectArray);
                return this.dataType.convertToDefaultType(session, object);
            }
            case 95: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.add(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 96: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return this.dataType.subtract(session, objectArray[0], objectArray[1], this.nodes[1].dataType);
            }
            case 99: {
                if (objectArray[0] == null) {
                    return null;
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_DAY_MAX_PRECISION.subtract(session, objectArray[0], DateTimeType.epochTimestamp, Type.SQL_DATE);
                return ValuePool.getInt((int)(intervalSecondData.getSeconds() / 86400L + 1L));
            }
            case 128: {
                return Math.PI;
            }
            case 131: {
                if (this.nodes[0] == null) {
                    return session.random();
                }
                objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                long l = ((Number)objectArray[0]).longValue();
                return session.random(l);
            }
            case 145: 
            case 186: {
                int n = 103;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.dataType.isDateTimeType()) {
                    DateTimeType dateTimeType = (DateTimeType)this.dataType;
                    if (this.nodes.length > 1 && this.nodes[1] != null) {
                        if (objectArray[1] == null) {
                            return null;
                        }
                        n = HsqlDateTime.toStandardIntervalPart((String)objectArray[1]);
                    }
                    if (n < 0) {
                        throw Error.error(5566, (String)objectArray[1]);
                    }
                    return this.funcType == 145 ? dateTimeType.round(session, objectArray[0], n) : dateTimeType.truncate(session, objectArray[0], n);
                }
            }
            case 187: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                    n = ((Number)objectArray[1]).intValue();
                }
                return this.funcType == 145 ? ((NumberType)this.dataType).round(objectArray[0], n) : ((NumberType)this.dataType).truncate(objectArray[0], n);
            }
            case 104: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                string = string.trim();
                byte[] byArray = Base64.getDecoder().decode(string);
                return new BinaryData(byArray, false);
            }
            case 173: {
                BinaryData binaryData = (BinaryData)objectArray[0];
                if (binaryData == null) {
                    return null;
                }
                return Base64.getEncoder().encodeToString(binaryData.getBytes());
            }
            case 174: {
                if (this.nodes[1] == null) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                Date date = (Date)((DateTimeType)this.nodes[0].dataType).convertSQLToJavaGMT(session, objectArray[0]);
                return HsqlDateTime.toFormattedDate(date, (String)objectArray[1], simpleDateFormat);
            }
            case 178: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 175: 
            case 179: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isDateOrTimestampType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                boolean bl = this.funcType == 179;
                SimpleDateFormat simpleDateFormat = session.getSimpleDateFormatGMT();
                TimestampData timestampData = HsqlDateTime.toDate((String)objectArray[0], (String)objectArray[1], simpleDateFormat, bl);
                return timestampData;
            }
            case 168: {
                boolean bl;
                boolean bl2 = bl = this.nodes[1] == null;
                if (objectArray[0] == null) {
                    return null;
                }
                if (bl) {
                    if (this.nodes[0].dataType.isNumberType()) {
                        Calendar calendar = session.getCalendar();
                        long l = ((Number)objectArray[0]).longValue();
                        calendar.setTimeInMillis(l * 1000L);
                        int n = HsqlDateTime.getZoneSeconds(calendar);
                        return new TimestampData(l + (long)n);
                    }
                    try {
                        return Type.SQL_TIMESTAMP.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                    catch (HsqlException hsqlException) {
                        return Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                    }
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)Type.SQL_DATE.convertToType(session, objectArray[0], this.nodes[0].dataType);
                TimeData timeData = (TimeData)Type.SQL_TIME_MAX.convertToType(session, objectArray[1], this.nodes[1].dataType);
                return new TimestampData(timestampData.getSeconds() + (long)timeData.getSeconds(), timeData.getNanos());
            }
            case 169: {
                long l;
                Calendar calendar = session.getCalendar();
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    l = ((Number)objectArray[0]).longValue();
                } else if (this.nodes[0].dataType.typeCode == 93) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                    l = HsqlDateTime.convertMillisToCalendar(calendar, l * 1000L) / 1000L;
                } else if (this.nodes[0].dataType.typeCode == 95) {
                    l = ((TimestampData)objectArray[0]).getSeconds();
                } else {
                    throw Error.error(5566, (String)objectArray[1]);
                }
                calendar.setTimeInMillis(l * 1000L);
                int n5 = HsqlDateTime.getZoneSeconds(calendar);
                return new TimestampData(l, n, n5);
            }
            case 163: {
                UUID uUID = UUID.randomUUID();
                long l = uUID.getMostSignificantBits();
                long l5 = uUID.getLeastSignificantBits();
                return new BinaryData(ArrayUtil.toByteArray(l, l5), false);
            }
            case 190: {
                if (this.nodes[0] == null) {
                    UUID uUID = UUID.randomUUID();
                    long l = uUID.getMostSignificantBits();
                    long l6 = uUID.getLeastSignificantBits();
                    return new BinaryData(ArrayUtil.toByteArray(l, l6), false);
                }
                if (objectArray[0] == null) {
                    return null;
                }
                try {
                    if (this.dataType.isBinaryType()) {
                        byte[] byArray = StringConverter.toBinaryUUID((String)objectArray[0]);
                        return new BinaryData(byArray, false);
                    }
                    return StringConverter.toStringUUID(((BinaryData)objectArray[0]).getBytes());
                }
                catch (NumberFormatException numberFormatException) {
                    throw Error.error(3459, numberFormatException);
                }
            }
            case 192: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp();
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                long l = timestampData.getSeconds() * 1000L + (long)(timestampData.getNanos() / 1000000);
                return l;
            }
            case 191: {
                TimestampData timestampData;
                if (this.nodes[0] == null) {
                    timestampData = session.getCurrentTimestamp();
                } else {
                    if (objectArray[0] == null) {
                        return null;
                    }
                    timestampData = (TimestampData)objectArray[0];
                }
                return timestampData.getSeconds();
            }
            case 71: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.acos(d);
            }
            case 76: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.asin(d);
            }
            case 77: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.atan(d);
            }
            case 86: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.cos(d);
            }
            case 87: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.cosh(d);
            }
            case 88: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d2 = 1.0 / Math.tan(d);
                return d2;
            }
            case 101: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.toDegrees(d);
            }
            case 156: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.sin(d);
            }
            case 157: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.sinh(d);
            }
            case 166: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.tan(d);
            }
            case 167: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.tanh(d);
            }
            case 120: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (d < 0.0 && session.database.sqlDoubleNaN) {
                    throw Error.error(3444);
                }
                return Math.log10(d);
            }
            case 130: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                return Math.toRadians(d);
            }
            case 155: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (session.database.sqlSyntaxOra && objectArray[0] instanceof Double && (Double)objectArray[0] == 0.0) {
                    return 1;
                }
                int n = ((NumberType)this.nodes[0].dataType).compareToZero(objectArray[0]);
                return n;
            }
            case 78: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                double d3 = NumberType.toDouble(objectArray[1]);
                return Math.atan2(d, d3);
            }
            case 74: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                if (string.isEmpty()) {
                    return null;
                }
                return ValuePool.getInt(string.charAt(0));
            }
            case 75: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.isLobType() ? ((ClobData)objectArray[0]).getSubString(session, 0L, 1) : (String)objectArray[0];
                return StringConverter.stringToUnicodeEscaped(string);
            }
            case 84: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                if (Character.isValidCodePoint(n) && Character.isValidCodePoint((char)n)) {
                    return String.valueOf((char)n);
                }
                throw Error.error(3472);
            }
            case 146: {
                int n = 0;
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes.length > 1) {
                    if (objectArray[1] == null) {
                        return null;
                    }
                    n = ((Number)objectArray[1]).intValue();
                }
                return ((NumberType)this.dataType).round(objectArray[0], n);
            }
            case 158: {
                if (objectArray[0] == null) {
                    return null;
                }
                String string = (String)objectArray[0];
                return new String(FunctionCustom.soundex(string), 0, 4);
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                byte[] byArray;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                if (this.dataType.isNumberType()) {
                    long l = 0L;
                    long l7 = 0L;
                    objectArray[0] = Type.SQL_BIGINT.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                    long l8 = ((Number)objectArray[0]).longValue();
                    if (this.funcType != 81) {
                        objectArray[1] = Type.SQL_BIGINT.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                        l7 = ((Number)objectArray[1]).longValue();
                    }
                    switch (this.funcType) {
                        case 79: {
                            l = l8 & l7;
                            break;
                        }
                        case 80: {
                            l = l8 & (l7 ^ 0xFFFFFFFFFFFFFFFFL);
                            break;
                        }
                        case 81: {
                            l = l8 ^ 0xFFFFFFFFFFFFFFFFL;
                            break;
                        }
                        case 82: {
                            l = l8 | l7;
                            break;
                        }
                        case 83: {
                            l = l8 ^ l7;
                            break;
                        }
                    }
                    switch (this.dataType.typeCode) {
                        case 2: 
                        case 3: {
                            return BigDecimal.valueOf(l);
                        }
                        case 25: {
                            return ValuePool.getLong(l);
                        }
                        case -6: 
                        case 4: 
                        case 5: {
                            return ValuePool.getInt((int)l);
                        }
                    }
                    throw Error.error(5561);
                }
                byte[] byArray2 = ((BinaryData)objectArray[0]).getBytes();
                byte[] byArray3 = null;
                if (this.funcType != 81) {
                    byArray3 = ((BinaryData)objectArray[1]).getBytes();
                }
                switch (this.funcType) {
                    case 79: {
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 80: {
                        byArray3 = BitMap.not(byArray3);
                        byArray = BitMap.and(byArray2, byArray3);
                        break;
                    }
                    case 81: {
                        byArray = BitMap.not(byArray2);
                        break;
                    }
                    case 82: {
                        byArray = BitMap.or(byArray2, byArray3);
                        break;
                    }
                    case 83: {
                        byArray = BitMap.xor(byArray2, byArray3);
                        break;
                    }
                    default: {
                        throw Error.error(5561);
                    }
                }
                return new BinaryData(byArray, this.dataType.precision);
            }
            case 103: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                char[] cArray = FunctionCustom.soundex((String)objectArray[0]);
                char[] cArray2 = FunctionCustom.soundex((String)objectArray[1]);
                int n = 0;
                if (cArray[0] == cArray2[0]) {
                    ++n;
                }
                int n6 = 1;
                block179: for (int i = 1; i < 4; ++i) {
                    for (int j = n6; j < 4; ++j) {
                        if (cArray[j] != cArray2[i]) continue;
                        ++n;
                        n6 = j + 1;
                        continue block179;
                    }
                }
                return ValuePool.getInt(n);
            }
            case 106: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (this.nodes[0].dataType.isBinaryType()) {
                    return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    long l = ((Number)objectArray[0]).longValue();
                    return Long.toHexString(l);
                }
                String string = (String)objectArray[0];
                byte[] byArray = string.getBytes(JavaSystem.CS_ISO_8859_1);
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 189: {
                if (objectArray[0] == null) {
                    return null;
                }
                try {
                    return StringConverter.unicodeEscapedToString((String)objectArray[0]);
                }
                catch (Throwable throwable) {
                    throw Error.error(throwable, 5586, null);
                }
            }
            case 107: 
            case 188: {
                if (objectArray[0] == null) {
                    return null;
                }
                return this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
            }
            case 132: {
                if (objectArray[0] == null) {
                    return null;
                }
                BlobData blobData = (BlobData)objectArray[0];
                byte[] byArray = blobData.getBytes(session, 0L, (int)blobData.length(session));
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 141: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                objectArray[1] = Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].getDataType());
                String string = (String)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                StringBuilder stringBuilder = new StringBuilder(string.length() * n);
                while (n-- > 0) {
                    stringBuilder.append(string);
                }
                return stringBuilder.toString();
            }
            case 142: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                String string = (String)objectArray[0];
                String string2 = (String)objectArray[1];
                String string3 = (String)objectArray[2];
                StringBuilder stringBuilder = new StringBuilder();
                int n = 0;
                if (string2.isEmpty()) {
                    return string;
                }
                while (true) {
                    int n7;
                    if ((n7 = string.indexOf(string2, n)) == -1) break;
                    stringBuilder.append(string, n, n7);
                    stringBuilder.append(string3);
                    n = n7 + string2.length();
                }
                stringBuilder.append(string.substring(n));
                return stringBuilder.toString();
            }
            case 116: 
            case 144: {
                int n;
                for (n = 0; n < objectArray.length; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = 0;
                int n8 = ((Number)objectArray[1]).intValue();
                boolean bl = true;
                boolean bl3 = false;
                if (this.funcType == 144) {
                    n = n8;
                    n8 = 0;
                    bl = false;
                    bl3 = true;
                }
                return ((CharacterType)this.dataType).substring(session, objectArray[0], n, n8, bl, bl3);
            }
            case 160: {
                if (objectArray[0] == null) {
                    return null;
                }
                objectArray[0] = Type.SQL_INTEGER.convertToType(session, objectArray[0], this.nodes[0].getDataType());
                int n = ((Number)objectArray[0]).intValue();
                char[] cArray = new char[n];
                ArrayUtil.fillArray(cArray, 0, ' ');
                return String.valueOf(cArray);
            }
            case 143: {
                if (objectArray[0] == null) {
                    return null;
                }
                StringBuilder stringBuilder = new StringBuilder((String)objectArray[0]);
                stringBuilder = stringBuilder.reverse();
                return stringBuilder.toString();
            }
            case 137: {
                String string;
                int n;
                for (n = 0; n < this.nodes.length && this.nodes[n] != null; ++n) {
                    if (objectArray[n] != null) continue;
                    return null;
                }
                n = FunctionCustom.regexpParams((String)objectArray[5]);
                String string4 = (String)objectArray[0];
                String string5 = (String)objectArray[1];
                String string6 = (String)objectArray[2];
                int n9 = 1;
                int n10 = 0;
                if (this.nodes[2] == null) {
                    string6 = "";
                }
                if (this.nodes[3] != null && ((n9 = ((Number)objectArray[3]).intValue()) < 1 || n9 >= string4.length())) {
                    throw Error.error(3403);
                }
                if (this.nodes[4] != null && (n10 = ((Number)objectArray[4]).intValue()) < 0) {
                    throw Error.error(3403);
                }
                Pattern pattern = this.pattern;
                if (pattern == null) {
                    pattern = Pattern.compile(string5, n);
                }
                Matcher matcher = pattern.matcher(string4);
                if (n9 > 1) {
                    matcher.region(n9 - 1, string4.length());
                }
                if (n10 == 0) {
                    string = matcher.replaceAll(string6);
                } else if (n10 == 1) {
                    string = matcher.replaceFirst(string6);
                } else {
                    throw Error.error(3472, "count");
                }
                return string;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 139: 
            case 140: {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    return null;
                }
                Pattern pattern = this.pattern;
                String string = (String)objectArray[0];
                String string7 = (String)objectArray[1];
                if (pattern == null) {
                    pattern = Pattern.compile(string7);
                }
                Matcher matcher = pattern.matcher(string);
                switch (this.funcType) {
                    case 135: 
                    case 136: {
                        boolean bl = matcher.matches();
                        return bl;
                    }
                    case 134: {
                        boolean bl = matcher.find();
                        if (bl) {
                            return matcher.start() + 1;
                        }
                        return ValuePool.INTEGER_0;
                    }
                    case 138: 
                    case 139: {
                        boolean bl = matcher.find();
                        if (bl) {
                            return matcher.group();
                        }
                        return null;
                    }
                    case 133: {
                        int n = 0;
                        while (matcher.find()) {
                            ++n;
                        }
                        return n;
                    }
                    case 140: {
                        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
                        while (matcher.find()) {
                            hsqlArrayList.add(matcher.group());
                        }
                        return hsqlArrayList.toArray();
                    }
                }
                throw Error.runtimeError(201, "FunctionCustom");
            }
            case 89: {
                byte[] byArray = Crypto.getNewKey((String)objectArray[0], (String)objectArray[1]);
                return StringConverter.byteArrayToHexString(byArray);
            }
            case 117: {
                String string = (String)objectArray[0];
                if (string == null) {
                    return null;
                }
                switch (this.dataType.typeCode) {
                    case 40: {
                        return session.sessionData.createClobFromFile(string, (String)objectArray[1]);
                    }
                }
                return session.sessionData.createBlobFromFile(string);
            }
            case 121: 
            case 147: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                String string = this.nodes[0].dataType.typeCode == 40 ? (String)Type.SQL_VARCHAR.convertToType(session, objectArray[0], this.nodes[0].dataType) : (this.nodes[0].dataType.isCharacterType() ? (String)objectArray[0] : this.nodes[0].dataType.convertToString(objectArray[0]));
                int n = (Integer)Type.SQL_INTEGER.convertToType(session, objectArray[1], this.nodes[1].dataType);
                String string8 = " ";
                if (this.nodes[2] != null && (string8 = this.nodes[2].dataType.convertToString(objectArray[2])).isEmpty()) {
                    string8 = " ";
                }
                string = (String)Type.SQL_VARCHAR.trim(session, string, ' ', true, true);
                string = StringUtil.toPaddedString(string, n, string8, this.funcType == 147);
                if (this.dataType.isLobType()) {
                    return this.dataType.convertToType(session, string, Type.SQL_VARCHAR);
                }
                return string;
            }
            case 129: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                Object[] objectArray3 = (Object[])objectArray[1];
                ArrayType arrayType = (ArrayType)this.nodes[1].dataType;
                Type type = arrayType.collectionBaseType();
                int n = 1;
                if (this.nodes[2] != null) {
                    if (objectArray[2] == null) {
                        return null;
                    }
                    n = ((Number)Type.SQL_INTEGER.convertToType(session, objectArray[2], this.nodes[2].dataType)).intValue();
                }
                if (n < 1) {
                    throw Error.error(3403);
                }
                for (int i = --n; i < objectArray3.length; ++i) {
                    if (type.compare(session, objectArray[0], objectArray3[i]) != 0) continue;
                    return ValuePool.getInt(i + 1);
                }
                return ValuePool.INTEGER_0;
            }
            case 159: {
                if (objectArray[0] == null) {
                    return null;
                }
                ArrayType arrayType = (ArrayType)this.dataType;
                SortAndSlice sortAndSlice = new SortAndSlice();
                sortAndSlice.prepareSingleColumn(1);
                sortAndSlice.sortDescending[0] = ((Number)objectArray[1]).intValue() == 411;
                sortAndSlice.sortNullsLast[0] = ((Number)objectArray[2]).intValue() == 467;
                Object[] objectArray4 = (Object[])ArrayUtil.duplicateArray(objectArray[0]);
                arrayType.sort(session, objectArray4, sortAndSlice);
                return objectArray4;
            }
            case 73: {
                if (objectArray[0] == null) {
                    return null;
                }
                if (objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                int n = ((Number)objectArray[1]).intValue();
                return Type.SQL_TIMESTAMP_NO_FRACTION.addMonthsSpecial(session, timestampData, n);
            }
            case 105: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)objectArray[0];
                if (DateTimeType.zoneIDs.contains(objectArray[1])) {
                    return ((DateTimeType)this.dataType).changeZone(session, timestampData, (String)objectArray[1]);
                }
                IntervalSecondData intervalSecondData = (IntervalSecondData)Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToDefaultType(session, objectArray[1]);
                return new TimestampData(timestampData.getSeconds() + (long)timestampData.getZone() - intervalSecondData.getSeconds(), timestampData.getNanos(), (int)intervalSecondData.getSeconds());
            }
            case 115: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_NO_FRACTION.getLastDayOfMonth(session, objectArray[0]);
            }
            case 123: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                return DateTimeType.subtractMonthsSpecial(session, (TimestampData)objectArray[0], (TimestampData)objectArray[1]);
            }
            case 195: {
                if (objectArray[0] == null) {
                    return null;
                }
                double d = NumberType.toDouble(objectArray[0]);
                if (Double.isNaN(d)) {
                    return this.dataType.convertToType(session, objectArray[1], this.nodes[1].dataType);
                }
                return objectArray[0];
            }
            case 125: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                TimestampData timestampData = (TimestampData)this.dataType.convertToType(session, objectArray[0], this.nodes[0].dataType);
                int n = DateTimeType.getDayOfWeek((String)objectArray[1]);
                return DateTimeType.nextDayOfWeek(session, timestampData, n);
            }
            case 126: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n11 = IntervalType.getFieldNameTypeForToken(n);
                switch (n11) {
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalSecondData.newInterval(d, n11);
            }
            case 127: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
                Object object = Type.SQL_VARCHAR.trim(session, objectArray[1], ' ', true, true);
                object = Type.SQL_VARCHAR.upper(session, object);
                object = Type.SQL_VARCHAR.convertToDefaultType(session, object);
                int n = Tokens.get((String)object);
                int n12 = IntervalType.getFieldNameTypeForToken(n);
                switch (n12) {
                    case 101: 
                    case 102: {
                        break;
                    }
                    default: {
                        throw Error.error(5566);
                    }
                }
                double d = ((Number)objectArray[0]).doubleValue();
                return IntervalMonthData.newInterval(d, n12);
            }
            case 154: {
                IntervalSecondData intervalSecondData = new IntervalSecondData(session.getZoneSeconds(), 0);
                return Type.SQL_INTERVAL_HOUR_TO_MINUTE.convertToString(intervalSecondData);
            }
            case 162: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.changeZone(session, objectArray[0], Type.SQL_TIMESTAMP_WITH_TIME_ZONE, 0, false);
            }
            case 164: {
                TimestampData timestampData = DateTimeType.newSysDateTimestamp();
                return Type.SQL_TIMESTAMP_NO_FRACTION.convertToType(session, timestampData, Type.SQL_TIMESTAMP);
            }
            case 165: {
                return DateTimeType.newSystemTimestampWithZone();
            }
            case 176: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 177: {
                if (objectArray[0] == null) {
                    return null;
                }
                return Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION.convertToType(session, objectArray[0], Type.SQL_VARCHAR);
            }
            case 180: {
                if (objectArray[0] == null || objectArray[1] == null) {
                    return null;
                }
            }
            case 185: {
                if (objectArray[0] == null || objectArray[1] == null || objectArray[2] == null) {
                    return null;
                }
                IntKeyIntValueHashMap intKeyIntValueHashMap = this.charLookup;
                if (intKeyIntValueHashMap == null) {
                    intKeyIntValueHashMap = FunctionCustom.getTranslationMap((String)objectArray[1], (String)objectArray[2]);
                }
                return FunctionCustom.translateWithMap((String)objectArray[0], intKeyIntValueHashMap);
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        block0 : switch (this.funcType) {
            case 196: {
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 197: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 1: 
            case 5: 
            case 31: 
            case 32: {
                super.resolveTypes(session, expression);
                return;
            }
            case 90: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 92: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 110: 
            case 112: 
            case 113: 
            case 114: {
                this.dataType = Type.SQL_BOOLEAN;
                return;
            }
            case 91: 
            case 94: 
            case 111: 
            case 152: 
            case 181: {
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 93: 
            case 153: 
            case 172: {
                this.dataType = Type.SQL_INTERVAL_HOUR_TO_MINUTE;
                return;
            }
            case 72: 
            case 108: 
            case 118: 
            case 151: 
            case 182: 
            case 183: {
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 102: {
                this.exprSubType = 2;
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 150: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = this.nodes[0].dataType;
                    }
                } else if (this.nodes[0].dataType.isDateTimeType()) {
                    if (this.nodes[0].dataType.typeCode != this.nodes[1].dataType.typeCode) {
                        throw Error.error(5562);
                    }
                    if (this.nodes[2].dataType == null) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[2].dataType.isIntervalType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = new ArrayType(this.nodes[0].getDataType(), Integer.MAX_VALUE);
                return;
            }
            case 97: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5575);
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.nodes[0].valueData = ValuePool.getInt(n);
                this.nodes[0].dataType = Type.SQL_INTEGER;
                this.funcType = 170;
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[2].dataType;
                return;
            }
            case 170: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_BIGINT;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2].dataType.typeCode == 91) {
                    // empty if block
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.typeCode == 91) {
                    n = ((Number)this.nodes[0].valueData).intValue();
                    switch (n) {
                        case 137: 
                        case 179: 
                        case 264: 
                        case 871: 
                        case 872: 
                        case 873: 
                        case 981: 
                        case 982: 
                        case 984: 
                        case 985: 
                        case 986: {
                            this.dataType = Type.SQL_TIMESTAMP;
                        }
                    }
                }
                return;
            }
            case 98: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = this.nodes[0];
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(987), Type.SQL_INTEGER);
                } else {
                    if (!this.nodes[0].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                    this.nodes[0].valueData = ValuePool.getInt(n);
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                this.funcType = 171;
            }
            case 171: {
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[2].dataType;
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP;
                    this.nodes[2].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType.isCharacterType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                }
                if (this.nodes[2].dataType.isCharacterType()) {
                    this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                }
                block80 : switch (this.nodes[1].dataType.typeCode) {
                    case 91: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) {
                            this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        }
                        switch ((Integer)this.nodes[0].valueData) {
                            case 987: 
                            case 988: 
                            case 989: 
                            case 990: 
                            case 991: {
                                break block80;
                            }
                        }
                        throw Error.error(5563);
                    }
                    case 93: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (!this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    case 95: {
                        if (!this.nodes[2].dataType.isDateOrTimestampType()) {
                            throw Error.error(5563);
                        }
                        if (this.nodes[2].dataType.isDateTimeTypeWithZone()) break;
                        this.nodes[2] = new ExpressionOp(this.nodes[2], Type.SQL_TIMESTAMP_WITH_TIME_ZONE_MAX);
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                return;
            }
            case 193: {
                if (this.extractSpec != 0) {
                    return;
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.funcType = 5;
                super.resolveTypes(session, expression);
                return;
            }
            case 194: {
                if (this.extractSpec != 0) {
                    return;
                }
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType()) {
                    throw Error.error(5563);
                }
                n = FunctionCustom.getTSIToken((String)this.nodes[0].valueData);
                this.extractSpec = FunctionCustom.getExtractTokenForTSIPart(n);
                if (this.extractSpec == 736) {
                    this.extractSpec = 734;
                } else if (this.extractSpec == 183) {
                    this.extractSpec = 773;
                }
                this.nodes[0] = new ExpressionValue((Object)this.extractSpec, Type.SQL_INTEGER);
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                return;
            }
            case 95: 
            case 96: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP);
                }
                if (this.nodes[1].dataType.isIntegralType()) {
                    this.nodes[1] = new ExpressionOp(this.nodes[1], Type.SQL_INTERVAL_DAY);
                }
                this.nodes[0].resolveTypes(session, this);
                this.nodes[1].resolveTypes(session, this);
                this.dataType = this.nodes[0].dataType;
                return;
            }
            case 99: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DATE;
                }
                switch (this.nodes[0].dataType.typeCode) {
                    case 91: 
                    case 93: 
                    case 95: {
                        break;
                    }
                    default: {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                return;
            }
            case 145: 
            case 186: {
                int n2;
                int n3 = n = this.nodes.length == 1 || this.nodes[1] == null ? 1 : 0;
                if (this.nodes[0].dataType == null) {
                    if (n != 0) {
                        if (expression instanceof ExpressionLogical || expression instanceof ExpressionArithmetic) {
                            for (n2 = 0; n2 < expression.nodes.length; ++n2) {
                                if (expression.nodes[n2].dataType == null) continue;
                                this.nodes[0].dataType = expression.nodes[n2].dataType;
                                break;
                            }
                        }
                        if (this.nodes[0].dataType == null) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                        if (this.nodes[0].dataType.isNumberType()) {
                            this.nodes[0].dataType = Type.SQL_DECIMAL;
                        }
                    } else {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[1].dataType = Type.SQL_INTEGER;
                        }
                        this.nodes[0].dataType = this.nodes[1].dataType.isNumberType() ? Type.SQL_DECIMAL : Type.SQL_TIMESTAMP;
                    }
                }
                if (this.nodes[0].dataType.isDateTimeType()) {
                    if (n == 0 && !this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5566);
                    }
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
            }
            case 187: {
                int n2;
                Number number = null;
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
                    number = ValuePool.INTEGER_0;
                } else {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_INTEGER;
                    } else if (!this.nodes[1].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                    if (this.nodes[1].opType == 1) {
                        number = (Number)this.nodes[1].getValue(session);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (number != null) {
                    n2 = number;
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > this.dataType.scale) {
                        n2 = this.dataType.scale;
                    }
                    if ((this.dataType.typeCode == 3 || this.dataType.typeCode == 2) && n2 != this.dataType.scale) {
                        this.dataType = new NumberType(this.dataType.typeCode, this.dataType.precision - (long)this.dataType.scale + (long)n2, n2);
                    }
                }
                return;
            }
            case 174: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1] != null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[1].dataType.isCharacterType()) {
                        throw Error.error(5563);
                    }
                    if (!this.nodes[0].dataType.isDateTimeType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = CharacterType.getCharacterType(12, 64L);
                return;
            }
            case 178: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                return;
            }
            case 175: 
            case 179: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = "DD-MON-YYYY HH24:MI:SS";
                    if (this.funcType == 179) {
                        string = "DD-MON-YYYY HH24:MI:SS.FF";
                    }
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.funcType == 175 ? Type.SQL_TIMESTAMP_NO_FRACTION : Type.SQL_TIMESTAMP;
                return;
            }
            case 168: {
                Type type = this.nodes[0].dataType;
                if (this.nodes[1] == null) {
                    if (type == null) {
                        type = this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!type.isCharacterType() && type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                        throw Error.error(5561);
                    }
                } else {
                    if (type == null) {
                        if (this.nodes[1].dataType == null) {
                            this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                            type = this.nodes[1].dataType;
                        } else {
                            type = this.nodes[1].dataType.isCharacterType() ? (this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT) : (this.nodes[0].dataType = Type.SQL_DATE);
                        }
                    }
                    if (this.nodes[1].dataType == null) {
                        if (type.isCharacterType()) {
                            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                        } else if (type.typeCode == 91) {
                            this.nodes[1].dataType = Type.SQL_TIME_MAX;
                        }
                    }
                    if (!(type.typeCode == 91 && this.nodes[1].dataType.typeCode == 92 || type.isCharacterType() && this.nodes[1].dataType.isCharacterType())) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = Type.SQL_TIMESTAMP;
                return;
            }
            case 169: {
                Type type = this.nodes[0].dataType;
                if (type == null) {
                    type = this.nodes[0].dataType = Type.SQL_BIGINT;
                }
                if (type.typeCode != 93 && type.typeCode != 95 && !type.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                return;
            }
            case 128: {
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 163: {
                this.dataType = Type.SQL_BINARY_16;
                break;
            }
            case 190: {
                if (this.nodes[0] == null) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.dataType = Type.SQL_GUID;
                    break;
                }
                if (this.nodes[0].dataType.isBinaryType() && !this.nodes[0].dataType.isLobType()) {
                    this.dataType = Type.SQL_CHAR_UUID;
                    break;
                }
                throw Error.error(5563);
            }
            case 191: 
            case 192: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                    } else if (!this.nodes[0].dataType.isDateTimeType() || this.nodes[0].dataType.typeCode == 92 || this.nodes[0].dataType.typeCode == 94) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 131: {
                if (this.nodes[0] != null) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_BIGINT;
                    } else if (!this.nodes[0].dataType.isExactNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 71: 
            case 76: 
            case 77: 
            case 86: 
            case 87: 
            case 88: 
            case 101: 
            case 120: 
            case 130: 
            case 146: 
            case 156: 
            case 157: 
            case 166: 
            case 167: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 155: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 78: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 158: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 4L);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                if (this.funcType == 81) {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType;
                } else {
                    if (this.nodes[0].dataType == null) {
                        this.nodes[0].dataType = this.nodes[1].dataType;
                    }
                    this.dataType = this.nodes[0].dataType;
                    if (this.nodes[1].dataType == null) {
                        this.nodes[1].dataType = this.nodes[0].dataType;
                    }
                    for (n = 0; n < this.nodes.length; ++n) {
                        if (this.nodes[n].dataType != null) continue;
                        this.nodes[n].dataType = Type.SQL_INTEGER;
                    }
                    this.dataType = this.nodes[0].dataType.getAggregateType(this.nodes[1].dataType);
                }
                switch (this.dataType.typeCode) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 25: {
                        break block0;
                    }
                    case 14: 
                    case 15: {
                        break block0;
                    }
                }
                throw Error.error(5561);
            }
            case 74: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 75: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 84: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = CharacterType.getCharacterType(12, 1L);
                break;
            }
            case 103: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 104: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision * 3L / 4L);
                break;
            }
            case 189: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 107: 
            case 188: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARBINARY_DEFAULT : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision / 2L);
                break;
            }
            case 173: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[0].dataType.precision == 0L) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                long l = (this.nodes[0].dataType.precision + 2L) / 3L * 4L;
                this.dataType = CharacterType.getCharacterType(12, l);
                break;
            }
            case 106: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (this.nodes[0].dataType.isNumberType()) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                    break;
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 132: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARBINARY;
                }
                if (!this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision * 2L);
                break;
            }
            case 141: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if ((n = (int)(this.nodes[0].dataType.isCharacterType() ? 1 : 0)) == 0 && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5561);
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = n != 0 ? Type.SQL_VARCHAR_DEFAULT : Type.SQL_VARBINARY_DEFAULT;
                break;
            }
            case 142: {
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue("", Type.SQL_VARCHAR);
                }
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 116: 
            case 144: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isExactNumberType()) {
                    throw Error.error(5561);
                }
                this.dataType = this.nodes[0].dataType.precision == 0L ? Type.SQL_VARCHAR_DEFAULT : ((CharacterType)this.nodes[0].dataType).getCharacterType(this.nodes[0].dataType.precision);
                break;
            }
            case 160: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[0].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 143: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType() && !this.dataType.isLobType()) break;
                throw Error.error(5561);
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType() || this.nodes[1].dataType.isLobType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1].exprSubType == 1) {
                    String string = (String)this.nodes[1].getValue(session);
                    this.pattern = Pattern.compile(string);
                }
                switch (this.funcType) {
                    case 133: 
                    case 134: {
                        this.dataType = Type.SQL_INTEGER;
                        break block0;
                    }
                    case 135: 
                    case 136: {
                        this.dataType = Type.SQL_BOOLEAN;
                        break block0;
                    }
                    case 137: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 138: 
                    case 139: {
                        this.dataType = Type.SQL_VARCHAR_DEFAULT;
                        break block0;
                    }
                    case 140: {
                        this.dataType = Type.getDefaultArrayType(12);
                        break block0;
                    }
                }
                break;
            }
            case 89: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR;
                        continue;
                    }
                    if (this.nodes[n].dataType.isCharacterType()) continue;
                    throw Error.error(5561);
                }
                this.dataType = Type.SQL_VARCHAR_DEFAULT;
                break;
            }
            case 117: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[1] == null) {
                    this.dataType = Type.SQL_BLOB;
                    break;
                }
                this.dataType = Type.SQL_CLOB;
                if (this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) break;
                throw Error.error(5561);
            }
            case 121: 
            case 147: {
                Number number;
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5561);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (!this.nodes[2].dataType.isCharacterType()) {
                        throw Error.error(5561);
                    }
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 40) {
                    this.dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].opType != 1 || (number = (Number)this.nodes[1].getValue(session)) == null) break;
                this.dataType = ((CharacterType)this.dataType).getCharacterType(number.longValue());
                break;
            }
            case 129: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType.collectionBaseType();
                }
                if (!this.nodes[1].dataType.collectionBaseType().canCompareDirect(this.nodes[0].dataType)) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_INTEGER;
                    }
                    if (!this.nodes[2].dataType.isIntegralType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 159: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1] == null) {
                    this.nodes[1] = new ExpressionValue(ValuePool.getInt(360), Type.SQL_INTEGER);
                }
                if (this.nodes[2] == null) {
                    this.nodes[2] = new ExpressionValue(ValuePool.getInt(427), Type.SQL_INTEGER);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 73: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 100: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 105: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 115: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_TIMESTAMP_NO_FRACTION);
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 123: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (!this.nodes[0].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isDateOrTimestampType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_DECIMAL_DEFAULT;
                break;
            }
            case 195: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[0].dataType.isCharacterType()) {
                    this.nodes[0] = new ExpressionOp(this.nodes[0], Type.SQL_DOUBLE);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 125: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 126: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 127: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (!this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 154: {
                this.dataType = CharacterType.getCharacterType(12, 6L);
                break;
            }
            case 162: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                }
                this.dataType = Type.SQL_TIMESTAMP;
                break;
            }
            case 164: {
                this.dataType = Type.SQL_TIMESTAMP_NO_FRACTION;
                break;
            }
            case 165: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 176: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                break;
            }
            case 177: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                this.dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                break;
            }
            case 180: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1] == null) {
                    String string = "DD-MON-YYYY HH24:MI:SS:FF TZH:TZM";
                    this.nodes[1] = new ExpressionValue(string, Type.SQL_VARCHAR);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() || !this.nodes[1].dataType.isCharacterType()) {
                    throw Error.error(5567);
                }
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 184: {
                this.dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                break;
            }
            case 185: {
                for (n = 0; n < this.nodes.length; ++n) {
                    if (this.nodes[n].dataType == null) {
                        this.nodes[n].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    if (this.nodes[n].dataType.isCharacterType() && !this.nodes[n].dataType.isLobType()) continue;
                    throw Error.error(5563);
                }
                if (this.nodes[1].valueData != null && this.nodes[2].valueData != null) {
                    this.charLookup = FunctionCustom.getTranslationMap((String)this.nodes[1].valueData, (String)this.nodes[2].valueData);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionCustom");
            }
        }
    }

    @Override
    public String getSQL() {
        switch (this.funcType) {
            case 1: {
                StringBuilder stringBuilder = new StringBuilder("LOCATE").append("(").append(this.nodes[0].getSQL()).append(",").append(this.nodes[1].getSQL());
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    stringBuilder.append(",").append(this.nodes[3].getSQL());
                }
                stringBuilder.append(")").toString();
                return stringBuilder.toString();
            }
            case 121: 
            case 147: {
                StringBuilder stringBuilder = new StringBuilder(this.name);
                stringBuilder.append("(").append(this.nodes[0].getSQL());
                stringBuilder.append(",").append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuilder.append(",").append(this.nodes[2].getSQL());
                }
                stringBuilder.append(")").toString();
                return stringBuilder.toString();
            }
            case 5: 
            case 31: 
            case 32: {
                return super.getSQL();
            }
            case 129: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append(this.nodes[0].getSQL()).append(' ').append("IN");
                stringBuilder.append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    stringBuilder.append(' ').append("FROM");
                    stringBuilder.append(' ').append(this.nodes[2].getSQL());
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 159: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append(this.nodes[0].getSQL());
                if (((Number)this.nodes[1].valueData).intValue() == 411) {
                    stringBuilder.append(' ').append("DESC");
                }
                if (((Number)this.nodes[2].valueData).intValue() == 467) {
                    stringBuilder.append(' ').append("NULLS").append(' ');
                    stringBuilder.append("LAST");
                }
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
            case 164: 
            case 165: {
                return this.name;
            }
            case 72: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 128: 
            case 151: 
            case 152: 
            case 153: 
            case 163: 
            case 172: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                return this.name + "(" + ")";
            }
            case 170: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return "TIMESTAMPADD" + "(" + string + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ")";
            }
            case 171: {
                String string = Tokens.getSQLTSIString(((Number)this.nodes[0].getValue(null)).intValue());
                return "TIMESTAMPDIFF" + "(" + string + "," + this.nodes[1].getSQL() + "," + this.nodes[2].getSQL() + ")";
            }
            case 95: {
                return this.nodes[0].getSQL() + ' ' + '+' + this.nodes[1].getSQL();
            }
            case 96: {
                return this.nodes[0].getSQL() + ' ' + '-' + this.nodes[1].getSQL();
            }
            case 71: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 120: 
            case 123: 
            case 125: 
            case 126: 
            case 127: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 150: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 160: 
            case 162: 
            case 166: 
            case 167: 
            case 168: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: {
                return this.getSQLSimple();
            }
            case 102: {
                StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
                stringBuilder.append("ROW_COUNT");
                stringBuilder.append(')');
                return stringBuilder.toString();
            }
        }
        return super.getSQL();
    }

    private String getSQLSimple() {
        StringBuilder stringBuilder = new StringBuilder(this.name).append('(');
        boolean bl = false;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            if (bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.nodes[i].getSQL());
            bl = true;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private static char[] soundex(String string) {
        if (string == null) {
            return null;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        for (int i = 0; i < n && n3 < 4; ++i) {
            int n4;
            char c = string.charAt(i);
            if ("AEIOUY".indexOf(c) != -1) {
                n4 = 55;
            } else if (c == 'H' || c == 'W') {
                n4 = 56;
            } else if ("BFPV".indexOf(c) != -1) {
                n4 = 49;
            } else if ("CGJKQSXZ".indexOf(c) != -1) {
                n4 = 50;
            } else if (c == 'D' || c == 'T') {
                n4 = 51;
            } else if (c == 'L') {
                n4 = 52;
            } else if (c == 'M' || c == 'N') {
                n4 = 53;
            } else {
                if (c != 'R') continue;
                n4 = 54;
            }
            if (n3 == 0) {
                cArray[n3++] = c;
                n2 = n4;
                continue;
            }
            if (n4 <= 54) {
                if (n4 == n2) continue;
                cArray[n3++] = n4;
                n2 = n4;
                continue;
            }
            if (n4 != 55) continue;
            n2 = n4;
        }
        return cArray;
    }

    private static int getTSIToken(String string) {
        int n;
        if ("yy".equalsIgnoreCase(string) || "yyyy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            n = 991;
        } else if ("qq".equalsIgnoreCase(string) || "quarter".equalsIgnoreCase(string)) {
            n = 990;
        } else if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            n = 989;
        } else if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            n = 987;
        } else if ("dy".equalsIgnoreCase(string) || "dayofyear".equalsIgnoreCase(string)) {
            n = 737;
        } else if ("dw".equalsIgnoreCase(string) || "weekday".equalsIgnoreCase(string)) {
            n = 736;
        } else if ("wk".equalsIgnoreCase(string) || "week".equalsIgnoreCase(string)) {
            n = 988;
        } else if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            n = 986;
        } else if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            n = 985;
        } else if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            n = 984;
        } else if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            n = 982;
        } else if ("mcs".equalsIgnoreCase(string) || "microsecond".equalsIgnoreCase(string)) {
            n = 983;
        } else if ("ns".equalsIgnoreCase(string) || "nanosecond".equalsIgnoreCase(string)) {
            n = 981;
        } else if ("tz".equalsIgnoreCase(string) || "tzoffset".equalsIgnoreCase(string)) {
            n = 828;
        } else {
            throw Error.error(5566, string);
        }
        return n;
    }

    private static int getExtractTokenForTSIPart(int n) {
        switch (n) {
            case 981: {
                return 873;
            }
            case 982: {
                return 872;
            }
            case 984: {
                return 264;
            }
            case 985: {
                return 179;
            }
            case 986: {
                return 137;
            }
            case 987: {
                return 78;
            }
            case 736: {
                return 736;
            }
            case 737: {
                return 737;
            }
            case 828: {
                return 828;
            }
            case 988: {
                return 851;
            }
            case 989: {
                return 183;
            }
            case 990: {
                return 787;
            }
            case 991: {
                return 341;
            }
        }
        throw Error.runtimeError(201, "FunctionCustom");
    }

    static int getSQLTypeForToken(String string) {
        int n = -1;
        if ("YEAR_MONTH".equalsIgnoreCase(string)) {
            n = 107;
        } else if ("DAY_HOUR".equalsIgnoreCase(string)) {
            n = 108;
        } else if ("DAY_MINUTE".equalsIgnoreCase(string)) {
            n = 109;
        } else if ("DAY_SECOND".equalsIgnoreCase(string)) {
            n = 110;
        } else if ("DAY_MICROSECOND".equalsIgnoreCase(string)) {
            n = 110;
        } else if ("HOUR_MINUTE".equalsIgnoreCase(string)) {
            n = 111;
        } else if ("HOUR_SECOND".equalsIgnoreCase(string)) {
            n = 112;
        } else if ("HOUR_MICROSECOND".equalsIgnoreCase(string)) {
            n = 112;
        } else if ("MINUTE_SECOND".equalsIgnoreCase(string)) {
            n = 113;
        } else if ("MINUTE_MICROSECOND".equalsIgnoreCase(string)) {
            n = 113;
        } else if ("SECOND_MICROSECOND".equalsIgnoreCase(string)) {
            n = 106;
        }
        return n;
    }

    private static IntKeyIntValueHashMap getTranslationMap(String string, String string2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = new IntKeyIntValueHashMap();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i >= string2.length()) {
                intKeyIntValueHashMap.put(c, -1);
                continue;
            }
            char c2 = string2.charAt(i);
            intKeyIntValueHashMap.put(c, c2);
        }
        return intKeyIntValueHashMap;
    }

    private static String translateWithMap(String string, IntKeyIntValueHashMap intKeyIntValueHashMap) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = intKeyIntValueHashMap.get((int)c, -2);
            if (n == -2) {
                stringBuilder.append(c);
                continue;
            }
            if (n == -1) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static int regexpParams(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        block6: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'i': {
                    n |= 2;
                    continue block6;
                }
                case 'c': {
                    n &= 0xFFFFFFFD;
                    n |= 0x40;
                    continue block6;
                }
                case 'n': {
                    n |= 0x20;
                    continue block6;
                }
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                default: {
                    throw Error.error(3472, string);
                }
            }
        }
        return n;
    }

    static {
        nonDeterministicFuncSet.add(72);
        nonDeterministicFuncSet.add(89);
        nonDeterministicFuncSet.add(90);
        nonDeterministicFuncSet.add(91);
        nonDeterministicFuncSet.add(93);
        nonDeterministicFuncSet.add(100);
        nonDeterministicFuncSet.add(108);
        nonDeterministicFuncSet.add(110);
        nonDeterministicFuncSet.add(114);
        nonDeterministicFuncSet.add(112);
        nonDeterministicFuncSet.add(113);
        nonDeterministicFuncSet.add(111);
        nonDeterministicFuncSet.add(151);
        nonDeterministicFuncSet.add(152);
        nonDeterministicFuncSet.add(153);
        nonDeterministicFuncSet.add(154);
        nonDeterministicFuncSet.add(163);
        nonDeterministicFuncSet.add(164);
        nonDeterministicFuncSet.add(165);
        nonDeterministicFuncSet.add(168);
        nonDeterministicFuncSet.add(172);
        nonDeterministicFuncSet.add(181);
        nonDeterministicFuncSet.add(182);
        nonDeterministicFuncSet.add(183);
        nonDeterministicFuncSet.add(184);
        nonDeterministicFuncSet.add(190);
        nonDeterministicFuncSet.add(191);
        nonDeterministicFuncSet.add(192);
        customRegularFuncMap.put(701, 71);
        customRegularFuncMap.put(702, 72);
        customRegularFuncMap.put(706, 73);
        customRegularFuncMap.put(703, 159);
        customRegularFuncMap.put(704, 74);
        customRegularFuncMap.put(705, 75);
        customRegularFuncMap.put(707, 76);
        customRegularFuncMap.put(708, 77);
        customRegularFuncMap.put(709, 78);
        customRegularFuncMap.put(711, 79);
        customRegularFuncMap.put(712, 80);
        customRegularFuncMap.put(713, 6);
        customRegularFuncMap.put(714, 81);
        customRegularFuncMap.put(715, 82);
        customRegularFuncMap.put(716, 83);
        customRegularFuncMap.put(36, 84);
        customRegularFuncMap.put(717, 84);
        customRegularFuncMap.put(718, 85);
        customRegularFuncMap.put(720, 86);
        customRegularFuncMap.put(721, 87);
        customRegularFuncMap.put(722, 88);
        customRegularFuncMap.put(723, 89);
        customRegularFuncMap.put(724, 43);
        customRegularFuncMap.put(725, 51);
        customRegularFuncMap.put(625, 90);
        customRegularFuncMap.put(727, 92);
        customRegularFuncMap.put(726, 91);
        customRegularFuncMap.put(728, 93);
        customRegularFuncMap.put(729, 94);
        customRegularFuncMap.put(730, 95);
        customRegularFuncMap.put(731, 96);
        customRegularFuncMap.put(732, 97);
        customRegularFuncMap.put(733, 98);
        customRegularFuncMap.put(861, 194);
        customRegularFuncMap.put(862, 193);
        customRegularFuncMap.put(78, 5);
        customRegularFuncMap.put(738, 5);
        customRegularFuncMap.put(739, 5);
        customRegularFuncMap.put(740, 5);
        customRegularFuncMap.put(741, 5);
        customRegularFuncMap.put(742, 99);
        customRegularFuncMap.put(743, 100);
        customRegularFuncMap.put(745, 101);
        customRegularFuncMap.put(413, 102);
        customRegularFuncMap.put(746, 103);
        customRegularFuncMap.put(863, 115);
        customRegularFuncMap.put(748, 104);
        customRegularFuncMap.put(749, 105);
        customRegularFuncMap.put(750, 106);
        customRegularFuncMap.put(751, 107);
        customRegularFuncMap.put(137, 5);
        customRegularFuncMap.put(138, 108);
        customRegularFuncMap.put(145, 32);
        customRegularFuncMap.put(755, 1);
        customRegularFuncMap.put(756, 110);
        customRegularFuncMap.put(757, 112);
        customRegularFuncMap.put(758, 113);
        customRegularFuncMap.put(759, 114);
        customRegularFuncMap.put(760, 111);
        customRegularFuncMap.put(762, 115);
        customRegularFuncMap.put(763, 26);
        customRegularFuncMap.put(163, 116);
        customRegularFuncMap.put(468, 7);
        customRegularFuncMap.put(765, 117);
        customRegularFuncMap.put(772, 118);
        customRegularFuncMap.put(766, 1);
        customRegularFuncMap.put(768, 14);
        customRegularFuncMap.put(769, 120);
        customRegularFuncMap.put(770, 121);
        customRegularFuncMap.put(771, 31);
        customRegularFuncMap.put(179, 5);
        customRegularFuncMap.put(183, 5);
        customRegularFuncMap.put(774, 5);
        customRegularFuncMap.put(775, 123);
        customRegularFuncMap.put(865, 195);
        customRegularFuncMap.put(864, 190);
        customRegularFuncMap.put(779, 125);
        customRegularFuncMap.put(782, 126);
        customRegularFuncMap.put(783, 127);
        customRegularFuncMap.put(784, 8);
        customRegularFuncMap.put(785, 128);
        customRegularFuncMap.put(786, 129);
        customRegularFuncMap.put(787, 5);
        customRegularFuncMap.put(788, 130);
        customRegularFuncMap.put(789, 131);
        customRegularFuncMap.put(790, 132);
        customRegularFuncMap.put(791, 133);
        customRegularFuncMap.put(792, 134);
        customRegularFuncMap.put(793, 135);
        customRegularFuncMap.put(794, 136);
        customRegularFuncMap.put(795, 137);
        customRegularFuncMap.put(796, 138);
        customRegularFuncMap.put(797, 139);
        customRegularFuncMap.put(798, 140);
        customRegularFuncMap.put(248, 141);
        customRegularFuncMap.put(799, 142);
        customRegularFuncMap.put(800, 143);
        customRegularFuncMap.put(254, 144);
        customRegularFuncMap.put(801, 145);
        customRegularFuncMap.put(802, 146);
        customRegularFuncMap.put(804, 147);
        customRegularFuncMap.put(803, 31);
        customRegularFuncMap.put(264, 5);
        customRegularFuncMap.put(805, 5);
        customRegularFuncMap.put(806, 150);
        customRegularFuncMap.put(807, 151);
        customRegularFuncMap.put(808, 152);
        customRegularFuncMap.put(809, 153);
        customRegularFuncMap.put(810, 154);
        customRegularFuncMap.put(811, 155);
        customRegularFuncMap.put(812, 156);
        customRegularFuncMap.put(813, 157);
        customRegularFuncMap.put(814, 159);
        customRegularFuncMap.put(815, 158);
        customRegularFuncMap.put(557, 160);
        customRegularFuncMap.put(818, 23);
        customRegularFuncMap.put(820, 162);
        customRegularFuncMap.put(821, 164);
        customRegularFuncMap.put(822, 165);
        customRegularFuncMap.put(823, 166);
        customRegularFuncMap.put(824, 167);
        customRegularFuncMap.put(298, 168);
        customRegularFuncMap.put(825, 169);
        customRegularFuncMap.put(826, 170);
        customRegularFuncMap.put(827, 171);
        customRegularFuncMap.put(828, 172);
        customRegularFuncMap.put(829, 173);
        customRegularFuncMap.put(830, 174);
        customRegularFuncMap.put(831, 175);
        customRegularFuncMap.put(832, 176);
        customRegularFuncMap.put(833, 177);
        customRegularFuncMap.put(834, 178);
        customRegularFuncMap.put(835, 179);
        customRegularFuncMap.put(836, 180);
        customRegularFuncMap.put(838, 181);
        customRegularFuncMap.put(839, 182);
        customRegularFuncMap.put(840, 183);
        customRegularFuncMap.put(841, 184);
        customRegularFuncMap.put(303, 185);
        customRegularFuncMap.put(842, 186);
        customRegularFuncMap.put(311, 187);
        customRegularFuncMap.put(844, 27);
        customRegularFuncMap.put(847, 192);
        customRegularFuncMap.put(848, 191);
        customRegularFuncMap.put(866, 163);
        customRegularFuncMap.put(845, 188);
        customRegularFuncMap.put(846, 189);
        customRegularFuncMap.put(849, 190);
        customRegularFuncMap.put(850, 5);
        customRegularFuncMap.put(341, 5);
        customValueFuncMap = new IntKeyIntValueHashMap();
        customValueFuncMap.put(837, 43);
        customValueFuncMap.put(781, 52);
    }
}

