/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.openejb.util.LogStream;

public class LogStreamAsync
implements LogStream,
Closeable {
    private static final LinkedBlockingQueue<Message> log = new LinkedBlockingQueue();
    private static final Thread t = new Thread((Runnable)new Consumer(log), "LogStreamAsync.Thread");
    private static final AtomicBoolean started = new AtomicBoolean(false);
    private final LogStream ls;

    public LogStreamAsync(LogStream ls) {
        this.ls = ls;
        if (!started.getAndSet(true)) {
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public void close() throws IOException {
        log.clear();
        try {
            log.put(new Message(this.ls, level.quit, ""));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean isFatalEnabled() {
        return this.ls.isFatalEnabled();
    }

    @Override
    public void fatal(String message) {
        this.log(level.fatal, message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log(level.fatal, message, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.ls.isErrorEnabled();
    }

    @Override
    public void error(String message) {
        this.log(level.error, message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(level.error, message, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.ls.isWarnEnabled();
    }

    @Override
    public void warn(String message) {
        this.log(level.warn, message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(level.warn, message, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.ls.isInfoEnabled();
    }

    @Override
    public void info(String message) {
        this.log(level.info, message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(level.info, message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.ls.isDebugEnabled();
    }

    @Override
    public void debug(String message) {
        this.log(level.debug, message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(level.debug, message, t);
    }

    public void log(level l, String s) {
        this.log(l, s, null);
    }

    public void log(level l, String s, Throwable t) {
        try {
            log.put(new Message(this.ls, l, s, t));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static final class Consumer
    implements Runnable {
        private final BlockingQueue<Message> queue;

        private Consumer(BlockingQueue<Message> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                Message msg;
                while (!level.quit.equals((Object)(msg = this.queue.take()).l)) {
                    Throwable t = msg.t;
                    if (null != t) {
                        switch (msg.l) {
                            case fatal: {
                                msg.ls.fatal(msg.s, t);
                                break;
                            }
                            case error: {
                                msg.ls.error(msg.s, t);
                                break;
                            }
                            case warn: {
                                msg.ls.warn(msg.s, t);
                                break;
                            }
                            case info: {
                                msg.ls.info(msg.s, t);
                                break;
                            }
                            case debug: {
                                msg.ls.debug(msg.s, t);
                            }
                        }
                        continue;
                    }
                    switch (msg.l) {
                        case fatal: {
                            msg.ls.fatal(msg.s);
                            break;
                        }
                        case error: {
                            msg.ls.error(msg.s);
                            break;
                        }
                        case warn: {
                            msg.ls.warn(msg.s);
                            break;
                        }
                        case info: {
                            msg.ls.info(msg.s);
                            break;
                        }
                        case debug: {
                            msg.ls.debug(msg.s);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static final class Message {
        private final LogStream ls;
        private final level l;
        private final String s;
        private final Throwable t;

        private Message(LogStream ls, level l, String s) {
            this(ls, l, s, (Throwable)null);
        }

        private Message(LogStream ls, level l, String s, Throwable t) {
            this.ls = ls;
            this.l = l;
            this.s = s;
            this.t = t;
        }
    }

    private static enum level {
        fatal,
        error,
        warn,
        info,
        debug,
        quit;

    }
}

