/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;
import javax.servlet.http.HttpServletRequest;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.api.resource.DestroyableResource;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.core.security.JaccProvider;
import org.apache.openejb.core.security.jaas.GroupPrincipal;
import org.apache.openejb.core.security.jacc.BasicJaccProvider;
import org.apache.openejb.core.security.jacc.BasicPolicyConfiguration;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.CallerPrincipal;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public abstract class AbstractSecurityService
implements DestroyableResource,
SecurityService<UUID>,
ThreadContextListener,
BasicPolicyConfiguration.RoleResolver,
PolicyContextHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB_SECURITY, "org.apache.openejb.util.resources");
    protected static final String KEY_SUBJECT = "javax.security.auth.Subject.container";
    protected static final String KEY_REQUEST = "javax.servlet.http.HttpServletRequest";
    protected static final Set<String> KEYS = new HashSet<String>(Arrays.asList("javax.servlet.http.HttpServletRequest", "javax.security.auth.Subject.container"));
    private static final Map<Object, Identity> identities = new ConcurrentHashMap<Object, Identity>();
    protected static final ThreadLocal<Identity> clientIdentity = new ThreadLocal();
    protected String defaultUser = "guest";
    private String realmName = "PropertiesLogin";
    protected Subject defaultSubject;
    protected SecurityContext defaultContext;

    public AbstractSecurityService() {
        this(AbstractSecurityService.autoJaccProvider());
    }

    public AbstractSecurityService(String jaccProvider) {
        JavaSecurityManagers.setSystemProperty(JaccProvider.class.getName(), jaccProvider);
        AbstractSecurityService.installJacc();
        ThreadContext.addThreadContextListener(this);
        this.updateSecurityContext();
        SystemInstance.get().setComponent(BasicPolicyConfiguration.RoleResolver.class, this);
        try {
            for (String key : this.getKeys()) {
                PolicyContext.registerHandler((String)key, (PolicyContextHandler)this, (boolean)true);
            }
        }
        catch (PolicyContextException e) {
            LOGGER.warning("Can't register PolicyContextHandler", e);
        }
    }

    public void destroyResource() {
        ThreadContext.removeThreadContextListener(this);
    }

    @Override
    public void onLogout(HttpServletRequest request) {
        clientIdentity.remove();
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getDefaultUser() {
        return this.defaultUser;
    }

    public void setDefaultUser(String defaultUser) {
        this.defaultUser = defaultUser;
        this.updateSecurityContext();
    }

    private void updateSecurityContext() {
        this.defaultSubject = this.createSubject(this.defaultUser, this.defaultUser);
        this.defaultContext = new SecurityContext(this.defaultSubject);
    }

    @Override
    public void init(Properties props) throws Exception {
    }

    @Override
    public UUID login(String username, String password) throws LoginException {
        return (UUID)this.login(this.realmName, username, password);
    }

    @Override
    public Set<String> getLogicalRoles(Principal[] principals, Set<String> logicalRoles) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>(principals.length);
        for (Principal principal : principals) {
            String name = principal.getName();
            if (!logicalRoles.contains(name)) continue;
            roles.add(name);
        }
        return roles;
    }

    @Override
    public void contextEntered(ThreadContext oldContext, ThreadContext newContext) {
        SecurityContext securityContext;
        String moduleID = newContext.getBeanContext().getModuleID();
        JavaSecurityManagers.setContextID(moduleID);
        SecurityContext defaultSecurityContext = this.getDefaultSecurityContext();
        ProvidedSecurityContext providedSecurityContext = newContext.get(ProvidedSecurityContext.class);
        SecurityContext securityContext2 = oldContext != null ? oldContext.get(SecurityContext.class) : (securityContext = providedSecurityContext != null ? providedSecurityContext.context : null);
        if (providedSecurityContext == null && (securityContext == null || securityContext == defaultSecurityContext)) {
            Identity identity = clientIdentity.get();
            securityContext = identity != null ? new SecurityContext(identity.subject) : defaultSecurityContext;
        }
        newContext.set(SecurityContext.class, securityContext);
    }

    public UUID overrideWithRunAsContext(ThreadContext ctx, BeanContext newContext, BeanContext oldContext) {
        Subject runAsSubject = this.getRunAsSubject(newContext);
        if (oldContext != null && runAsSubject == null) {
            runAsSubject = this.getRunAsSubject(oldContext);
        }
        ctx.set(SecurityContext.class, new SecurityContext(runAsSubject));
        return this.disassociate();
    }

    public Subject getRunAsSubject(BeanContext callingBeanContext) {
        if (callingBeanContext == null) {
            return null;
        }
        return this.createRunAsSubject(callingBeanContext.getRunAsUser(), callingBeanContext.getRunAs());
    }

    protected Subject createRunAsSubject(String runAsUser, String runAsRole) {
        return this.createSubject(runAsUser, runAsRole);
    }

    @Override
    public void contextExited(ThreadContext exitedContext, ThreadContext reenteredContext) {
        if (reenteredContext == null) {
            JavaSecurityManagers.setContextID(null);
        } else {
            JavaSecurityManagers.setContextID(reenteredContext.getBeanContext().getModuleID());
        }
    }

    protected UUID registerSubject(Subject subject) {
        Identity identity = new Identity(subject);
        UUID token = identity.getToken();
        identities.put(token, identity);
        return token;
    }

    @Override
    public void logout(UUID securityIdentity) throws LoginException {
        Identity identity = identities.get(securityIdentity);
        if (identity == null) {
            throw new LoginException("Identity is not currently logged in: " + securityIdentity);
        }
        identities.remove(securityIdentity);
    }

    protected void unregisterSubject(Object securityIdentity) {
        identities.remove(securityIdentity);
    }

    @Override
    public void associate(UUID securityIdentity) throws LoginException {
        Identity existing = clientIdentity.get();
        if (existing != null && existing.getToken() != null) {
            throw new LoginException("Thread already associated with a client identity.  Refusing to overwrite. (current=" + existing.getToken() + "/" + existing.getSubject() + ", refused=" + securityIdentity + ")");
        }
        if (securityIdentity == null) {
            throw new NullPointerException("The security token passed in is null");
        }
        Identity identity = identities.get(securityIdentity);
        if (identity == null) {
            throw new LoginException("Identity is not currently logged in: " + securityIdentity);
        }
        clientIdentity.set(identity);
    }

    @Override
    public UUID disassociate() {
        try {
            Identity identity = clientIdentity.get();
            UUID uUID = identity == null ? null : identity.getToken();
            return uUID;
        }
        finally {
            clientIdentity.remove();
        }
    }

    @Override
    public boolean isCallerInRole(String role) {
        if (role == null) {
            throw new IllegalArgumentException("Role must not be null");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        if (threadContext == null) {
            return false;
        }
        SecurityContext securityContext = threadContext.get(SecurityContext.class);
        if ("**".equals(role)) {
            return securityContext != this.defaultContext;
        }
        Set<Group> grps = securityContext.subject.getPrincipals(Group.class);
        for (Group grp : grps) {
            if (!grp.getName().equals(role)) continue;
            return true;
        }
        Set<GroupPrincipal> grpsp = securityContext.subject.getPrincipals(GroupPrincipal.class);
        for (GroupPrincipal grp : grpsp) {
            if (!grp.getName().equals(role)) continue;
            return true;
        }
        return false;
    }

    protected Subject getSubject() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        if (threadContext == null) {
            Identity id = clientIdentity.get();
            if (id != null) {
                return id.getSubject();
            }
            return new Subject();
        }
        SecurityContext securityContext = threadContext.get(SecurityContext.class);
        if (securityContext == null) {
            return new Subject();
        }
        return securityContext.subject;
    }

    @Override
    public <P extends Principal> Set<P> getPrincipalsByType(Class<P> pType) {
        if (pType == null) {
            throw new IllegalArgumentException("Principal type can't be null");
        }
        return this.getSubject().getPrincipals(pType);
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return new ProtectionDomain(new CodeSource(null, (Certificate[])null), null, null, this.getSubject().getPrincipals().toArray(new Principal[0]));
    }

    @Override
    public Principal getCallerPrincipal() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        if (threadContext == null) {
            Identity id = clientIdentity.get();
            if (id != null) {
                return this.getCallerPrincipal(id.getSubject().getPrincipals());
            }
            return null;
        }
        SecurityContext securityContext = threadContext.get(SecurityContext.class);
        Set<Principal> principals = securityContext.subject.getPrincipals();
        return this.getCallerPrincipal(principals);
    }

    private Principal getCallerPrincipal(Set<Principal> principals) {
        if (!principals.isEmpty()) {
            for (Principal principal : principals) {
                if (!principal.getClass().isAnnotationPresent(CallerPrincipal.class)) continue;
                return principal;
            }
            return principals.iterator().next();
        }
        return null;
    }

    @Override
    public boolean isCallerAuthorized(Method method, InterfaceType type) {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        BeanContext beanContext = threadContext.getBeanContext();
        try {
            Identity currentIdentity;
            String name;
            String ejbName = beanContext.getEjbName();
            String string = name = type == null ? null : type.getSpecName();
            if ("LocalBean".equals(name) || "LocalBeanHome".equals(name)) {
                name = null;
            }
            SecurityContext securityContext = (currentIdentity = clientIdentity.get()) == null ? threadContext.get(SecurityContext.class) : new SecurityContext(currentIdentity.getSubject());
            securityContext.acc.checkPermission((Permission)new EJBMethodPermission(ejbName, name, method));
        }
        catch (AccessControlException e) {
            return false;
        }
        return true;
    }

    protected static String autoJaccProvider() {
        return SystemInstance.isInitialized() ? SystemInstance.get().getProperty(JaccProvider.class.getName(), BasicJaccProvider.class.getName()) : BasicJaccProvider.class.getName();
    }

    protected static void installJacc() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        String providerKey = "javax.security.jacc.PolicyConfigurationFactory.provider";
        try {
            if (JavaSecurityManagers.getSystemProperty("javax.security.jacc.PolicyConfigurationFactory.provider") == null) {
                JavaSecurityManagers.setSystemProperty("javax.security.jacc.PolicyConfigurationFactory.provider", JaccProvider.Factory.class.getName());
                ClassLoader cl = JaccProvider.Factory.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
            }
            PolicyConfigurationFactory.getPolicyConfigurationFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not install JACC Policy Configuration Factory: " + JavaSecurityManagers.getSystemProperty("javax.security.jacc.PolicyConfigurationFactory.provider"), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        String systemPolicyProvider = SystemInstance.get().getOptions().getProperties().getProperty("javax.security.jacc.policy.provider");
        if (systemPolicyProvider != null && Policy.getPolicy() == null) {
            AbstractSecurityService.installPolicy(systemPolicyProvider);
        }
        if (!JaccProvider.Policy.class.getName().equals(Policy.getPolicy().getClass().getName())) {
            AbstractSecurityService.installPolicy(JaccProvider.Policy.class.getName());
        }
    }

    private static void installPolicy(String policyProvider) {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> policyClass = Class.forName(policyProvider, true, classLoader);
            Policy policy = (Policy)policyClass.newInstance();
            policy.refresh();
            Policy.setPolicy(policy);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not install JACC Policy Provider: " + policyProvider, e);
        }
    }

    protected Subject createSubject(String name, String groupName) {
        if (name == null) {
            return null;
        }
        User user = new User(name);
        Group group = new Group(groupName);
        group.addMember(user);
        HashSet<Principal> principals = new HashSet<Principal>();
        principals.add(user);
        principals.add(group);
        return new Subject(true, principals, new HashSet(), new HashSet());
    }

    @Override
    public Object currentState() {
        return clientIdentity.get();
    }

    @Override
    public void setState(Object o) {
        if (Identity.class.isInstance(o)) {
            clientIdentity.set((Identity)Identity.class.cast(o));
        } else if (o == null) {
            clientIdentity.remove();
        }
    }

    protected SecurityContext getDefaultSecurityContext() {
        return this.defaultContext;
    }

    public boolean supports(String key) throws PolicyContextException {
        return KEY_SUBJECT.equals(key);
    }

    public String[] getKeys() throws PolicyContextException {
        return new String[]{KEY_SUBJECT};
    }

    public Object getContext(String key, Object data) throws PolicyContextException {
        if (KEY_SUBJECT.equals(key)) {
            return this.getSubject();
        }
        throw new PolicyContextException("Handler does not support key: " + key);
    }

    @CallerPrincipal
    public static class User
    implements Principal {
        private final String name;

        public User(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)User.class.cast(o);
            return Objects.equals(this.name, user.name);
        }

        @Override
        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    public static class Group
    implements Principal {
        private final List<Principal> members = new ArrayList<Principal>();
        private final String name;

        public Group(String name) {
            this.name = name;
        }

        public boolean addMember(Principal user) {
            return this.members.add(user);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    protected static class Identity
    implements Serializable {
        private final Subject subject;
        private final UUID token;

        public Identity(Subject subject) {
            this.subject = subject;
            this.token = UUID.randomUUID();
        }

        public Identity(Subject subject, UUID token) {
            this.subject = subject;
            this.token = token;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public UUID getToken() {
            return this.token;
        }
    }

    public static final class SecurityContext {
        public final Subject subject;
        public final AccessControlContext acc;

        public SecurityContext(Subject subject) {
            this.subject = subject;
            this.acc = (AccessControlContext)Subject.doAsPrivileged(subject, AccessController::getContext, null);
        }
    }

    public static final class ProvidedSecurityContext {
        public final SecurityContext context;

        public ProvidedSecurityContext(SecurityContext context) {
            this.context = context;
        }
    }
}

