/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.PassivationCapable;
import org.apache.openejb.cdi.WebAppElResolver;
import org.apache.openejb.cdi.WebAppInjectionResolver;
import org.apache.openejb.cdi.WebappWebBeansContext;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.component.BuiltInOwbBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class WebappBeanManager
extends BeanManagerImpl {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private static final ThreadLocal<Boolean> USE_PARENT_BM = new ThreadLocal();
    private final WebappWebBeansContext webappCtx;
    private final InheritedBeanFilter filter;
    private Set<Bean<?>> deploymentBeans;
    private boolean started;

    public WebappBeanManager(WebappWebBeansContext ctx) {
        super((WebBeansContext)ctx);
        this.webappCtx = ctx;
        this.deploymentBeans = super.getBeans();
        Reflections.set((Object)this, "injectionResolver", (Object)new WebAppInjectionResolver(ctx));
        this.filter = new InheritedBeanFilter(this);
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        List interceptors = super.resolveInterceptors(type, interceptorBindings);
        List parentInterceptors = this.getParentBm().resolveInterceptors(type, interceptorBindings);
        for (Interceptor i : parentInterceptors) {
            if (interceptors.contains(i)) continue;
            interceptors.add(i);
        }
        return interceptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ctx) {
        block8: {
            Asserts.assertNotNull((Object)injectionPoint, (String)"injectionPoint parameter");
            if (injectionPoint == null) {
                return null;
            }
            BeanManagerImpl parentBm = this.getParentBm();
            Boolean existing = USE_PARENT_BM.get();
            if (existing != null && existing.booleanValue()) {
                if (parentBm == null) {
                    return null;
                }
                return parentBm.getInjectableReference(injectionPoint, ctx);
            }
            Bean injectedBean = this.getInjectionResolver().getInjectionPointBean(injectionPoint);
            if (parentBm == null || injectedBean == null || injectedBean != parentBm.getInjectionResolver().getInjectionPointBean(injectionPoint)) break block8;
            USE_PARENT_BM.set(true);
            try {
                Object object = parentBm.getInjectableReference(injectionPoint, ctx);
                USE_PARENT_BM.remove();
                return object;
            }
            catch (Throwable throwable) {
                try {
                    USE_PARENT_BM.remove();
                    throw throwable;
                }
                catch (UnsatisfiedResolutionException unsatisfiedResolutionException) {
                    // empty catch block
                }
            }
        }
        return super.getInjectableReference(injectionPoint, ctx);
    }

    public <T> CreationalContextImpl<T> createCreationalContext(Contextual<T> contextual) {
        try {
            return super.createCreationalContext(contextual);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().createCreationalContext(contextual);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        try {
            return super.isNormalScope(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isNormalScope(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        try {
            return super.isPassivatingScope(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isPassivatingScope(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        try {
            return super.isQualifier(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isQualifier(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        try {
            return super.isInterceptorBinding(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isInterceptorBinding(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        try {
            return super.isStereotype(annotationType);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().isStereotype(annotationType);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> qualifier) {
        try {
            return super.getInterceptorBindingDefinition(qualifier);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().getInterceptorBindingDefinition(qualifier);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public Context getContext(Class<? extends Annotation> scope) {
        try {
            return super.getContext(scope);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().getContext(scope);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public ELResolver getELResolver() {
        return new WebAppElResolver(super.getELResolver(), this.getParentBm().getELResolver());
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        try {
            return super.createAnnotatedType(type);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().createAnnotatedType(type);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        try {
            return super.createInjectionTarget(type);
        }
        catch (RuntimeException e) {
            try {
                return this.getParentBm().createInjectionTarget(type);
            }
            catch (RuntimeException ignored) {
                throw e;
            }
        }
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return super.wrapExpressionFactory(expressionFactory);
    }

    public BeanManagerImpl getParentBm() {
        WebBeansContext parent = this.webappCtx.getParent();
        return parent != null ? parent.getBeanManagerImpl() : null;
    }

    public boolean isInUse() {
        return super.isInUse() || this.getParentBm().isInUse();
    }

    public Set<Bean<?>> getComponents() {
        if (!this.started) {
            return new IteratorSet(new MultipleIterator((Filter)this.filter, new Iterator[]{this.deploymentBeans.iterator(), this.getParentBm().getComponents().iterator()}));
        }
        return this.deploymentBeans;
    }

    public Set<Bean<?>> getBeans() {
        return this.deploymentBeans;
    }

    public <T> void addAdditionalAnnotatedType(Object extension, AnnotatedType<T> inAnnotatedType, String id) {
        super.addAdditionalAnnotatedType(extension, inAnnotatedType, id);
    }

    public Bean<?> getPassivationCapableBean(String id) {
        Bean bean = super.getPassivationCapableBean(id);
        if (bean == null && this.getParentBm() != null) {
            return this.getParentBm().getPassivationCapableBean(id);
        }
        return bean;
    }

    public void afterStart() {
        this.started = true;
        this.deploymentBeans = this.mergeBeans();
        this.webappCtx.getBeanManagerImpl().getInjectionResolver().clearCaches();
    }

    private Set<Bean<?>> mergeBeans() {
        CopyOnWriteArraySet allBeans = new CopyOnWriteArraySet();
        BeanManagerImpl parentBm = this.getParentBm();
        if (parentBm != null) {
            for (Bean bean : parentBm.getBeans()) {
                if (!this.filter.accept(bean)) continue;
                allBeans.add(bean);
            }
        }
        allBeans.addAll(super.getBeans());
        return allBeans;
    }

    public void beforeStop() {
    }

    private boolean isEvent(Object event) {
        return !WebBeansUtil.isDefaultExtensionBeanEventType(event.getClass()) && !this.webappCtx.getWebBeansUtil().isContainerEventType(event);
    }

    private static final class IteratorSet<A>
    extends HashSet<A> {
        private final Iterator<A> it;

        private IteratorSet(Iterator<A> it) {
            this.it = it;
        }

        @Override
        public Iterator<A> iterator() {
            return this.it;
        }
    }

    private static final class MultipleIterator<A>
    implements Iterator<A> {
        private final Iterator<A>[] delegates;
        private final Filter<A> filter;
        private A next;
        private int idx;

        private MultipleIterator(Filter<A> filter, Iterator<A> ... delegates) {
            this.filter = filter;
            this.delegates = delegates;
        }

        @Override
        public boolean hasNext() {
            while (this.idx < this.delegates.length) {
                while (this.delegates[this.idx].hasNext()) {
                    this.next = this.delegates[this.idx].next();
                    if (this.idx != 0 && !this.filter.accept(this.next)) continue;
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        @Override
        public A next() {
            return this.next;
        }

        @Override
        public void remove() {
            this.delegates[this.idx].remove();
        }
    }

    private static final class InheritedBeanFilter
    implements Filter<Bean<?>> {
        private final WebappBeanManager beanManager;

        private InheritedBeanFilter(WebappBeanManager beanManager) {
            this.beanManager = beanManager;
        }

        @Override
        public boolean accept(Bean<?> bean) {
            OwbBean owbBean;
            if (BuiltInOwbBean.class.isInstance(bean) || ExtensionBean.class.isInstance(bean)) {
                return false;
            }
            if (OwbBean.class.isInstance(bean) ? (owbBean = (OwbBean)OwbBean.class.cast(bean)).isPassivationCapable() && this.hasBean(owbBean.getId()) : PassivationCapable.class.isInstance(bean) && this.hasBean(((PassivationCapable)PassivationCapable.class.cast(bean)).getId())) {
                return false;
            }
            Set qualifiers = bean.getQualifiers();
            return this.beanManager.getBeans(bean.getBeanClass(), qualifiers.isEmpty() ? EMPTY_ANNOTATIONS : qualifiers.toArray(new Annotation[qualifiers.size()])).isEmpty();
        }

        private boolean hasBean(String id) {
            return this.beanManager.getPassivationCapableBean(id) != null;
        }
    }

    private static interface Filter<A> {
        public boolean accept(A var1);
    }
}

