/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomee.security.http.SavedAuthentication;
import org.apache.tomee.security.http.SavedRequest;

public interface LoginToContinueMechanism {
    public static final int MAX_SAVE_POST_SIZE = 4096;
    public static final String ORIGINAL_REQUEST = "org.apache.tomee.security.request.original";
    public static final String AUTHENTICATION = "org.apache.tomee.security.request.authentication";
    public static final String CALLER_AUTHENICATION = "org.apache.tomee.security.request.caller.authentication";

    public LoginToContinue getLoginToContinue();

    public static void saveRequest(HttpServletRequest request) throws IOException {
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = request.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        int maxSavePostSize = 4096;
        if (maxSavePostSize != 0) {
            int bytesRead;
            ByteChunk body = new ByteChunk();
            body.setLimit(maxSavePostSize);
            byte[] buffer = new byte[4096];
            ServletInputStream is = request.getInputStream();
            while ((bytesRead = is.read(buffer)) >= 0) {
                body.append(buffer, 0, bytesRead);
            }
            if (body.getLength() > 0) {
                saved.setContentType(request.getContentType());
                saved.setBody(body);
            }
        }
        saved.setMethod(request.getMethod());
        saved.setQueryString(request.getQueryString());
        saved.setRequestURI(request.getRequestURI());
        saved.setRequestURL(request.getRequestURL().toString());
        request.getSession().setAttribute(ORIGINAL_REQUEST, (Object)saved);
    }

    public static boolean matchRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        SavedRequest originalRequest = (SavedRequest)request.getSession().getAttribute(ORIGINAL_REQUEST);
        if (originalRequest == null) {
            return false;
        }
        String requestURI = request.getRequestURI();
        return requestURI != null && requestURI.equals(originalRequest.getRequestURI());
    }

    public static boolean hasRequest(HttpServletRequest request) {
        return request.getSession().getAttribute(ORIGINAL_REQUEST) != null;
    }

    public static SavedRequest getRequest(HttpServletRequest request) {
        return (SavedRequest)request.getSession().getAttribute(ORIGINAL_REQUEST);
    }

    public static void saveAuthentication(HttpServletRequest request, Principal principal, Set<String> groups) {
        SavedAuthentication savedAuthentication = new SavedAuthentication(principal, groups);
        request.getSession().setAttribute(AUTHENTICATION, (Object)savedAuthentication);
    }

    public static boolean hasAuthentication(HttpServletRequest request) {
        return request.getSession().getAttribute(AUTHENTICATION) != null;
    }

    public static SavedAuthentication getAuthentication(HttpServletRequest request) {
        return (SavedAuthentication)request.getSession().getAttribute(AUTHENTICATION);
    }

    public static void clearRequestAndAuthentication(HttpServletRequest request) {
        request.getSession().removeAttribute(ORIGINAL_REQUEST);
        request.getSession().removeAttribute(AUTHENTICATION);
    }
}

