/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.util.TypeLiteral;
import javax.security.enterprise.authentication.mechanism.http.BasicAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.CustomFormAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.FormAuthenticationMechanismDefinition;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.LoginToContinue;
import javax.security.enterprise.identitystore.DatabaseIdentityStoreDefinition;
import javax.security.enterprise.identitystore.IdentityStore;
import javax.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import org.apache.tomee.security.TomEEELInvocationHandler;
import org.apache.tomee.security.TomEEPbkdf2PasswordHash;
import org.apache.tomee.security.TomEEPlaintextPasswordHash;
import org.apache.tomee.security.TomEESecurityContext;
import org.apache.tomee.security.cdi.AutoApplySessionInterceptor;
import org.apache.tomee.security.cdi.BasicAuthenticationMechanism;
import org.apache.tomee.security.cdi.CustomFormAuthenticationMechanism;
import org.apache.tomee.security.cdi.DefaultAuthenticationMechanism;
import org.apache.tomee.security.cdi.FormAuthenticationMechanism;
import org.apache.tomee.security.cdi.LoginToContinueInterceptor;
import org.apache.tomee.security.cdi.RememberMeInterceptor;
import org.apache.tomee.security.cdi.TomEESecurityServletAuthenticationMechanismMapper;
import org.apache.tomee.security.cdi.TomcatUserIdentityStoreDefinition;
import org.apache.tomee.security.identitystore.TomEEDatabaseIdentityStore;
import org.apache.tomee.security.identitystore.TomEEDefaultIdentityStore;
import org.apache.tomee.security.identitystore.TomEEIdentityStoreHandler;
import org.apache.tomee.security.identitystore.TomEELDAPIdentityStore;

public class TomEESecurityExtension
implements Extension {
    final List<Class<? extends Annotation>> annotationsToFind = Arrays.asList(TomcatUserIdentityStoreDefinition.class, DatabaseIdentityStoreDefinition.class, LdapIdentityStoreDefinition.class, BasicAuthenticationMechanismDefinition.class, FormAuthenticationMechanismDefinition.class, CustomFormAuthenticationMechanismDefinition.class);
    private final AtomicReference<Annotated> basicMechanism = new AtomicReference();
    private final AtomicReference<Annotated> formMechanism = new AtomicReference();
    private final AtomicReference<Annotated> customMechanism = new AtomicReference();
    private final AtomicReference<Annotated> tomcatUserStore = new AtomicReference();
    private final AtomicReference<Annotated> databaseStore = new AtomicReference();
    private final AtomicReference<Annotated> ldapStore = new AtomicReference();
    private boolean applicationAuthenticationMechanisms = false;

    void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(DefaultAuthenticationMechanism.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEESecurityServletAuthenticationMechanismMapper.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEEIdentityStoreHandler.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEEPbkdf2PasswordHash.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEEPlaintextPasswordHash.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(AutoApplySessionInterceptor.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(RememberMeInterceptor.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(LoginToContinueInterceptor.class));
        beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(TomEESecurityContext.class));
    }

    public <T> void processBean(@Observes ProcessBean<T> eventIn, BeanManager beanManager) {
        Annotated annotatedType = eventIn.getAnnotated();
        if (this.tomcatUserStore.get() == null && annotatedType.isAnnotationPresent(TomcatUserIdentityStoreDefinition.class)) {
            this.tomcatUserStore.set(annotatedType);
        }
        if (this.databaseStore.get() == null && annotatedType.isAnnotationPresent(DatabaseIdentityStoreDefinition.class)) {
            this.databaseStore.set(annotatedType);
        }
        if (this.ldapStore.get() == null && annotatedType.isAnnotationPresent(LdapIdentityStoreDefinition.class)) {
            this.ldapStore.set(annotatedType);
        }
        if (this.basicMechanism.get() == null && annotatedType.isAnnotationPresent(BasicAuthenticationMechanismDefinition.class)) {
            this.basicMechanism.set(annotatedType);
        }
        if (this.formMechanism.get() == null && annotatedType.isAnnotationPresent(FormAuthenticationMechanismDefinition.class)) {
            this.formMechanism.set(annotatedType);
        }
        if (this.customMechanism.get() == null && annotatedType.isAnnotationPresent(CustomFormAuthenticationMechanismDefinition.class)) {
            this.customMechanism.set(annotatedType);
        }
        if (eventIn.getBean().getTypes().contains(HttpAuthenticationMechanism.class)) {
            this.applicationAuthenticationMechanisms = true;
        }
    }

    void registerAuthenticationMechanism(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.tomcatUserStore.get() != null) {
            afterBeanDiscovery.addBean().id(TomEEDefaultIdentityStore.class.getName() + "#" + TomcatUserIdentityStoreDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<TomcatUserIdentityStoreDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createTomcatUserIdentityStoreDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(TomEEDefaultIdentityStore.class.getName()).beanClass(TomEEDefaultIdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, TomEEDefaultIdentityStore.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(TomEEDefaultIdentityStore.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (TomEEDefaultIdentityStore)beanManager.createBean(beanAttributes, TomEEDefaultIdentityStore.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.databaseStore.get() != null) {
            afterBeanDiscovery.addBean().id(TomEEDatabaseIdentityStore.class.getName() + "#" + DatabaseIdentityStoreDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<DatabaseIdentityStoreDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createDatabaseIdentityStoreDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(TomEEDatabaseIdentityStore.class.getName()).beanClass(TomEEDatabaseIdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, TomEEDatabaseIdentityStore.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(TomEEDatabaseIdentityStore.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (TomEEDatabaseIdentityStore)beanManager.createBean(beanAttributes, TomEEDatabaseIdentityStore.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.ldapStore.get() != null) {
            afterBeanDiscovery.addBean().id(TomEELDAPIdentityStore.class.getName() + "#" + LdapIdentityStoreDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<LdapIdentityStoreDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createLdapIdentityStoreDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(TomEELDAPIdentityStore.class.getName()).beanClass(TomEELDAPIdentityStore.class).types(new Type[]{Object.class, IdentityStore.class, TomEELDAPIdentityStore.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(TomEELDAPIdentityStore.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (TomEELDAPIdentityStore)beanManager.createBean(beanAttributes, TomEELDAPIdentityStore.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.basicMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(BasicAuthenticationMechanism.class.getName() + "#" + BasicAuthenticationMechanismDefinition.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<BasicAuthenticationMechanismDefinition>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createBasicAuthenticationMechanismDefinitionSupplier(beanManager));
            afterBeanDiscovery.addBean().id(BasicAuthenticationMechanism.class.getName()).beanClass(BasicAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, BasicAuthenticationMechanism.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(BasicAuthenticationMechanism.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (BasicAuthenticationMechanism)beanManager.createBean(beanAttributes, BasicAuthenticationMechanism.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.formMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(FormAuthenticationMechanism.class.getName() + "#" + LoginToContinue.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<LoginToContinue>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createFormLoginToContinueSupplier(beanManager));
            afterBeanDiscovery.addBean().id(FormAuthenticationMechanism.class.getName()).beanClass(FormAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, FormAuthenticationMechanism.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(FormAuthenticationMechanism.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (FormAuthenticationMechanism)beanManager.createBean(beanAttributes, FormAuthenticationMechanism.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
        if (this.customMechanism.get() != null) {
            afterBeanDiscovery.addBean().id(CustomFormAuthenticationMechanism.class.getName() + "#" + LoginToContinue.class.getName()).beanClass(Supplier.class).addType(Object.class).addType((TypeLiteral)new TypeLiteral<Supplier<LoginToContinue>>(){}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> this.createCustomFormLoginToContinueSupplier(beanManager));
            afterBeanDiscovery.addBean().id(CustomFormAuthenticationMechanism.class.getName()).beanClass(CustomFormAuthenticationMechanism.class).types(new Type[]{Object.class, HttpAuthenticationMechanism.class, CustomFormAuthenticationMechanism.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(creationalContext -> {
                AnnotatedType annotatedType = beanManager.createAnnotatedType(CustomFormAuthenticationMechanism.class);
                BeanAttributes beanAttributes = beanManager.createBeanAttributes(annotatedType);
                return (CustomFormAuthenticationMechanism)beanManager.createBean(beanAttributes, CustomFormAuthenticationMechanism.class, beanManager.getInjectionTargetFactory(annotatedType)).create(creationalContext);
            });
        }
    }

    public boolean hasAuthenticationMechanisms() {
        return this.basicMechanism.get() != null || this.formMechanism.get() != null || this.customMechanism.get() != null || this.applicationAuthenticationMechanisms;
    }

    private Supplier<LoginToContinue> createFormLoginToContinueSupplier(BeanManager beanManager) {
        return () -> {
            LoginToContinue loginToContinue = ((FormAuthenticationMechanismDefinition)this.formMechanism.get().getAnnotation(FormAuthenticationMechanismDefinition.class)).loginToContinue();
            return TomEEELInvocationHandler.of(LoginToContinue.class, loginToContinue, beanManager);
        };
    }

    private Supplier<BasicAuthenticationMechanismDefinition> createBasicAuthenticationMechanismDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            BasicAuthenticationMechanismDefinition annotation = (BasicAuthenticationMechanismDefinition)this.basicMechanism.get().getAnnotation(BasicAuthenticationMechanismDefinition.class);
            return TomEEELInvocationHandler.of(BasicAuthenticationMechanismDefinition.class, annotation, beanManager);
        };
    }

    private Supplier<LoginToContinue> createCustomFormLoginToContinueSupplier(BeanManager beanManager) {
        return () -> {
            LoginToContinue annotation = ((CustomFormAuthenticationMechanismDefinition)this.customMechanism.get().getAnnotation(CustomFormAuthenticationMechanismDefinition.class)).loginToContinue();
            return TomEEELInvocationHandler.of(LoginToContinue.class, annotation, beanManager);
        };
    }

    private Supplier<TomcatUserIdentityStoreDefinition> createTomcatUserIdentityStoreDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            TomcatUserIdentityStoreDefinition annotation = (TomcatUserIdentityStoreDefinition)this.tomcatUserStore.get().getAnnotation(TomcatUserIdentityStoreDefinition.class);
            return TomEEELInvocationHandler.of(TomcatUserIdentityStoreDefinition.class, annotation, beanManager);
        };
    }

    private Supplier<DatabaseIdentityStoreDefinition> createDatabaseIdentityStoreDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            DatabaseIdentityStoreDefinition annotation = (DatabaseIdentityStoreDefinition)this.databaseStore.get().getAnnotation(DatabaseIdentityStoreDefinition.class);
            return TomEEELInvocationHandler.of(DatabaseIdentityStoreDefinition.class, annotation, beanManager);
        };
    }

    private Supplier<LdapIdentityStoreDefinition> createLdapIdentityStoreDefinitionSupplier(BeanManager beanManager) {
        return () -> {
            LdapIdentityStoreDefinition annotation = (LdapIdentityStoreDefinition)this.ldapStore.get().getAnnotation(LdapIdentityStoreDefinition.class);
            return TomEEELInvocationHandler.of(LdapIdentityStoreDefinition.class, annotation, beanManager);
        };
    }
}

