/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.util.HashMap;
import java.util.Map;
import javax.batch.api.chunk.CheckpointAlgorithm;
import javax.batch.api.chunk.ItemReader;
import javax.batch.api.chunk.ItemWriter;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.impl.controller.chunk.CheckpointData;
import org.apache.batchee.container.impl.controller.chunk.CheckpointDataKey;
import org.apache.batchee.container.impl.controller.chunk.CheckpointType;
import org.apache.batchee.spi.DataRepresentationService;
import org.apache.batchee.spi.PersistenceManagerService;

public class CheckpointManager {
    private final PersistenceManagerService persistenceManagerService;
    private final DataRepresentationService dataRepresentationService;
    private final ItemReader readerProxy;
    private final ItemWriter writerProxy;
    private final CheckpointAlgorithm checkpointAlgorithm;
    private final String stepId;
    private final long jobInstanceID;

    public CheckpointManager(ItemReader reader, ItemWriter writer, CheckpointAlgorithm chkptAlg, long jobInstanceID, String stepId, PersistenceManagerService persistenceManagerService, DataRepresentationService dataRepresentationService) {
        this.readerProxy = reader;
        this.writerProxy = writer;
        this.checkpointAlgorithm = chkptAlg;
        this.stepId = stepId;
        this.jobInstanceID = jobInstanceID;
        this.persistenceManagerService = persistenceManagerService;
        this.dataRepresentationService = dataRepresentationService;
    }

    public void beginCheckpoint() {
        try {
            this.checkpointAlgorithm.beginCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm beginCheckpoint() failed", e);
        }
    }

    public void endCheckpoint() {
        try {
            this.checkpointAlgorithm.endCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm endCheckpoint() failed", e);
        }
    }

    public boolean applyCheckPointPolicy() {
        try {
            return this.checkpointAlgorithm.isReadyToCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm failed", e);
        }
    }

    public Map<CheckpointDataKey, CheckpointData> prepareCheckpoints() {
        HashMap<CheckpointDataKey, CheckpointData> checkpoints = new HashMap<CheckpointDataKey, CheckpointData>(2);
        try {
            byte[] checkpointBytes = this.dataRepresentationService.toInternalRepresentation(this.readerProxy.checkpointInfo());
            CheckpointData readerChkptData = new CheckpointData(this.jobInstanceID, this.stepId, CheckpointType.READER);
            readerChkptData.setRestartToken(checkpointBytes);
            CheckpointDataKey readerChkptDK = new CheckpointDataKey(this.jobInstanceID, this.stepId, CheckpointType.READER);
            checkpoints.put(readerChkptDK, readerChkptData);
            checkpointBytes = this.dataRepresentationService.toInternalRepresentation(this.writerProxy.checkpointInfo());
            CheckpointData writerChkptData = new CheckpointData(this.jobInstanceID, this.stepId, CheckpointType.WRITER);
            writerChkptData.setRestartToken(checkpointBytes);
            CheckpointDataKey writerChkptDK = new CheckpointDataKey(this.jobInstanceID, this.stepId, CheckpointType.WRITER);
            checkpoints.put(writerChkptDK, writerChkptData);
        }
        catch (Exception ex) {
            throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.stepId + "]", ex);
        }
        return checkpoints;
    }

    public void storeCheckPoints(Map<CheckpointDataKey, CheckpointData> checkpoints) {
        try {
            for (Map.Entry<CheckpointDataKey, CheckpointData> checkpointEntry : checkpoints.entrySet()) {
                this.persistenceManagerService.setCheckpointData(checkpointEntry.getKey(), checkpointEntry.getValue());
            }
        }
        catch (Exception ex) {
            throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.stepId + "]", ex);
        }
    }

    public int checkpointTimeout() {
        try {
            return this.checkpointAlgorithm.checkpointTimeout();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm checkpointTimeout() failed", e);
        }
    }
}

