/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.cdi;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Priority;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.opentracing.Traced;

@Traced
@Interceptor
@Priority(value=1000)
public class TracedInterceptor
implements Serializable {
    @Inject
    private Tracer tracer;
    @Inject
    @Intercepted
    private Bean<?> bean;
    @Inject
    private BeanManager beanManager;
    private transient ConcurrentMap<Method, Meta> metas = new ConcurrentHashMap<Method, Meta>();

    @AroundInvoke
    public Object trace(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Meta meta = (Meta)this.metas.get(method);
        if (meta == null) {
            AnnotatedType annotatedType = this.beanManager.createAnnotatedType(this.bean.getBeanClass());
            Traced traced = Objects.requireNonNull(annotatedType.getMethods().stream().filter(m -> m.getJavaMember().equals(method)).findFirst().map(m -> (Traced)m.getAnnotation(Traced.class)).orElseGet(() -> (Traced)annotatedType.getAnnotation(Traced.class)), "no @Traced found on " + method);
            meta = new Meta(traced.value(), Optional.of(traced.operationName()).filter(v -> !v.isEmpty()).orElseGet(() -> method.getDeclaringClass().getName() + "." + method.getName()));
            this.metas.putIfAbsent(method, meta);
        }
        if (!meta.traced) {
            return context.proceed();
        }
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(meta.operationName);
        Scope parent = this.tracer.scopeManager().active();
        if (parent != null) {
            spanBuilder.asChildOf(parent.span());
        }
        try (Scope scope = spanBuilder.startActive(true);){
            Object object = context.proceed();
            return object;
        }
    }

    private static class Meta {
        private final boolean traced;
        private final String operationName;

        private Meta(boolean traced, String name) {
            this.traced = traced;
            this.operationName = name;
        }
    }
}

