/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.shared.component.EscapeCapable;
import org.apache.myfaces.shared.renderkit.RendererUtils;
import org.apache.myfaces.shared.renderkit.html.CommonEventUtils;
import org.apache.myfaces.shared.renderkit.html.CommonPropertyUtils;
import org.apache.myfaces.shared.renderkit.html.HTML;
import org.apache.myfaces.shared.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared.renderkit.html.util.ResourceUtils;

public class HtmlTextRendererBase
extends HtmlRenderer {
    private static final Logger log = Logger.getLogger(HtmlTextRendererBase.class.getName());
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder && !(behaviors = ((ClientBehaviorHolder)component).getClientBehaviors()).isEmpty()) {
            ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, facesContext.getResponseWriter());
        }
        if (component instanceof UIInput) {
            this.renderInput(facesContext, component);
        } else if (component instanceof UIOutput) {
            this.renderOutput(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected void renderOutput(FacesContext facesContext, UIComponent component) throws IOException {
        String text = RendererUtils.getStringValue(facesContext, component);
        if (log.isLoggable(Level.FINE)) {
            log.fine("renderOutput '" + text + "'");
        }
        boolean escape = component instanceof HtmlOutputText || component instanceof EscapeCapable ? ((HtmlOutputText)component).isEscape() : RendererUtils.getBooleanAttribute(component, "escape", true);
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                long commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
                if ((commonPropertiesMarked & 0xFFFFFFFFFFFFFFDFL) > 0L) {
                    span = true;
                    writer.startElement("span", component);
                    HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                } else if (CommonPropertyUtils.isIdRenderingNecessary(component)) {
                    span = true;
                    writer.startElement("span", component);
                    writer.writeAttribute("id", (Object)component.getClientId(facesContext), null);
                }
                CommonPropertyUtils.renderUniversalProperties(writer, commonPropertiesMarked, component);
                CommonPropertyUtils.renderStyleProperties(writer, commonPropertiesMarked, component);
                if (this.isRenderOutputEventAttributes()) {
                    HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.EVENT_HANDLER_ATTRIBUTES);
                }
            } else if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    protected boolean isRenderOutputEventAttributes() {
        return true;
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        this.renderInputBegin(facesContext, component);
        this.renderInputEnd(facesContext, component);
    }

    protected void renderInputBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        String inputHtmlType = this.getInputHtmlType(component);
        writer.writeAttribute("type", (Object)inputHtmlType, null);
        this.renderValue(facesContext, component, writer);
        Map behaviors = null;
        if (component instanceof ClientBehaviorHolder) {
            behaviors = ((ClientBehaviorHolder)component).getClientBehaviors();
            long commonPropertiesMarked = 0L;
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                commonPropertiesMarked = CommonPropertyUtils.getCommonPropertiesMarked(component);
            }
            if (behaviors.isEmpty() && this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderChangeEventProperty(writer, commonPropertiesMarked, component);
                CommonPropertyUtils.renderEventProperties(writer, commonPropertiesMarked, component);
                CommonPropertyUtils.renderFieldEventPropertiesWithoutOnchange(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderBehaviorizedOnchangeEventHandler(facesContext, writer, component, behaviors);
                if (this.isCommonEventsOptimizationEnabled(facesContext)) {
                    Long commonEventsMarked = CommonEventUtils.getCommonEventsMarked(component);
                    CommonEventUtils.renderBehaviorizedEventHandlers(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                    CommonEventUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, commonPropertiesMarked, commonEventsMarked, component, behaviors);
                } else {
                    HtmlRendererUtils.renderBehaviorizedEventHandlers(facesContext, writer, component, behaviors);
                    HtmlRendererUtils.renderBehaviorizedFieldEventHandlersWithoutOnchange(facesContext, writer, component, behaviors);
                }
            }
            if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
                CommonPropertyUtils.renderInputPassthroughPropertiesWithoutDisabledAndEvents(writer, commonPropertiesMarked, component);
            } else {
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED_AND_EVENTS);
            }
        } else if (this.isCommonPropertiesOptimizationEnabled(facesContext)) {
            CommonPropertyUtils.renderInputPassthroughPropertiesWithoutDisabled(writer, CommonPropertyUtils.getCommonPropertiesMarked(component), component);
        } else {
            HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        }
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (this.isAutocompleteOff(facesContext, component)) {
            writer.writeAttribute("autocomplete", (Object)AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
    }

    protected void renderValue(FacesContext facesContext, UIComponent component, ResponseWriter writer) throws IOException {
        String value = RendererUtils.getStringValue(facesContext, component);
        if (log.isLoggable(Level.FINE)) {
            log.fine("renderInput '" + value + "'");
        }
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
    }

    protected void renderInputEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlInputText) {
            return ((HtmlInputText)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    protected boolean isAutocompleteOff(FacesContext facesContext, UIComponent component) {
        String autocomplete;
        if (component instanceof HtmlInputText && (autocomplete = ((HtmlInputText)component).getAutocomplete()) != null) {
            return autocomplete.equals(AUTOCOMPLETE_VALUE_OFF);
        }
        return false;
    }

    protected boolean isValidLength(FacesContext facesContext, UIInput input) {
        int maxlength;
        if (input instanceof HtmlInputText && (maxlength = ((HtmlInputText)input).getMaxlength()) >= 0) {
            String clientId = input.getClientId(facesContext);
            String value = (String)facesContext.getExternalContext().getRequestParameterMap().get(clientId);
            if (value != null && value.length() > maxlength) {
                return false;
            }
        }
        return true;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UIInput) {
            if (!this.isValidLength(facesContext, (UIInput)component)) {
                return;
            }
            HtmlRendererUtils.decodeUIInput(facesContext, component);
            if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
                HtmlRendererUtils.decodeClientBehaviors(facesContext, component);
            }
        } else if (!(component instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)component, submittedValue);
    }

    protected String getInputHtmlType(UIComponent component) {
        return "text";
    }

    public static void renderOutputText(FacesContext facesContext, UIComponent component, String text, boolean escape) throws IOException {
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("renderOutputText writing '" + text + "'");
                }
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }
}

