/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.FacesFileNotFoundException;
import com.sun.faces.facelets.compiler.Compiler;
import com.sun.faces.facelets.impl.DefaultFacelet;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.util.Cache;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.Facelet;
import javax.faces.view.facelets.FaceletCache;
import javax.faces.view.facelets.FaceletCacheFactory;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.ResourceResolver;

public class DefaultFaceletFactory {
    protected static final Logger log = FacesLogger.FACELETS_FACTORY.getLogger();
    private Compiler compiler;
    private ResourceResolver resolver;
    private URL baseUrl;
    private long refreshPeriod;
    private FaceletCache<DefaultFacelet> cache;
    private ConcurrentMap<String, FaceletCache<DefaultFacelet>> cachePerContract;
    Cache<String, IdMapper> idMappers;

    public DefaultFaceletFactory() {
        this.compiler = null;
        this.resolver = null;
        this.refreshPeriod = -1L;
        this.cache = null;
        this.baseUrl = null;
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver) throws IOException {
        this(compiler, resolver, -1L, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod) {
        this(compiler, resolver, refreshPeriod, null);
    }

    public DefaultFaceletFactory(Compiler compiler, ResourceResolver resolver, long refreshPeriod, FaceletCache cache) {
        this.init(compiler, resolver, refreshPeriod, cache);
    }

    public final void init(Compiler compiler, ResourceResolver resolver, long refreshPeriod, FaceletCache cache) {
        Util.notNull("compiler", compiler);
        Util.notNull("resolver", resolver);
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            throw new IllegalStateException("DefaultFaceletFactory cannot locate the faces context");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        WebConfiguration config = WebConfiguration.getInstance(externalContext);
        this.compiler = compiler;
        this.cachePerContract = new ConcurrentHashMap<String, FaceletCache<DefaultFacelet>>();
        this.resolver = resolver;
        this.baseUrl = resolver.resolveUrl("/");
        this.idMappers = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.UseFaceletsID) ? null : new Cache<String, IdMapper>(new IdMapperFactory());
        this.refreshPeriod = refreshPeriod = refreshPeriod >= 0L ? refreshPeriod * 1000L : -1L;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Using ResourceResolver: {0}", resolver);
            log.log(Level.FINE, "Using Refresh Period: {0}", refreshPeriod);
        }
        this.cache = this.initCache(cache);
    }

    private FaceletCache<DefaultFacelet> initCache(FaceletCache<DefaultFacelet> cache) {
        if (cache == null) {
            FaceletCacheFactory cacheFactory = (FaceletCacheFactory)FactoryFinder.getFactory("javax.faces.view.facelets.FaceletCacheFactory");
            cache = cacheFactory.getFaceletCache();
        }
        FaceletCache.MemberFactory<DefaultFacelet> faceletFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            @Override
            public DefaultFacelet newInstance(URL key) throws IOException {
                return DefaultFaceletFactory.this.createFacelet(key);
            }
        };
        FaceletCache.MemberFactory<DefaultFacelet> metadataFaceletFactory = new FaceletCache.MemberFactory<DefaultFacelet>(){

            @Override
            public DefaultFacelet newInstance(URL key) throws IOException {
                return DefaultFaceletFactory.this.createMetadataFacelet(key);
            }
        };
        cache.setCacheFactories(faceletFactory, metadataFaceletFactory);
        return cache;
    }

    public ResourceResolver getResourceResolver() {
        return this.resolver;
    }

    public Facelet getFacelet(FacesContext context, String uri) throws IOException {
        return this.getFacelet(context, this.resolveURL(uri));
    }

    public Facelet getMetadataFacelet(FacesContext context, String uri) throws IOException {
        return this.getMetadataFacelet(context, this.resolveURL(uri));
    }

    public URL resolveURL(URL source, String path) throws IOException {
        if (path.startsWith("/")) {
            URL url = this.resolver.resolveUrl(path);
            if (url == null) {
                throw new FacesFileNotFoundException(path + " Not Found in ExternalContext as a Resource");
            }
            return url;
        }
        return new URL(source, path);
    }

    public Facelet getFacelet(FacesContext context, URL url) throws IOException {
        Facelet result = this.getCache(context).getFacelet(url);
        DefaultFacelet _facelet = null;
        if (result instanceof DefaultFacelet) {
            String xmlDecl;
            _facelet = (DefaultFacelet)result;
            String docType = _facelet.getSavedDoctype();
            if (null != docType) {
                Util.saveDOCTYPEToFacesContextAttributes(docType);
            }
            if (null != (xmlDecl = _facelet.getSavedXMLDecl())) {
                Util.saveXMLDECLToFacesContextAttributes(xmlDecl);
            }
        }
        return result;
    }

    public Facelet getMetadataFacelet(FacesContext context, URL url) throws IOException {
        return this.getCache(context).getViewMetadataFacelet(url);
    }

    public boolean needsToBeRefreshed(URL url) {
        if (!this.cache.isFaceletCached(url)) {
            return true;
        }
        if (this.cachePerContract == null) {
            return false;
        }
        for (FaceletCache faceletCache : this.cachePerContract.values()) {
            if (faceletCache.isFaceletCached(url)) continue;
            return true;
        }
        return false;
    }

    private FaceletCache<DefaultFacelet> getCache(FacesContext context) {
        List<String> contracts = context.getResourceLibraryContracts();
        if (!contracts.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < contracts.size(); ++i) {
                builder.append(contracts.get(i));
                if (i + 1 == contracts.size()) continue;
                builder.append(",");
            }
            String contractsKey = builder.toString();
            FaceletCache faceletCache = (FaceletCache)this.cachePerContract.get(contractsKey);
            if (faceletCache == null) {
                faceletCache = this.initCache(null);
                this.cachePerContract.putIfAbsent(contractsKey, faceletCache);
                faceletCache = (FaceletCache)this.cachePerContract.get(contractsKey);
            }
            return faceletCache;
        }
        return this.cache;
    }

    private URL resolveURL(String uri) throws IOException {
        URL url = this.resolveURL(this.baseUrl, uri);
        if (url == null) {
            throw new IOException("'" + uri + "' not found.");
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIComponent _createComponent(FacesContext context, String taglibURI, String tagName, Map<String, Object> attributes) {
        UIComponent result;
        block29: {
            result = null;
            Application app = context.getApplication();
            ExternalContext extContext = context.getExternalContext();
            File tmpDir = (File)extContext.getApplicationMap().get("javax.servlet.context.tempdir");
            File tempFile = null;
            OutputStreamWriter osw = null;
            try {
                String tempId;
                block26: {
                    tempFile = File.createTempFile("mojarra", ".tmp", tmpDir);
                    osw = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), "UTF-8");
                    osw.append("<?xml version='1.0' encoding='");
                    osw.append("UTF-8");
                    osw.append("' ?>");
                    osw.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
                    osw.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"\n");
                    osw.append("      xmlns:j=\"").append(taglibURI).append("\">");
                    osw.append("  <j:").append(tagName).append(" ");
                    if (null != attributes && !attributes.isEmpty()) {
                        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
                            osw.append(attr.getKey()).append("=\"").append(attr.getValue().toString()).append("\"").append(" ");
                        }
                    }
                    tempId = context.getViewRoot().createUniqueId(context, tagName);
                    osw.append(" id=\"").append(tempId).append("\" />");
                    osw.append("</html>");
                    try {
                        osw.flush();
                        osw.close();
                    }
                    catch (IOException ex) {
                        if (!log.isLoggable(Level.FINEST)) break block26;
                        log.log(Level.FINEST, "Flushing and closing stream", ex);
                    }
                }
                URL fabricatedFaceletPage = tempFile.toURI().toURL();
                String alias = taglibURI + ":" + tagName;
                DefaultFacelet f = this.createFacelet(fabricatedFaceletPage, alias);
                UIComponent tmp = app.createComponent("javax.faces.NamingContainer");
                tmp.setId(context.getViewRoot().createUniqueId());
                ((Facelet)f).apply(context, tmp);
                result = tmp.findComponent(tempId);
                tmp.getChildren().clear();
                osw = null;
            }
            catch (MalformedURLException mue) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Invalid URL", mue);
                }
            }
            catch (IOException ioe) {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "I/O error", ioe);
                }
            }
            finally {
                boolean successful;
                block28: {
                    if (null != osw) {
                        try {
                            osw.close();
                        }
                        catch (IOException ioe) {
                            if (!log.isLoggable(Level.FINEST)) break block28;
                            log.log(Level.FINEST, "Closing stream", ioe);
                        }
                    }
                }
                if (null != tempFile && !(successful = tempFile.delete()) && log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Unable to delete temporary file.");
                }
            }
            try {
                byte[] faceletPage = "facelet".getBytes("UTF-8");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(faceletPage);
            }
            catch (UnsupportedEncodingException uee) {
                if (!log.isLoggable(Level.SEVERE)) break block29;
                log.log(Level.SEVERE, "Unsupported encoding when creating component for " + tagName + " in " + taglibURI, uee);
            }
        }
        if (null != result) {
            result.setId(null);
        }
        return result;
    }

    private DefaultFacelet createFacelet(URL url) throws IOException {
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        return this.createFacelet(url, alias);
    }

    private DefaultFacelet createFacelet(URL url, String alias) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Facelet for: " + url);
        }
        try {
            FaceletHandler h = this.compiler.compile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    private DefaultFacelet createMetadataFacelet(URL url) throws IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Creating Metadata Facelet for: " + url);
        }
        String escapedBaseURL = Pattern.quote(this.baseUrl.getFile());
        String alias = '/' + url.getFile().replaceFirst(escapedBaseURL, "");
        try {
            FaceletHandler h = this.compiler.metadataCompile(url, alias);
            return new DefaultFacelet(this, this.compiler.createExpressionFactory(), url, alias, h);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Facelet " + alias + " not found at: " + url.toExternalForm());
        }
    }

    public long getRefreshPeriod() {
        return this.refreshPeriod;
    }

    private static final class IdMapperFactory
    implements Cache.Factory<String, IdMapper> {
        private IdMapperFactory() {
        }

        @Override
        public IdMapper newInstance(String arg) throws InterruptedException {
            return new IdMapper();
        }
    }
}

