/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.StreamReaderDelegate;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.staxutils.PrettyPrintXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.transform.OutTransformWriter;
import org.apache.cxf.wsdl.ExtensionClassCreator;
import org.apache.cxf.wsdl.JAXBExtensibilityElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JAXBExtensionHelper
implements ExtensionSerializer,
ExtensionDeserializer {
    static final Map<Class<?>, Integer> WSDL_INDENT_MAP = new HashMap();
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBExtensionHelper.class);
    private static final int DEFAULT_INDENT_LEVEL = 2;
    final Class<?> typeClass;
    final String namespace;
    Class<?> extensionClass;
    String jaxbNamespace;
    private JAXBContext marshalContext;
    private JAXBContext unmarshalContext;
    private Set<Class<?>> classes;
    private Bus bus;

    public JAXBExtensionHelper(Bus bus, Class<?> cls, String ns) {
        this.typeClass = cls;
        this.namespace = ns;
        this.extensionClass = cls;
        this.bus = bus;
    }

    void setJaxbNamespace(String ns) {
        this.jaxbNamespace = ns;
    }

    void setExtensionClass(Class<?> cls) {
        this.extensionClass = cls;
    }

    private int getIndentLevel(Class<?> parent) {
        Integer result = WSDL_INDENT_MAP.get(parent);
        if (result == null) {
            return 2;
        }
        return result;
    }

    public static void addExtensions(Bus b, ExtensionRegistry registry, String parentType, String elementType) throws JAXBException, ClassNotFoundException {
        Class<?> parentTypeClass = ClassLoaderUtils.loadClass(parentType, JAXBExtensionHelper.class);
        Class<ExtensibilityElement> elementTypeClass = ClassLoaderUtils.loadClass(elementType, JAXBExtensionHelper.class).asSubclass(ExtensibilityElement.class);
        JAXBExtensionHelper.addExtensions(b, registry, parentTypeClass, elementTypeClass, null);
    }

    public static void addExtensions(Bus b, ExtensionRegistry registry, String parentType, String elementType, String namespace) throws JAXBException, ClassNotFoundException {
        Class<?> parentTypeClass = ClassLoaderUtils.loadClass(parentType, JAXBExtensionHelper.class);
        Class<ExtensibilityElement> elementTypeClass = ClassLoaderUtils.loadClass(elementType, JAXBExtensionHelper.class).asSubclass(ExtensibilityElement.class);
        JAXBExtensionHelper.addExtensions(b, registry, parentTypeClass, elementTypeClass, namespace);
    }

    public static void addExtensions(Bus b, ExtensionRegistry registry, Class<?> parentType, Class<?> cls) throws JAXBException {
        JAXBExtensionHelper.addExtensions(b, registry, parentType, cls, null);
    }

    public static void addExtensions(Bus b, ExtensionRegistry registry, Class<?> parentType, Class<?> cls, String namespace) throws JAXBException {
        JAXBExtensionHelper.addExtensions(b, registry, parentType, cls, namespace, cls.getClassLoader());
    }

    public static void addExtensions(Bus b, ExtensionRegistry registry, Class<?> parentType, Class<?> cls, String namespace, ClassLoader loader) throws JAXBException {
        XmlRootElement elAnnot;
        JAXBExtensionHelper helper = new JAXBExtensionHelper(b, cls, namespace);
        ExtensionClassCreator extensionClassCreator = b.getExtension(ExtensionClassCreator.class);
        boolean found = false;
        Class<?> extCls = cls;
        try {
            Method[] methods;
            Class<?> objectFactory = Class.forName(PackageUtils.getPackageName(cls) + ".ObjectFactory", true, loader);
            for (Method method : methods = ReflectionUtil.getDeclaredMethods(objectFactory)) {
                String ns;
                XmlElementDecl elementDecl;
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(cls) || null == (elementDecl = method.getAnnotation(XmlElementDecl.class))) continue;
                String name = elementDecl.name();
                String string = ns = namespace != null ? namespace : elementDecl.namespace();
                if (namespace != null) {
                    helper.setJaxbNamespace(elementDecl.namespace());
                }
                QName elementType = new QName(ns, name);
                if (!ExtensibilityElement.class.isAssignableFrom(extCls)) {
                    extCls = extensionClassCreator.createExtensionClass(cls, elementType, loader);
                    helper.setExtensionClass(extCls);
                }
                registry.registerDeserializer(parentType, elementType, (ExtensionDeserializer)helper);
                registry.registerSerializer(parentType, elementType, (ExtensionSerializer)helper);
                registry.mapExtensionTypes(parentType, elementType, extCls);
                found = true;
            }
        }
        catch (ClassNotFoundException objectFactory) {
            // empty catch block
        }
        if (!found && (elAnnot = cls.getAnnotation(XmlRootElement.class)) != null) {
            String name = elAnnot.name();
            String ns = elAnnot.namespace();
            if (StringUtils.isEmpty(ns) || "##default".equals(ns)) {
                XmlSchema schema = null;
                if (cls.getPackage() != null) {
                    schema = cls.getPackage().getAnnotation(XmlSchema.class);
                }
                if (schema != null) {
                    ns = schema.namespace();
                }
            }
            if (!StringUtils.isEmpty(ns) && !StringUtils.isEmpty(name)) {
                if (namespace != null) {
                    helper.setJaxbNamespace(ns);
                    ns = namespace;
                }
                QName elementType = new QName(ns, name);
                if (!ExtensibilityElement.class.isAssignableFrom(extCls)) {
                    extCls = extensionClassCreator.createExtensionClass(cls, elementType, loader);
                    helper.setExtensionClass(extCls);
                }
                registry.registerDeserializer(parentType, elementType, (ExtensionDeserializer)helper);
                registry.registerSerializer(parentType, elementType, (ExtensionSerializer)helper);
                registry.mapExtensionTypes(parentType, elementType, extCls);
                found = true;
            }
        }
        if (!found) {
            LOG.log(Level.WARNING, "EXTENSION_NOT_REGISTERED", new Object[]{cls.getName(), parentType.getName()});
        }
    }

    private synchronized Unmarshaller createUnmarshaller() throws JAXBException {
        if (this.unmarshalContext == null || this.classes == null) {
            try {
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(this.extensionClass);
                this.classes = ccs.getClasses();
                this.unmarshalContext = ccs.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.unmarshalContext.createUnmarshaller();
    }

    private synchronized Marshaller createMarshaller() throws JAXBException {
        if (this.marshalContext == null || this.classes == null) {
            try {
                JAXBContextCache.CachedContextAndSchemas ccs = JAXBContextCache.getCachedContextAndSchemas(this.typeClass);
                this.classes = ccs.getClasses();
                this.marshalContext = ccs.getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.marshalContext.createMarshaller();
    }

    public void marshall(Class parent, QName qname, ExtensibilityElement obj, PrintWriter pw, Definition wsdl, ExtensionRegistry registry) throws WSDLException {
        try {
            Method[] methods;
            Marshaller u = this.createMarshaller();
            u.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            u.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            u.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Object mObj = obj;
            Class<?> objectFactory = Class.forName(PackageUtils.getPackageName(this.typeClass) + ".ObjectFactory", true, obj.getClass().getClassLoader());
            for (Method method : methods = objectFactory.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(this.typeClass)) continue;
                mObj = method.invoke(objectFactory.newInstance(), obj);
            }
            XMLOutputFactory fact = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = new PrettyPrintXMLStreamWriter(fact.createXMLStreamWriter(pw), 2, this.getIndentLevel(parent));
            if (this.namespace != null && !this.namespace.equals(this.jaxbNamespace)) {
                HashMap<String, String> outMap = new HashMap<String, String>();
                outMap.put("{" + this.jaxbNamespace + "}*", "{" + this.namespace + "}*");
                writer = new OutTransformWriter(writer, outMap, Collections.emptyMap(), Collections.emptyList(), false, "");
            }
            HashMap<String, String> nspref = new HashMap<String, String>();
            Iterator iterator = wsdl.getNamespaces().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry ent;
                Map.Entry entry = ent = iterator.next();
                nspref.put((String)entry.getValue(), (String)entry.getKey());
            }
            JAXBUtils.setNamespaceMapper(this.bus, nspref, u);
            u.marshal(mObj, writer);
            writer.flush();
        }
        catch (Exception ex) {
            throw new WSDLException("PARSER_ERROR", "", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExtensibilityElement unmarshall(Class parent, QName qname, Element element, Definition wsdl, ExtensionRegistry registry) throws WSDLException {
        ExtensibilityElement extensibilityElement;
        XMLStreamReader reader = null;
        Unmarshaller u = null;
        try {
            u = this.createUnmarshaller();
            Object o = null;
            if (this.namespace == null) {
                o = u.unmarshal((Node)element, this.extensionClass);
            } else {
                reader = StaxUtils.createXMLStreamReader(element);
                reader = new MappingReaderDelegate(reader);
                o = u.unmarshal(reader, this.extensionClass);
            }
            if (o != null) {
                o = o.getValue();
            }
            ExtensibilityElement el = o instanceof ExtensibilityElement ? (ExtensibilityElement)o : new JAXBExtensibilityElement(o);
            el.setElementType(qname);
            extensibilityElement = el;
        }
        catch (Exception ex) {
            try {
                throw new WSDLException("PARSER_ERROR", "Error reading element " + qname, (Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    StaxUtils.close(reader);
                }
                catch (XMLStreamException ex2) {
                    throw new WSDLException("PARSER_ERROR", ex2.getMessage(), (Throwable)ex2);
                }
                JAXBUtils.closeUnmarshaller(u);
                throw throwable;
            }
        }
        try {
            StaxUtils.close(reader);
        }
        catch (XMLStreamException ex) {
            throw new WSDLException("PARSER_ERROR", ex.getMessage(), (Throwable)ex);
        }
        JAXBUtils.closeUnmarshaller(u);
        return extensibilityElement;
    }

    static {
        WSDL_INDENT_MAP.put(Definition.class, 2);
        WSDL_INDENT_MAP.put(Binding.class, 4);
        WSDL_INDENT_MAP.put(BindingFault.class, 6);
        WSDL_INDENT_MAP.put(BindingInput.class, 6);
        WSDL_INDENT_MAP.put(BindingOutput.class, 6);
        WSDL_INDENT_MAP.put(BindingOperation.class, 6);
        WSDL_INDENT_MAP.put(Message.class, 4);
        WSDL_INDENT_MAP.put(Operation.class, 6);
        WSDL_INDENT_MAP.put(Port.class, 6);
        WSDL_INDENT_MAP.put(Service.class, 4);
        WSDL_INDENT_MAP.put(Types.class, 4);
    }

    class MappingReaderDelegate
    extends StreamReaderDelegate {
        MappingReaderDelegate(XMLStreamReader reader) {
            super(reader);
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            final NamespaceContext ctx = super.getNamespaceContext();
            return new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    String ns = ctx.getNamespaceURI(prefix);
                    if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                        ns = JAXBExtensionHelper.this.jaxbNamespace;
                    }
                    return ns;
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    if (JAXBExtensionHelper.this.jaxbNamespace.equals(namespaceURI)) {
                        return ctx.getPrefix(JAXBExtensionHelper.this.namespace);
                    }
                    return ctx.getPrefix(namespaceURI);
                }

                public Iterator getPrefixes(String namespaceURI) {
                    if (JAXBExtensionHelper.this.jaxbNamespace.equals(namespaceURI)) {
                        return ctx.getPrefixes(JAXBExtensionHelper.this.namespace);
                    }
                    return ctx.getPrefixes(namespaceURI);
                }
            };
        }

        @Override
        public String getNamespaceURI(int index) {
            String ns = super.getNamespaceURI(index);
            if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                ns = JAXBExtensionHelper.this.jaxbNamespace;
            }
            return ns;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            String ns = super.getNamespaceURI(prefix);
            if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                ns = JAXBExtensionHelper.this.jaxbNamespace;
            }
            return ns;
        }

        @Override
        public QName getName() {
            QName qn = super.getName();
            if (JAXBExtensionHelper.this.namespace.equals(qn.getNamespaceURI())) {
                qn = new QName(JAXBExtensionHelper.this.jaxbNamespace, qn.getLocalPart());
            }
            return qn;
        }

        @Override
        public String getNamespaceURI() {
            String ns = super.getNamespaceURI();
            if (JAXBExtensionHelper.this.namespace.equals(ns)) {
                ns = JAXBExtensionHelper.this.jaxbNamespace;
            }
            return ns;
        }
    }
}

