/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractAttributedInterceptorProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class JAXRSServiceImpl
extends AbstractAttributedInterceptorProvider
implements Service,
Configurable {
    private static final long serialVersionUID = 6765400202555126993L;
    private List<ClassResourceInfo> classResourceInfos;
    private DataBinding dataBinding;
    private Executor executor;
    private Invoker invoker;
    private Map<QName, Endpoint> endpoints = new HashMap<QName, Endpoint>();
    private String address;
    private boolean createServiceModel;
    private QName serviceName;

    public JAXRSServiceImpl(String address, QName qname) {
        this.address = address;
        this.serviceName = qname;
    }

    public JAXRSServiceImpl(List<ClassResourceInfo> cri, QName qname) {
        this.classResourceInfos = cri;
        this.serviceName = qname;
    }

    public JAXRSServiceImpl(List<ClassResourceInfo> cri) {
        this(cri, null);
    }

    public JAXRSServiceImpl(List<ClassResourceInfo> cri, boolean create) {
        this(cri, null);
        this.createServiceModel = create;
    }

    public void setCreateServiceModel(boolean create) {
        this.createServiceModel = create;
    }

    @Override
    public String getBeanName() {
        return this.getName().toString();
    }

    @Override
    public QName getName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        if (this.address == null && !this.classResourceInfos.isEmpty()) {
            Class<?> primaryClass = this.classResourceInfos.get(0).getServiceClass();
            String ns = PackageUtils.getNamespace(PackageUtils.getPackageName(primaryClass));
            return new QName(ns, primaryClass.getSimpleName());
        }
        return new QName(this.address, "WebClient");
    }

    public List<ClassResourceInfo> getClassResourceInfos() {
        return this.classResourceInfos;
    }

    @Override
    public List<ServiceInfo> getServiceInfos() {
        if (!this.createServiceModel) {
            return Collections.emptyList();
        }
        this.put("org.apache.cxf.databinding.namespace", (Object)"true");
        ArrayList<ServiceInfo> infos = new ArrayList<ServiceInfo>();
        for (ClassResourceInfo cri : this.classResourceInfos) {
            ServiceInfo si = new ServiceInfo();
            infos.add(si);
            QName qname = JAXRSUtils.getClassQName(cri.getServiceClass());
            si.setName(qname);
            InterfaceInfo inf = new InterfaceInfo(si, qname);
            si.setInterface(inf);
            for (OperationResourceInfo ori : cri.getMethodDispatcher().getOperationResourceInfos()) {
                Method m = ori.getMethodToInvoke();
                QName oname = new QName(qname.getNamespaceURI(), m.getName());
                OperationInfo oi = inf.addOperation(oname);
                this.createMessagePartInfo(oi, m.getReturnType(), qname, m, false);
                for (Parameter pm : ori.getParameters()) {
                    if (pm.getType() != ParameterType.REQUEST_BODY) continue;
                    this.createMessagePartInfo(oi, ori.getMethodToInvoke().getParameterTypes()[pm.getIndex()], qname, m, true);
                }
            }
        }
        return infos;
    }

    private void createMessagePartInfo(OperationInfo oi, Class<?> type, QName qname, Method m, boolean input) {
        if (type == Void.TYPE || Source.class.isAssignableFrom(type)) {
            return;
        }
        if (InjectionUtils.isPrimitive(type) || Response.class == type) {
            return;
        }
        QName mName = new QName(qname.getNamespaceURI(), (input ? "in" : "out") + m.getName());
        MessageInfo ms = oi.createMessage(mName, input ? MessageInfo.Type.INPUT : MessageInfo.Type.OUTPUT);
        if (input) {
            oi.setInput("in", ms);
        } else {
            oi.setOutput("out", ms);
        }
        QName mpQName = JAXRSUtils.getClassQName(type);
        MessagePartInfo mpi = ms.addMessagePart(mpQName);
        mpi.setConcreteName(mpQName);
        mpi.setTypeQName(mpQName);
        mpi.setTypeClass(type);
    }

    @Override
    public EndpointInfo getEndpointInfo(QName endpoint) {
        return null;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Invoker getInvoker() {
        return this.invoker;
    }

    @Override
    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    @Override
    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    @Override
    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    @Override
    public Map<QName, Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Map<QName, Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public void setProperties(Map<String, Object> properties) {
        this.putAll(properties);
    }
}

