/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.routing;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.ManagedAttribute;
import javax.management.ManagedOperation;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.servlet.ServletException;
import org.apache.openejb.monitoring.DynamicMBeanWrapper;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.routing.Route;
import org.apache.tomee.catalina.routing.RouterException;

public class SimpleRouter {
    private static Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB, SimpleRouter.class);
    private static final Pattern PATTERN = Pattern.compile("(.*)->(.*)");
    private String prefix = "";
    private ObjectName objectName;
    private Route[] routes = new Route[0];
    private final Map<String, Route> cache = new ConcurrentHashMap<String, Route>();

    public SimpleRouter readConfiguration(URL url) {
        if (url == null) {
            return this;
        }
        BufferedReader reader = null;
        try {
            String line;
            BufferedInputStream is = new BufferedInputStream(url.openStream());
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                this.parseRoute(line);
            }
        }
        catch (IOException e) {
            throw new RouterException("can't read " + url.toExternalForm());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.warning(e.getMessage(), (Throwable)e);
                }
            }
        }
        return this;
    }

    private void parseRoute(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (matcher.matches()) {
            String from = this.prefix(matcher.group(1).trim());
            String to = this.prefix(matcher.group(2).trim());
            this.addRoute(new Route().from(from).to(to));
        }
    }

    public String route(String uri) throws IOException, ServletException {
        if (uri == null) {
            return null;
        }
        Route cachedRoute = this.cache.get(uri);
        if (cachedRoute != null) {
            cachedRoute.matches(uri);
            return cachedRoute.cleanDestination(this.prefix);
        }
        for (Route route : this.routes) {
            if (!route.matches(uri)) continue;
            if (route.getOrigin().equals(uri)) {
                this.cache.put(uri, route);
            }
            return route.cleanDestination(this.prefix);
        }
        return null;
    }

    public synchronized void addRoute(Route route) {
        Route[] newRoutes = new Route[this.routes.length + 1];
        System.arraycopy(this.routes, 0, newRoutes, 0, this.routes.length);
        newRoutes[this.routes.length] = route;
        this.routes = newRoutes;
    }

    public void cleanUp() {
        this.JMXOff();
        this.routes = null;
        this.cache.clear();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null || prefix.isEmpty() || prefix.equals("/") ? "" : prefix;
    }

    private String prefix(String value) {
        if (this.prefix != null) {
            return this.prefix + value;
        }
        return value;
    }

    public void JMXOn(String name) {
        ObjectNameBuilder jmxName = new ObjectNameBuilder("openejb.management");
        jmxName.set("J2EEServer", "Router");
        jmxName.set("J2EEApplication", name);
        jmxName.set("Type", "SimpleRouter");
        this.objectName = jmxName.build();
        try {
            LocalMBeanServer.get().registerMBean(new DynamicMBeanWrapper((Object)this), this.objectName);
        }
        catch (Exception e) {
            this.objectName = null;
        }
    }

    public void JMXOff() {
        if (this.objectName != null) {
            try {
                LocalMBeanServer.get().unregisterMBean(this.objectName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @ManagedAttribute
    public TabularData getActiveRoutes() {
        if (this.routes.length == 0) {
            return null;
        }
        OpenType[] types = new OpenType[this.routes.length];
        String[] keys = new String[types.length];
        Object[] values = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = SimpleType.STRING;
            keys[i] = this.routes[i].getOrigin().substring(this.prefix.length());
            values[i] = this.routes[i].getRawDestination().substring(this.prefix.length());
        }
        try {
            CompositeType ct = new CompositeType("routes", "routes", keys, keys, types);
            TabularType type = new TabularType("router", "routes", ct, keys);
            TabularDataSupport data = new TabularDataSupport(type);
            CompositeDataSupport line = new CompositeDataSupport(ct, keys, values);
            data.put(line);
            return data;
        }
        catch (OpenDataException e) {
            return null;
        }
    }

    @ManagedOperation
    public void addRoute(String from, String to) {
        this.addRoute(new Route().from(this.prefix(from)).to(this.prefix(to)));
    }

    @ManagedOperation
    public void removeRoute(String from, String to) {
        if (this.routes.length == 0) {
            return;
        }
        for (int i = 0; i < this.routes.length; ++i) {
            if (!this.routes[i].getOrigin().equals(from) || !this.routes[i].getRawDestination().endsWith(to)) continue;
            Route[] newRoutes = new Route[this.routes.length - 1];
            System.arraycopy(this.routes, 0, newRoutes, 0, i);
            System.arraycopy(this.routes, i + 1, newRoutes, i, this.routes.length - i - 1);
            this.routes = newRoutes;
        }
    }

    public boolean hasPrefix() {
        return this.prefix != null && !this.prefix.isEmpty();
    }

    public String getPrefix() {
        return this.prefix;
    }
}

