/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.routing;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.openejb.loader.SystemInstance;
import org.apache.tomee.catalina.routing.SimpleRouter;

public class RouterValve
extends ValveBase {
    public static final String ROUTER_CONF = "tomee-router.conf";
    public static final String WEB_INF = "/WEB-INF/";
    private SimpleRouter router = new SimpleRouter();

    public void invoke(Request request, Response response) throws IOException, ServletException {
        String destination = this.router.route(request.getRequestURI());
        if (destination == null) {
            this.getNext().invoke(request, response);
            return;
        }
        if (this.router.hasPrefix()) {
            request.getRequestDispatcher(destination).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(destination);
        }
    }

    public void setConfigurationPath(URL configurationPath) {
        this.router.readConfiguration(configurationPath);
    }

    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        this.router.JMXOn("Router Valve " + System.identityHashCode((Object)this));
    }

    protected synchronized void stopInternal() throws LifecycleException {
        this.router.cleanUp();
        super.stopInternal();
    }

    public static URL configurationURL(ServletContext ctx) {
        try {
            return ctx.getResource(WEB_INF + RouterValve.routerConfigurationName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String routerConfigurationName() {
        String conf = SystemInstance.get().getOptions().get("openejb.altdd.prefix", (String)null);
        if (conf == null) {
            return ROUTER_CONF;
        }
        return conf + "." + ROUTER_CONF;
    }

    public static URL serverRouterConfigurationURL() {
        File confDir = SystemInstance.get().getHome().getDirectory();
        File configFile = new File(confDir, "conf/" + RouterValve.routerConfigurationName());
        if (configFile.exists()) {
            try {
                return configFile.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setPrefix(String name) {
        if (name == null || "/".equals(name)) {
            this.router.setPrefix("");
        } else {
            this.router.setPrefix(name);
        }
    }
}

