/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.executable.ExecutableValidator;
import org.apache.tomee.microprofile.jwt.bval.ClassValidationData;
import org.apache.tomee.microprofile.jwt.bval.ClassValidationGenerator;
import org.apache.tomee.microprofile.jwt.bval.ConstraintsClassInstantiationException;
import org.apache.tomee.microprofile.jwt.bval.Generated;
import org.apache.tomee.microprofile.jwt.bval.MissingConstraintsException;
import org.apache.tomee.microprofile.jwt.bval.MissingConstraintsMethodException;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class ValidationConstraints {
    private final Map<Method, Method> validationMethods;
    private final ExecutableValidator validator;
    private final Object instance;

    public ValidationConstraints(Object instance, Map<Method, Method> validationMethods, ExecutableValidator validator) {
        this.validationMethods = validationMethods;
        this.validator = validator;
        this.instance = instance;
    }

    public Set<ConstraintViolation<Object>> validate(Method method, JsonWebToken jsonWebToken) {
        Method constraints = this.validationMethods.get(method);
        if (constraints == null) {
            return Collections.EMPTY_SET;
        }
        return this.validator.validateReturnValue(this.instance, constraints, (Object)jsonWebToken, new Class[0]);
    }

    public static ValidationConstraints of(Class<?> componentClass) {
        Object instance;
        ClassValidationData data = new ClassValidationData(componentClass);
        if (data.getJwtConstraints().size() == 0) {
            return null;
        }
        Class constraintsClazz = new ClassValidationGenerator(data).generate().stream().filter(aClass -> aClass.getName().endsWith("JwtConstraints")).findFirst().orElseThrow(MissingConstraintsException::new);
        HashMap<Method, Method> mapping = new HashMap<Method, Method>();
        Stream.of(constraintsClazz.getMethods()).filter(method -> method.isAnnotationPresent(Generated.class)).forEach(method -> mapping.put(ValidationConstraints.resolve(componentClass, method), (Method)method));
        try {
            instance = constraintsClazz.newInstance();
        }
        catch (Exception e) {
            throw new ConstraintsClassInstantiationException(constraintsClazz, e);
        }
        ExecutableValidator executableValidator = Validation.buildDefaultValidatorFactory().getValidator().forExecutables();
        return new ValidationConstraints(instance, mapping, executableValidator);
    }

    private static Method resolve(Class<?> componentClass, Method method) {
        try {
            return componentClass.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            throw new MissingConstraintsMethodException(componentClass, method);
        }
    }
}

