/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.InjectableMethod;
import org.apache.webbeans.portable.BaseProducerProducer;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.Asserts;

public class ProducerMethodProducer<T, P>
extends BaseProducerProducer<T, P> {
    private Method producerMethod;

    public ProducerMethodProducer(Bean<P> owner, AnnotatedMethod<? super P> producerMethod, AnnotatedMethod<? super P> disposerMethod, Set<InjectionPoint> points, Set<InjectionPoint> disposalIPs, WebBeansContext webBeansContext) {
        super(owner, disposerMethod, points, disposalIPs, webBeansContext);
        Asserts.assertNotNull(producerMethod, "producerMethod");
        if (!producerMethod.isStatic() && owner == null) {
            throw new IllegalArgumentException("owner may not be null for non-static producer method " + producerMethod);
        }
        OpenWebBeansEjbPlugin ejbPlugin = webBeansContext.getPluginLoader().getEjbPlugin();
        this.producerMethod = ejbPlugin != null ? ejbPlugin.resolveViewMethod(owner, producerMethod.getJavaMember()) : producerMethod.getJavaMember();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T produce(Map<Interceptor<?>, ?> interceptors, CreationalContextImpl<T> creationalContext) {
        Object parentInstance = null;
        CreationalContext parentCreationalContext = null;
        try {
            parentCreationalContext = this.webBeansContext.getBeanManagerImpl().createCreationalContext((Contextual)this.owner);
            if (!Modifier.isStatic(this.producerMethod.getModifiers())) {
                parentInstance = this.webBeansContext.getBeanManagerImpl().getReference(this.owner, this.owner.getBeanClass(), parentCreationalContext);
            }
            InjectableMethod<T> m = new InjectableMethod<T>(this.producerMethod, parentInstance, this, creationalContext);
            T t = m.doInjection();
            return t;
        }
        finally {
            if (parentCreationalContext != null) {
                parentCreationalContext.release();
            }
        }
    }
}

