/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class LongArrayDescriptor
extends ArrayDescriptor {
    LongArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    public Serializable readValue(InputStream in, Map offsetMap, Integer key) {
        long[] arr = new long[in.read_long()];
        offsetMap.put(key, arr);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = in.read_longlong();
        }
        return arr;
    }

    public void writeValue(OutputStream out, Serializable value) {
        long[] arr = (long[])value;
        out.write_long(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            out.write_longlong(arr[i]);
        }
    }

    Object copyObject(Object value, CopyState state) {
        if (((long[])value).length == 0) {
            return value;
        }
        Object copy = ((long[])value).clone();
        state.put(value, copy);
        return copy;
    }

    void printFields(PrintWriter pw, Map recurse, Object val) {
        long[] arr = (long[])val;
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            pw.print(arr[i]);
        }
    }
}

