/**
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.apache.openejb.server.cxf.client;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.webservices.saaj.SaajUniverse;

public abstract class SaajInterceptor extends AbstractPhaseInterceptor<Message> {
    private static boolean interceptorsRegistered = false;
    protected SaajUniverse universe;

    public SaajInterceptor(String phase, SaajUniverse universe) {
        super(phase);
        this.universe = universe;
    }

    public static synchronized void registerInterceptors() {
        if (!interceptorsRegistered) {
            final Bus bus = CxfUtil.getBus();
            final ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
            try {
                SaajUniverse universe = new SaajUniverse();
                bus.getOutInterceptors().add(new SaajOutInterceptor(universe));
                bus.getInInterceptors().add(new SaajInInterceptor(universe));
                bus.getInInterceptors().add(new SaajInFaultInterceptor(universe));
            } finally {
                if (oldLoader != null) {
                    CxfUtil.clearBusLoader(oldLoader);
                }
            }
            interceptorsRegistered = true;
        }
    }
}
