/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Tie;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.UtilImpl;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class RMIServant
extends Servant
implements Tie {
    static final Logger logger = Logger.getLogger(RMIServant.class.getName());
    RMIState _state;
    RemoteDescriptor _descriptor;
    byte[] _id;
    private Remote _target = null;

    Class getJavaClass() {
        return this._descriptor.getJavaClass();
    }

    RMIState getRMIState() {
        return this._state;
    }

    public RMIServant(RMIState state) {
        this._state = state;
    }

    public String[] _all_interfaces(POA poa, byte[] objectId) {
        return this._descriptor.all_interfaces();
    }

    static String debug_name(Method m) {
        return m.getDeclaringClass().getName() + "." + m.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OutputStream _invoke(String opName, InputStream _input, ResponseHandler response) throws SystemException {
        MethodDescriptor method = this._descriptor.getMethod(opName);
        if (method == null) {
            this._descriptor.debugMethodMap();
            throw new BAD_OPERATION(opName);
        }
        Method m = method.getReflectedMethod();
        logger.finer(RMIServant.debug_name(m) + ": invoking on " + this._id);
        try {
            java.lang.Object[] args = method.readArguments(_input);
            java.lang.Object result = this.invoke_method(m, args);
            OutputStream _out = response.createReply();
            method.writeResult(_out, result);
            logger.finer(RMIServant.debug_name(m) + ": returning normally");
            return _out;
        }
        catch (SystemException ex) {
            logger.throwing(RMIServant.class.getName(), "_invoke", ex);
            logger.warning(ex.getMessage());
            throw ex;
        }
        catch (UndeclaredThrowableException ex) {
            logger.throwing(RMIServant.class.getName(), "_invoke", ex.getUndeclaredThrowable());
            throw new UnknownException(ex.getUndeclaredThrowable());
        }
        catch (RuntimeException ex) {
            logger.log(Level.FINER, RMIServant.debug_name(m) + ": RuntimeException " + ex.getMessage(), ex);
            return method.writeException(response, ex);
        }
        catch (RemoteException ex) {
            logger.log(Level.FINER, RMIServant.debug_name(m) + ": RemoteException " + ex.getMessage(), ex);
            throw UtilImpl.mapRemoteException(ex);
        }
        catch (Throwable ex) {
            logger.log(Level.FINER, RMIServant.debug_name(m) + ": Throwable " + ex.getMessage(), ex);
            return method.writeException(response, ex);
        }
    }

    java.lang.Object invoke_method(Method m, java.lang.Object[] args) throws RemoteException, Throwable {
        if (this._target != null) {
            try {
                return m.invoke((java.lang.Object)this._target, args);
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.FINER, "Error invoking local method", ex);
                throw ex.getTargetException();
            }
        }
        throw new OBJECT_NOT_EXIST();
    }

    public ORB orb() {
        return this._orb();
    }

    public void orb(ORB orb) {
        try {
            POA _poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            _poa.activate_object((Servant)this);
        }
        catch (InvalidName ex) {
            throw new RuntimeException("ORB must have POA support", ex);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException("wrong policy: " + ex.getMessage(), ex);
        }
        catch (ServantAlreadyActive ex) {
            throw new RuntimeException("already active: " + ex.getMessage(), ex);
        }
    }

    public void deactivate() {
        if (this._get_delegate() == null) {
            throw new RuntimeException("object not active");
        }
        try {
            POA poa = this._state.getPOA();
            byte[] id = poa.servant_to_id((Servant)this);
            poa.deactivate_object(id);
            this._set_delegate(null);
        }
        catch (Throwable ex) {
            logger.throwing("", "deactivate", ex);
            throw new RuntimeException("cannot deactivate: " + ex.getMessage(), ex);
        }
    }

    public Remote getTarget() {
        return this._target;
    }

    public synchronized void setTarget(Remote target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this._descriptor = this._state.getTypeRepository().getRemoteDescriptor(target.getClass()).getRemoteInterface();
        if (this._descriptor == null) {
            throw new RuntimeException("remote classes not supported");
        }
        this._target = target;
    }

    Delegate getDelegate() {
        return this._state.createDelegate(this);
    }

    public Object thisObject() {
        return this._this_object();
    }
}

