/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spring;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.QName;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.configuration.spring.AbstractFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.w3c.dom.Element;

public class JAXRSClientFactoryBeanDefinitionParser
extends AbstractFactoryBeanDefinitionParser {
    public JAXRSClientFactoryBeanDefinitionParser() {
        this.setBeanClass(Object.class);
    }

    @Override
    protected Class<?> getFactoryClass() {
        return JAXRSSpringClientFactoryBean.class;
    }

    @Override
    protected String getFactoryIdSuffix() {
        return ".proxyFactory";
    }

    @Override
    protected String getSuffix() {
        return ".jaxrs-client";
    }

    @Override
    protected void mapAttribute(BeanDefinitionBuilder bean, Element e, String name, String val) {
        if ("serviceName".equals(name)) {
            QName q = this.parseQName(e, val);
            bean.addPropertyValue(name, (Object)q);
        } else if ("basePackages".equals(name)) {
            bean.addPropertyValue("basePackages", ClasspathScanner.parsePackages(val));
        } else {
            this.mapToProperty(bean, name, val);
        }
    }

    @Override
    protected void mapElement(ParserContext ctx, BeanDefinitionBuilder bean, Element el, String name) {
        if ("properties".equals(name) || "headers".equals(name)) {
            Map map = ctx.getDelegate().parseMapElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)map);
        } else if ("executor".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "serviceFactory.executor");
        } else if ("binding".equals(name)) {
            this.setFirstChildAsProperty(el, ctx, bean, "bindingConfig");
        } else if ("inInterceptors".equals(name) || "inFaultInterceptors".equals(name) || "outInterceptors".equals(name) || "outFaultInterceptors".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("features".equals(name) || "providers".equals(name) || "schemaLocations".equals(name) || "modelBeans".equals(name)) {
            List list = ctx.getDelegate().parseListElement(el, (BeanDefinition)bean.getBeanDefinition());
            bean.addPropertyValue(name, (Object)list);
        } else if ("model".equals(name)) {
            List<UserResource> resources = ResourceUtils.getResourcesFromElement(el);
            bean.addPropertyValue("modelBeans", resources);
        } else {
            this.setFirstChildAsProperty(el, ctx, bean, name);
        }
    }

    static Class<?> getServiceClass(Collection<Class<?>> rootClasses) {
        for (Class<?> cls : rootClasses) {
            if (!cls.isInterface()) continue;
            return cls;
        }
        return rootClasses.iterator().next();
    }

    static List<Object> getProviders(ApplicationContext context, Collection<Class<?>> providerClasses) {
        LinkedList<Object> providers = new LinkedList<Object>();
        AutowireCapableBeanFactory beanFactory = context.getAutowireCapableBeanFactory();
        for (Class<?> providerClass : providerClasses) {
            Object bean;
            try {
                bean = beanFactory.createBean(providerClass, 2, true);
            }
            catch (Exception ex) {
                bean = beanFactory.createBean(providerClass);
            }
            providers.add(bean);
        }
        return providers;
    }

    public static class JAXRSSpringClientFactoryBean
    extends JAXRSClientFactoryBean
    implements ApplicationContextAware {
        private List<String> basePackages;

        public void setBasePackages(List<String> basePackages) {
            this.basePackages = basePackages;
        }

        public void setApplicationContext(ApplicationContext ctx) throws BeansException {
            block9: {
                try {
                    if (this.basePackages == null) break block9;
                    Map<Class<Annotation>, Collection<Class<?>>> classes = ClasspathScanner.findClasses(this.basePackages, Path.class, Provider.class);
                    if (classes.get(Path.class).size() > 1) {
                        throw new NoUniqueBeanDefinitionException(Path.class, classes.get(Path.class).size(), "More than one service class (@Path) has been discovered");
                    }
                    AutowireCapableBeanFactory beanFactory = ctx.getAutowireCapableBeanFactory();
                    for (Class<?> providerClass : classes.get(Provider.class)) {
                        Object bean;
                        try {
                            bean = beanFactory.createBean(providerClass, 2, true);
                        }
                        catch (Exception ex) {
                            bean = beanFactory.createBean(providerClass);
                        }
                        this.setProvider(bean);
                    }
                    for (Class<?> serviceClass : classes.get(Path.class)) {
                        this.setServiceClass(serviceClass);
                    }
                }
                catch (IOException ex) {
                    throw new BeanDefinitionStoreException("I/O failure during classpath scanning", (Throwable)ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new BeanCreationException("Failed to create bean from classfile", (Throwable)ex);
                }
            }
            if (this.bus == null) {
                this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus(ctx));
            }
        }
    }
}

