/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.converters;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.eclipse.microprofile.config.spi.Converter;

public abstract class ImplicitConverter {
    public static Converter getImplicitConverter(Class<?> clazz) {
        Converter converter = null;
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "of", String.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "of", CharSequence.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "valueOf", String.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "valueOf", CharSequence.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterCt(clazz, String.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterCt(clazz, CharSequence.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "parse", String.class);
        }
        if (converter == null) {
            converter = ImplicitConverter.hasConverterMethod(clazz, "parse", CharSequence.class);
        }
        return converter;
    }

    private static Converter hasConverterCt(Class<?> clazz, Class<?> paramType) {
        try {
            final Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(paramType);
            if (!declaredConstructor.isAccessible()) {
                declaredConstructor.setAccessible(true);
            }
            return new Converter(){

                public Object convert(String value) {
                    try {
                        return declaredConstructor.newInstance(value);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static Converter hasConverterMethod(Class<?> clazz, String methodName, Class<?> paramType) {
        try {
            final Method method = clazz.getDeclaredMethod(methodName, paramType);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (Modifier.isStatic(method.getModifiers()) && method.getReturnType().equals(clazz)) {
                return new Converter(){

                    public Object convert(String value) {
                        try {
                            return method.invoke(null, value);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Error while converting the value " + value + " to type " + method.getReturnType());
                        }
                    }
                };
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static class ImplicitArrayConverter<T>
    implements Converter<T> {
        private final Converter converter;
        private final Class<?> type;

        public ImplicitArrayConverter(Converter converter, Class<?> type) {
            this.converter = converter;
            this.type = type;
        }

        public T convert(String valueStr) {
            if (valueStr == null) {
                return null;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            StringBuilder currentValue = new StringBuilder();
            int length = valueStr.length();
            for (int i = 0; i < length; ++i) {
                char c = valueStr.charAt(i);
                if (c == '\\') {
                    if (i >= length - 1) continue;
                    char nextC = valueStr.charAt(i + 1);
                    currentValue.append(nextC);
                    ++i;
                    continue;
                }
                if (c == ',') {
                    String trimedVal = currentValue.toString().trim();
                    if (trimedVal.length() > 0) {
                        list.add(this.converter.convert(trimedVal));
                    }
                    currentValue.setLength(0);
                    continue;
                }
                currentValue.append(c);
            }
            String trimedVal = currentValue.toString().trim();
            if (trimedVal.length() > 0) {
                list.add(this.converter.convert(trimedVal));
            }
            Object array = Array.newInstance(this.type, list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
            return (T)array;
        }
    }
}

