/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.apache.openejb.client.AbstractConnectionStrategy;
import org.apache.openejb.client.ClusterMetaData;
import org.apache.openejb.client.event.FailoverSelection;
import org.apache.openejb.client.event.RandomFailoverSelection;

public class RandomConnectionStrategy
extends AbstractConnectionStrategy {
    @Override
    protected FailoverSelection createFailureEvent(Set<URI> remaining, Set<URI> failed, URI uri) {
        return new RandomFailoverSelection(remaining, failed, uri);
    }

    @Override
    protected Iterable<URI> createIterable(ClusterMetaData cluster) {
        return new RandomIterable(cluster);
    }

    public static class RandomIterator<T>
    implements Iterator<T> {
        private final Random random = new Random();
        private final T[] items;
        private int size;

        public RandomIterator(T[] items) {
            this.items = Arrays.copyOf(items, items.length);
            this.size = items.length;
        }

        @Override
        public boolean hasNext() {
            return this.size > 0;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int selected = this.random.nextInt(this.size--);
            T selectedObject = this.items[selected];
            this.items[selected] = this.items[this.size];
            this.items[this.size] = null;
            return selectedObject;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class RandomIterable
    implements Iterable<URI> {
        private final URI[] locations;

        public RandomIterable(ClusterMetaData clusterMetaData) {
            this.locations = clusterMetaData.getLocations();
        }

        @Override
        public Iterator<URI> iterator() {
            return new RandomIterator<URI>(this.locations);
        }
    }
}

