/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina.realm;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.CredentialHandler;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleBase;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomee.catalina.TomEERuntimeException;
import org.apache.tomee.catalina.realm.LowTypedRealm;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.ietf.jgss.GSSContext;

public class LazyRealm
extends LifecycleBase
implements Realm {
    private String realmClass;
    private String properties;
    private boolean cdi;
    private volatile Realm delegate;
    private Context container;
    private CredentialHandler credentialHandler;
    private volatile boolean init;
    private volatile boolean start;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private CreationalContext<Object> creationalContext;

    public void setRealmClass(String realmClass) {
        this.realmClass = realmClass;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setCdi(boolean cdi) {
        this.cdi = cdi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Realm instance() {
        if (this.delegate == null) {
            LazyRealm lazyRealm = this;
            synchronized (lazyRealm) {
                if (this.delegate == null) {
                    WebBeansContext webBeansContext;
                    Object instance;
                    Class<?> clazz;
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (this.container != null && this.container.getLoader() != null && this.container.getLoader().getClassLoader() != null) {
                        cl = this.container.getLoader().getClassLoader();
                    }
                    try {
                        clazz = cl.loadClass(this.realmClass);
                    }
                    catch (ClassNotFoundException e) {
                        throw new TomEERuntimeException(e);
                    }
                    if (!this.cdi) {
                        try {
                            ObjectRecipe recipe = new ObjectRecipe(clazz);
                            recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                            recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                            recipe.allow(Option.FIELD_INJECTION);
                            recipe.allow(Option.PRIVATE_PROPERTIES);
                            if (this.properties != null) {
                                Properties props = new PropertiesAdapter().unmarshal(this.properties.trim().replaceAll("\\p{Space}*(\\p{Alnum}*)=", "\n$1="));
                                recipe.setAllProperties((Map)props);
                            }
                            instance = recipe.create();
                        }
                        catch (Exception e) {
                            throw new TomEERuntimeException(e);
                        }
                    }
                    try {
                        webBeansContext = WebBeansContext.currentInstance();
                        if (webBeansContext == null) {
                            return null;
                        }
                    }
                    catch (IllegalStateException ise) {
                        return null;
                    }
                    BeanManagerImpl bm = webBeansContext.getBeanManagerImpl();
                    Set beans = bm.getBeans(clazz, new Annotation[0]);
                    Bean bean = bm.resolve(beans);
                    if (bean == null) {
                        return null;
                    }
                    this.creationalContext = bm.createCreationalContext(null);
                    instance = bm.getReference(bean, clazz, this.creationalContext);
                    if (instance == null) {
                        throw new TomEERuntimeException("realm can't be retrieved from cdi");
                    }
                    if (instance instanceof Realm) {
                        this.delegate = (Realm)instance;
                        this.delegate.setContainer((Container)this.container);
                        this.delegate.setCredentialHandler(this.credentialHandler);
                        if (Lifecycle.class.isInstance(this.delegate) && this.init) {
                            try {
                                Lifecycle lifecycle = (Lifecycle)Lifecycle.class.cast(this.delegate);
                                lifecycle.init();
                                if (this.start) {
                                    lifecycle.start();
                                }
                            }
                            catch (LifecycleException lifecycleException) {}
                        }
                    } else {
                        this.delegate = new LowTypedRealm(instance);
                        this.delegate.setContainer((Container)this.container);
                        this.delegate.setCredentialHandler(this.credentialHandler);
                    }
                    for (PropertyChangeListener listener : this.support.getPropertyChangeListeners()) {
                        this.delegate.addPropertyChangeListener(listener);
                    }
                }
            }
        }
        return this.delegate;
    }

    private Class<?> loadClass() {
        if (this.container != null && this.container.getLoader() != null && this.container.getLoader().getClassLoader() != null) {
            try {
                return this.container.getLoader().getClassLoader().loadClass(this.realmClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    protected void initInternal() throws LifecycleException {
        Class<?> r = this.loadClass();
        if (r != null && Lifecycle.class.isAssignableFrom(r) && this.instance() != null) {
            ((Lifecycle)Lifecycle.class.cast(this.delegate)).init();
        } else {
            this.init = true;
        }
    }

    protected void startInternal() throws LifecycleException {
        Class<?> r = this.loadClass();
        if (r != null && Lifecycle.class.isAssignableFrom(r) && this.instance() != null) {
            ((Lifecycle)Lifecycle.class.cast(this.instance())).start();
        } else {
            this.start = true;
        }
        this.setState(LifecycleState.STARTING);
    }

    protected void stopInternal() throws LifecycleException {
        Class<?> r = this.loadClass();
        if (r != null && Lifecycle.class.isAssignableFrom(r) && this.instance() != null) {
            ((Lifecycle)Lifecycle.class.cast(this.instance())).stop();
        }
        this.setState(LifecycleState.STOPPING);
    }

    protected void destroyInternal() throws LifecycleException {
        Class<?> r = this.loadClass();
        if (r != null && Lifecycle.class.isAssignableFrom(r) && this.instance() != null) {
            ((Lifecycle)Lifecycle.class.cast(this.instance())).destroy();
        }
    }

    public Container getContainer() {
        if (this.delegate != null) {
            return this.delegate.getContainer();
        }
        return this.container;
    }

    public void setContainer(Container container) {
        container.addLifecycleListener(new LifecycleListener(){

            public void lifecycleEvent(LifecycleEvent event) {
                if ("before_stop".equals(event.getType()) && LazyRealm.this.creationalContext != null) {
                    LazyRealm.this.creationalContext.release();
                }
            }
        });
        if (this.delegate != null) {
            this.delegate.setContainer(container);
        } else {
            this.container = (Context)Context.class.cast(container);
        }
    }

    public CredentialHandler getCredentialHandler() {
        return this.credentialHandler;
    }

    public void setCredentialHandler(CredentialHandler credentialHandler) {
        this.credentialHandler = credentialHandler;
        Class<?> r = this.loadClass();
        if (r != null && this.instance() != null) {
            this.delegate.setCredentialHandler(credentialHandler);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.delegate != null) {
            this.delegate.addPropertyChangeListener(listener);
        }
        this.support.addPropertyChangeListener(listener);
    }

    public Principal authenticate(String s) {
        return this.instance().authenticate(s);
    }

    public Principal authenticate(String username, String credentials) {
        return this.instance().authenticate(username, credentials);
    }

    public Principal authenticate(String username, String digest, String nonce, String nc, String cnonce, String qop, String realm, String md5a2) {
        return this.instance().authenticate(username, digest, nonce, nc, cnonce, qop, realm, md5a2);
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        return this.instance().authenticate(gssContext, storeCreds);
    }

    public Principal authenticate(X509Certificate[] certs) {
        return this.instance().authenticate(certs);
    }

    public void backgroundProcess() {
        if (this.delegate != null) {
            this.instance().backgroundProcess();
        }
    }

    public SecurityConstraint[] findSecurityConstraints(Request request, Context context) {
        return this.instance().findSecurityConstraints(request, context);
    }

    public boolean hasResourcePermission(Request request, Response response, SecurityConstraint[] constraint, Context context) throws IOException {
        return this.instance().hasResourcePermission(request, response, constraint, context);
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String role) {
        return this.instance().hasRole(wrapper, principal, role);
    }

    public boolean hasUserDataPermission(Request request, Response response, SecurityConstraint[] constraint) throws IOException {
        return this.instance().hasUserDataPermission(request, response, constraint);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.delegate != null) {
            this.delegate.removePropertyChangeListener(listener);
        }
        this.support.removePropertyChangeListener(listener);
    }

    public String[] getRoles(Principal principal) {
        return this.instance().getRoles(principal);
    }

    public boolean isAvailable() {
        return true;
    }
}

