/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.activemq.jms2;

import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.resource.spi.TransactionSupport;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQXASslConnectionFactory;
import org.apache.activemq.management.JMSStatsImpl;
import org.apache.activemq.transport.Transport;
import org.apache.openejb.resource.activemq.jms2.JMS2;
import org.apache.openejb.resource.activemq.jms2.JMSContextImpl;
import org.apache.openejb.resource.activemq.jms2.TomEEConnection;
import org.apache.openejb.resource.activemq.jms2.TomEEXAConnection;

public class TomEEConnectionFactory
extends ActiveMQXASslConnectionFactory {
    private final TransactionSupport.TransactionSupportLevel transactionSupportLevel;

    public TomEEConnectionFactory(TransactionSupport.TransactionSupportLevel transactionSupportLevel) {
        this.transactionSupportLevel = transactionSupportLevel;
    }

    protected ActiveMQConnection createActiveMQConnection(Transport transport, JMSStatsImpl stats) throws Exception {
        if (TransactionSupport.TransactionSupportLevel.NoTransaction.equals((Object)this.transactionSupportLevel)) {
            return new TomEEConnection(transport, this.getClientIdGenerator(), this.getConnectionIdGenerator(), stats);
        }
        return new TomEEXAConnection(transport, this.getClientIdGenerator(), this.getConnectionIdGenerator(), stats);
    }

    public JMSContext createContext() {
        boolean inTx = JMS2.inTx();
        int mode = inTx ? -1 : 1;
        return new JMSContextImpl((ConnectionFactory)this, mode, null, null, inTx);
    }

    public JMSContext createContext(int sessionMode) {
        boolean inTx = JMS2.inTx();
        int mode = inTx ? -1 : sessionMode;
        return new JMSContextImpl((ConnectionFactory)this, mode, null, null, inTx);
    }

    public JMSContext createContext(String userName, String password) {
        boolean inTx = JMS2.inTx();
        int mode = inTx ? -1 : 1;
        return new JMSContextImpl((ConnectionFactory)this, mode, userName, password, inTx);
    }

    public JMSContext createContext(String userName, String password, int sessionMode) {
        boolean inTx = JMS2.inTx();
        int mode = inTx ? -1 : sessionMode;
        return new JMSContextImpl((ConnectionFactory)this, mode, userName, password, inTx);
    }
}

