/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.resource.jdbc.managed.xa.DataSourceXADataSource;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private String id;
    private String persistenceUnitName;
    private String persistenceProviderClassName;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.JTA;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final List<URL> jarFileUrls = new ArrayList<URL>();
    private URL persistenceUnitRootUrl;
    private final List<String> managedClassNames = new ArrayList<String>();
    private boolean excludeUnlistedClasses;
    private Properties properties;
    private ClassLoader classLoader;
    private String persistenceXMLSchemaVersion;
    private SharedCacheMode sharedCacheMode = SharedCacheMode.UNSPECIFIED;
    private ValidationMode validationMode;
    private String jtaDataSourceName;
    private String nonJtaDataSourceName;
    private boolean lazilyInitialized;

    public PersistenceUnitInfoImpl() {
        this.persistenceClassLoaderHandler = null;
    }

    public PersistenceUnitInfoImpl(PersistenceClassLoaderHandler persistenceClassLoaderHandler) {
        this.persistenceClassLoaderHandler = persistenceClassLoaderHandler;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(CommonDataSource jtaDataSource) {
        this.jtaDataSource = XADataSource.class.isInstance(jtaDataSource) ? new DataSourceXADataSource(jtaDataSource, OpenEJB.getTransactionManager(), SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class)) : (DataSource)DataSource.class.cast(jtaDataSource);
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(CommonDataSource nonJtaDataSource) {
        this.nonJtaDataSource = XADataSource.class.isInstance(nonJtaDataSource) ? new DataSourceXADataSource(nonJtaDataSource, OpenEJB.getTransactionManager(), SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class)) : (DataSource)DataSource.class.cast(nonJtaDataSource);
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public void setMappingFileNames(List<String> mappingFileNames) {
        if (mappingFileNames == null) {
            throw new NullPointerException("mappingFileNames is null");
        }
        this.mappingFileNames.clear();
        this.mappingFileNames.addAll(mappingFileNames);
    }

    public void addMappingFileName(String mappingFileName) {
        if (mappingFileName == null) {
            throw new NullPointerException("mappingFileName is null");
        }
        this.mappingFileNames.add(mappingFileName);
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setRootUrlAndJarUrls(String persistenceUnitRootUrl, List<String> jarFiles) throws MalformedURLException {
        File root;
        try {
            URI rootUri = URLs.uri(persistenceUnitRootUrl);
            root = new File(rootUri);
        }
        catch (IllegalArgumentException e) {
            root = new File(persistenceUnitRootUrl);
        }
        this.persistenceUnitRootUrl = this.toUrl(root);
        try {
            if (!jarFiles.isEmpty()) {
                File tmpRoot = root.getName().endsWith(".jar") ? root.getParentFile() : root;
                for (String path : jarFiles) {
                    this.jarFileUrls.add(this.toUrl(new File(tmpRoot, path).getCanonicalFile()));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private URL toUrl(File root) throws MalformedURLException {
        if (!root.isFile() && root.getPath().startsWith("jar:file:")) {
            try {
                File file;
                String absolutePath = root.getAbsolutePath();
                int endIndex = absolutePath.indexOf(33);
                if (endIndex > 0 && (file = new File(absolutePath.substring(0, endIndex))).isFile() && file.getName().endsWith(".jar")) {
                    return file.toURI().toURL();
                }
                return new URL(root.getPath());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return root.toURI().toURL();
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void setManagedClassNames(List<String> managedClassNames) {
        if (managedClassNames == null) {
            throw new NullPointerException("managedClassNames is null");
        }
        this.managedClassNames.clear();
        this.managedClassNames.addAll(managedClassNames);
    }

    public void addManagedClassName(String className) {
        this.managedClassNames.add(className);
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.persistenceClassLoaderHandler != null) {
            PersistenceClassFileTransformer classFileTransformer = new PersistenceClassFileTransformer(classTransformer);
            this.persistenceClassLoaderHandler.addTransformer(this.id, this.classLoader, classFileTransformer);
        }
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.persistenceClassLoaderHandler != null) {
            return this.persistenceClassLoaderHandler.getNewTempClassLoader(this.classLoader);
        }
        return null;
    }

    public boolean isLazilyInitialized() {
        return this.lazilyInitialized;
    }

    public void setLazilyInitialized(boolean lazilyInitialized) {
        this.lazilyInitialized = lazilyInitialized;
    }

    public static boolean isServerClass(String input) {
        String name = input;
        if (name == null) {
            return false;
        }
        if (name.startsWith("openejb.shade.")) {
            name = name.substring("openejb.shade.".length());
        }
        for (String prefix : URLClassLoaderFirst.FORCED_SKIP) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        for (String prefix : URLClassLoaderFirst.FORCED_LOAD) {
            if (!name.startsWith(prefix)) continue;
            return false;
        }
        if (name.startsWith("java.")) {
            return true;
        }
        if (name.startsWith("javax.")) {
            return true;
        }
        if (name.startsWith("jakarta.")) {
            return true;
        }
        if (name.startsWith("sun.")) {
            return true;
        }
        if (name.startsWith("com.sun.")) {
            return true;
        }
        if (name.startsWith("org.")) {
            String org = name.substring("org.".length());
            if (org.startsWith("apache.")) {
                String apache = org.substring("apache.".length());
                if (apache.startsWith("bval.")) {
                    return true;
                }
                if (apache.startsWith("openjpa.")) {
                    return true;
                }
                if (apache.startsWith("derby.")) {
                    return true;
                }
                if (apache.startsWith("xbean.")) {
                    return true;
                }
                if (apache.startsWith("geronimo.")) {
                    return true;
                }
                if (apache.startsWith("coyote")) {
                    return true;
                }
                if (apache.startsWith("webbeans.")) {
                    return true;
                }
                if (apache.startsWith("log4j")) {
                    return true;
                }
                if (apache.startsWith("catalina")) {
                    return true;
                }
                if (apache.startsWith("jasper.")) {
                    return true;
                }
                if (apache.startsWith("tomcat.")) {
                    return true;
                }
                if (apache.startsWith("el.")) {
                    return true;
                }
                if (apache.startsWith("jsp")) {
                    return true;
                }
                if (apache.startsWith("naming")) {
                    return true;
                }
                if (apache.startsWith("taglibs.")) {
                    return true;
                }
                if (apache.startsWith("openejb.")) {
                    return true;
                }
                if (apache.startsWith("openjpa.")) {
                    return true;
                }
                if (apache.startsWith("myfaces.")) {
                    return true;
                }
                if (apache.startsWith("juli.")) {
                    return true;
                }
                if (apache.startsWith("webbeans.")) {
                    return true;
                }
                if (apache.startsWith("cxf.")) {
                    return true;
                }
                if (apache.startsWith("activemq.")) {
                    return true;
                }
                if (apache.startsWith("commons.")) {
                    String commons = apache.substring("commons.".length());
                    if (commons.startsWith("beanutils")) {
                        return true;
                    }
                    if (commons.startsWith("cli")) {
                        return true;
                    }
                    if (commons.startsWith("codec")) {
                        return true;
                    }
                    if (commons.startsWith("collections")) {
                        return true;
                    }
                    if (commons.startsWith("dbcp")) {
                        return true;
                    }
                    if (commons.startsWith("digester")) {
                        return true;
                    }
                    if (commons.startsWith("jocl")) {
                        return true;
                    }
                    if (commons.startsWith("lang")) {
                        return true;
                    }
                    if (commons.startsWith("logging")) {
                        return false;
                    }
                    if (commons.startsWith("pool")) {
                        return true;
                    }
                    return commons.startsWith("net");
                }
                return false;
            }
            if (org.startsWith("codehaus.swizzle")) {
                return true;
            }
            if (org.startsWith("w3c.dom")) {
                return true;
            }
            if (org.startsWith("quartz")) {
                return true;
            }
            if (org.startsWith("eclipse.jdt.")) {
                return true;
            }
            if (org.startsWith("slf4j")) {
                return true;
            }
            if (org.startsWith("openejb")) {
                return true;
            }
            if (org.startsWith("hsqldb")) {
                return true;
            }
            return org.startsWith("hibernate");
        }
        if (name.startsWith("com.sun.")) {
            return true;
        }
        if (name.startsWith("jdk.")) {
            return true;
        }
        if (name.startsWith("javassist")) {
            return true;
        }
        return name.startsWith("serp.");
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public void setPersistenceXMLSchemaVersion(String persistenceXMLSchemaVersion) {
        this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = null != sharedCacheMode ? sharedCacheMode : SharedCacheMode.UNSPECIFIED;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public String getJtaDataSourceName() {
        return this.jtaDataSourceName;
    }

    public void setJtaDataSourceName(String jtaDataSourceName) {
        this.jtaDataSourceName = jtaDataSourceName;
    }

    public String getNonJtaDataSourceName() {
        return this.nonJtaDataSourceName;
    }

    public void setNonJtaDataSourceName(String nonJtaDataSourceName) {
        this.nonJtaDataSourceName = nonJtaDataSourceName;
    }

    public static class PersistenceClassFileTransformer
    implements ClassFileTransformer {
        private final ClassTransformer classTransformer;

        public PersistenceClassFileTransformer(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            if (className == null) {
                return classfileBuffer;
            }
            String replace = className.replace('/', '.');
            if (PersistenceUnitInfoImpl.isServerClass(replace)) {
                return classfileBuffer;
            }
            return this.classTransformer.transform(classLoader, replace, classBeingRedefined, protectionDomain, classfileBuffer);
        }
    }
}

