/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.apache.geronimo.microprofile.opentracing.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.microprofile.cdi.TracedExecutorService;
import org.apache.geronimo.microprofile.opentracing.microprofile.thread.OpenTracingExecutorService;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.ZipkinConverter;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.ZipkinLogger;
import org.eclipse.microprofile.opentracing.Traced;

public class OpenTracingExtension
implements Extension {
    private GeronimoOpenTracingConfig config;
    private Collection<String> instrumentedExecutorServices;
    private boolean useZipkin;
    private boolean useZipkinLogger;

    void onStart(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.config = GeronimoOpenTracingConfig.create();
        this.useZipkin = Boolean.parseBoolean(this.config.read("span.converter.zipkin.active", "true"));
        this.useZipkinLogger = this.useZipkin && Boolean.parseBoolean(this.config.read("span.converter.zipkin.logger.active", "true"));
        this.instrumentedExecutorServices = Optional.ofNullable(this.config.read("cdi.executorServices.wrappedNames", null)).map(s -> Stream.of(s.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toSet())).orElse(null);
    }

    void zipkinConverterToggle(@Observes ProcessAnnotatedType<ZipkinConverter> onZipkinConverter) {
        if (!this.useZipkin) {
            onZipkinConverter.veto();
        }
    }

    void zipkinLoggerToggle(@Observes ProcessAnnotatedType<ZipkinLogger> onZipkinLogger) {
        if (!this.useZipkinLogger) {
            onZipkinLogger.veto();
        }
    }

    <T> void removeTracedFromJaxRsEndpoints(@Observes @WithAnnotations(value={Traced.class}) ProcessAnnotatedType<T> pat) {
        if (this.isJaxRs(pat.getAnnotatedType())) {
            AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
            configurator.remove(it -> it.annotationType() == Traced.class);
            configurator.methods().stream().filter(m -> this.isJaxRs(m.getAnnotated())).forEach(m -> m.remove(it -> it.annotationType() == Traced.class));
        }
    }

    <T> void instrumentExecutorServices(@Observes ProcessAnnotatedType<T> pat) {
        Set typeClosure = pat.getAnnotatedType().getTypeClosure();
        if (typeClosure.contains(ExecutorService.class) && !typeClosure.contains(OpenTracingExecutorService.class)) {
            pat.configureAnnotatedType().add((Annotation)TracedExecutorService.Literal.INSTANCE);
        }
    }

    void addConfigAsBean(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addBean().id(OpenTracingExtension.class.getName() + "#" + GeronimoOpenTracingConfig.class.getName()).beanClass(GeronimoOpenTracingConfig.class).types(new Type[]{GeronimoOpenTracingConfig.class, Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(ctx -> this.config);
    }

    private <T> boolean isJaxRs(AnnotatedType<T> annotatedType) {
        return annotatedType.getAnnotations().stream().anyMatch(it -> it.annotationType() == Path.class) || annotatedType.getMethods().stream().anyMatch(this::isJaxRs);
    }

    private <T> boolean isJaxRs(AnnotatedMethod<? super T> m) {
        return m.getAnnotations().stream().anyMatch(it -> it.annotationType().isAnnotationPresent(HttpMethod.class));
    }
}

