/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.batchee.container.exception.BatchContainerRuntimeException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.spi.JobXMLLoaderService;

public class DefaultJobXMLLoaderService
implements JobXMLLoaderService {
    private static final String PREFIX = "META-INF/batch-jobs/";

    @Override
    public String loadJSL(String id) {
        String jobXML = DefaultJobXMLLoaderService.loadJobFromBatchJobs(id);
        if (jobXML == null) {
            throw new BatchContainerServiceException("Could not load job xml with id: " + id);
        }
        return jobXML;
    }

    private static String loadJobFromBatchJobs(String id) {
        String relativePath;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        InputStream stream = tccl.getResourceAsStream(relativePath = PREFIX + id + ".xml");
        if (stream == null) {
            throw new BatchContainerRuntimeException(new FileNotFoundException("Cannot find an XML file under META-INF/batch-jobs/ with the following name " + id + ".xml"));
        }
        return DefaultJobXMLLoaderService.readJobXML(stream);
    }

    private static String readJobXML(InputStream stream) {
        StringBuilder out = new StringBuilder();
        try {
            int i;
            byte[] b = new byte[4096];
            while ((i = stream.read(b)) != -1) {
                out.append(new String(b, 0, i));
            }
        }
        catch (FileNotFoundException e) {
            throw new BatchContainerServiceException(e);
        }
        catch (IOException e) {
            throw new BatchContainerServiceException(e);
        }
        return out.toString();
    }

    @Override
    public void init(Properties batchConfig) throws BatchContainerServiceException {
    }

    public String toString() {
        return this.getClass().getName();
    }
}

